/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.dijkstra.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.JobIdConfig;
import org.neo4j.gds.config.MutateRelationshipConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.config.SourceNodeConfig;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.paths.TrackRelationshipsConfig;
import org.neo4j.gds.paths.dijkstra.config.AllShortestPathsDijkstraMutateConfig;

@Generated(from="AllShortestPathsDijkstraMutateConfig", generator="Immutables")
public final class ImmutableAllShortestPathsDijkstraMutateConfig
implements AllShortestPathsDijkstraMutateConfig {
    private final String usernameOverride;
    private final boolean sudo;
    private final boolean logProgress;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    private final JobId jobId;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    private final long sourceNode;
    private final String relationshipWeightProperty;
    private final transient boolean hasRelationshipWeightProperty;
    private final boolean trackRelationships;
    private final String mutateRelationshipType;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableAllShortestPathsDijkstraMutateConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, long sourceNode, Optional<String> relationshipWeightProperty, boolean trackRelationships, String mutateRelationshipType) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableAllShortestPathsDijkstraMutateConfig.createUnmodifiableList(false, ImmutableAllShortestPathsDijkstraMutateConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableAllShortestPathsDijkstraMutateConfig.createUnmodifiableList(false, ImmutableAllShortestPathsDijkstraMutateConfig.createSafeList(nodeLabels, true, false)));
        this.sourceNode = sourceNode;
        this.relationshipWeightProperty = relationshipWeightProperty.orElse(null);
        this.initShim.trackRelationships(trackRelationships);
        this.mutateRelationshipType = Objects.requireNonNull(mutateRelationshipType, "mutateRelationshipType");
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.trackRelationships = this.initShim.trackRelationships();
        this.initShim = null;
    }

    private ImmutableAllShortestPathsDijkstraMutateConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, long sourceNode, String relationshipWeightProperty, boolean trackRelationships, String mutateRelationshipType) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableAllShortestPathsDijkstraMutateConfig.createUnmodifiableList(false, ImmutableAllShortestPathsDijkstraMutateConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableAllShortestPathsDijkstraMutateConfig.createUnmodifiableList(false, ImmutableAllShortestPathsDijkstraMutateConfig.createSafeList(nodeLabels, true, false)));
        this.sourceNode = sourceNode;
        this.relationshipWeightProperty = relationshipWeightProperty;
        this.initShim.trackRelationships(trackRelationships);
        this.mutateRelationshipType = Objects.requireNonNull(mutateRelationshipType, "mutateRelationshipType");
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.trackRelationships = this.initShim.trackRelationships();
        this.initShim = null;
    }

    private ImmutableAllShortestPathsDijkstraMutateConfig(Builder builder) {
        this.usernameOverride = builder.usernameOverride;
        this.sourceNode = builder.sourceNode;
        this.relationshipWeightProperty = builder.relationshipWeightProperty;
        this.mutateRelationshipType = builder.mutateRelationshipType;
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.logProgressIsSet()) {
            this.initShim.logProgress(builder.logProgress);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.jobId != null) {
            this.initShim.jobId(builder.jobId);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableAllShortestPathsDijkstraMutateConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableAllShortestPathsDijkstraMutateConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.trackRelationshipsIsSet()) {
            this.initShim.trackRelationships(builder.trackRelationships);
        }
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.trackRelationships = this.initShim.trackRelationships();
        this.initShim = null;
    }

    private ImmutableAllShortestPathsDijkstraMutateConfig(String usernameOverride, boolean sudo, boolean logProgress, Collection<String> configKeys, int concurrency, int minBatchSize, JobId jobId, List<String> relationshipTypes, List<String> nodeLabels, long sourceNode, String relationshipWeightProperty, boolean trackRelationships, String mutateRelationshipType) {
        this.usernameOverride = usernameOverride;
        this.initShim.sudo(sudo);
        this.initShim.logProgress(logProgress);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.jobId(jobId);
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.sourceNode = sourceNode;
        this.relationshipWeightProperty = relationshipWeightProperty;
        this.initShim.trackRelationships(trackRelationships);
        this.mutateRelationshipType = mutateRelationshipType;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.trackRelationships = this.initShim.trackRelationships();
        this.initShim = null;
    }

    private boolean sudoInitialize() {
        return AllShortestPathsDijkstraMutateConfig.super.sudo();
    }

    private boolean logProgressInitialize() {
        return AllShortestPathsDijkstraMutateConfig.super.logProgress();
    }

    private Collection<String> configKeysInitialize() {
        return AllShortestPathsDijkstraMutateConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return AllShortestPathsDijkstraMutateConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return AllShortestPathsDijkstraMutateConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return AllShortestPathsDijkstraMutateConfig.super.minBatchSize();
    }

    private JobId jobIdInitialize() {
        return AllShortestPathsDijkstraMutateConfig.super.jobId();
    }

    private List<String> relationshipTypesInitialize() {
        return AllShortestPathsDijkstraMutateConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return AllShortestPathsDijkstraMutateConfig.super.nodeLabels();
    }

    private boolean hasRelationshipWeightPropertyInitialize() {
        return AllShortestPathsDijkstraMutateConfig.super.hasRelationshipWeightProperty();
    }

    private boolean trackRelationshipsInitialize() {
        return AllShortestPathsDijkstraMutateConfig.super.trackRelationships();
    }

    public Optional<String> usernameOverride() {
        return Optional.ofNullable(this.usernameOverride);
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public boolean logProgress() {
        InitShim shim = this.initShim;
        return shim != null ? shim.logProgress() : this.logProgress;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    public JobId jobId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.jobId() : this.jobId;
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    public long sourceNode() {
        return this.sourceNode;
    }

    public Optional<String> relationshipWeightProperty() {
        return Optional.ofNullable(this.relationshipWeightProperty);
    }

    public boolean hasRelationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasRelationshipWeightProperty() : this.hasRelationshipWeightProperty;
    }

    @Override
    public boolean trackRelationships() {
        InitShim shim = this.initShim;
        return shim != null ? shim.trackRelationships() : this.trackRelationships;
    }

    public String mutateRelationshipType() {
        return this.mutateRelationshipType;
    }

    public final ImmutableAllShortestPathsDijkstraMutateConfig withUsernameOverride(String value) {
        String newValue = value;
        if (Objects.equals(this.usernameOverride, newValue)) {
            return this;
        }
        return ImmutableAllShortestPathsDijkstraMutateConfig.validate(new ImmutableAllShortestPathsDijkstraMutateConfig(newValue, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.relationshipWeightProperty, this.trackRelationships, this.mutateRelationshipType));
    }

    public final ImmutableAllShortestPathsDijkstraMutateConfig withUsernameOverride(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableAllShortestPathsDijkstraMutateConfig.validate(new ImmutableAllShortestPathsDijkstraMutateConfig(value, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.relationshipWeightProperty, this.trackRelationships, this.mutateRelationshipType));
    }

    public final ImmutableAllShortestPathsDijkstraMutateConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableAllShortestPathsDijkstraMutateConfig.validate(new ImmutableAllShortestPathsDijkstraMutateConfig(this.usernameOverride, value, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.relationshipWeightProperty, this.trackRelationships, this.mutateRelationshipType));
    }

    public final ImmutableAllShortestPathsDijkstraMutateConfig withLogProgress(boolean value) {
        if (this.logProgress == value) {
            return this;
        }
        return ImmutableAllShortestPathsDijkstraMutateConfig.validate(new ImmutableAllShortestPathsDijkstraMutateConfig(this.usernameOverride, this.sudo, value, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.relationshipWeightProperty, this.trackRelationships, this.mutateRelationshipType));
    }

    public final ImmutableAllShortestPathsDijkstraMutateConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableAllShortestPathsDijkstraMutateConfig.validate(new ImmutableAllShortestPathsDijkstraMutateConfig(this.usernameOverride, this.sudo, this.logProgress, newValue, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.relationshipWeightProperty, this.trackRelationships, this.mutateRelationshipType));
    }

    public final ImmutableAllShortestPathsDijkstraMutateConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableAllShortestPathsDijkstraMutateConfig.validate(new ImmutableAllShortestPathsDijkstraMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, value, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.relationshipWeightProperty, this.trackRelationships, this.mutateRelationshipType));
    }

    public final ImmutableAllShortestPathsDijkstraMutateConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutableAllShortestPathsDijkstraMutateConfig.validate(new ImmutableAllShortestPathsDijkstraMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, value, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.relationshipWeightProperty, this.trackRelationships, this.mutateRelationshipType));
    }

    public final ImmutableAllShortestPathsDijkstraMutateConfig withJobId(JobId value) {
        if (this.jobId == value) {
            return this;
        }
        JobId newValue = Objects.requireNonNull(value, "jobId");
        return ImmutableAllShortestPathsDijkstraMutateConfig.validate(new ImmutableAllShortestPathsDijkstraMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.relationshipWeightProperty, this.trackRelationships, this.mutateRelationshipType));
    }

    public final ImmutableAllShortestPathsDijkstraMutateConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableAllShortestPathsDijkstraMutateConfig.createUnmodifiableList(false, ImmutableAllShortestPathsDijkstraMutateConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableAllShortestPathsDijkstraMutateConfig.validate(new ImmutableAllShortestPathsDijkstraMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, newValue, this.nodeLabels, this.sourceNode, this.relationshipWeightProperty, this.trackRelationships, this.mutateRelationshipType));
    }

    public final ImmutableAllShortestPathsDijkstraMutateConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableAllShortestPathsDijkstraMutateConfig.createUnmodifiableList(false, ImmutableAllShortestPathsDijkstraMutateConfig.createSafeList(elements, true, false));
        return ImmutableAllShortestPathsDijkstraMutateConfig.validate(new ImmutableAllShortestPathsDijkstraMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, newValue, this.nodeLabels, this.sourceNode, this.relationshipWeightProperty, this.trackRelationships, this.mutateRelationshipType));
    }

    public final ImmutableAllShortestPathsDijkstraMutateConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableAllShortestPathsDijkstraMutateConfig.createUnmodifiableList(false, ImmutableAllShortestPathsDijkstraMutateConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableAllShortestPathsDijkstraMutateConfig.validate(new ImmutableAllShortestPathsDijkstraMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, newValue, this.sourceNode, this.relationshipWeightProperty, this.trackRelationships, this.mutateRelationshipType));
    }

    public final ImmutableAllShortestPathsDijkstraMutateConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableAllShortestPathsDijkstraMutateConfig.createUnmodifiableList(false, ImmutableAllShortestPathsDijkstraMutateConfig.createSafeList(elements, true, false));
        return ImmutableAllShortestPathsDijkstraMutateConfig.validate(new ImmutableAllShortestPathsDijkstraMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, newValue, this.sourceNode, this.relationshipWeightProperty, this.trackRelationships, this.mutateRelationshipType));
    }

    public final ImmutableAllShortestPathsDijkstraMutateConfig withSourceNode(long value) {
        if (this.sourceNode == value) {
            return this;
        }
        return ImmutableAllShortestPathsDijkstraMutateConfig.validate(new ImmutableAllShortestPathsDijkstraMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, value, this.relationshipWeightProperty, this.trackRelationships, this.mutateRelationshipType));
    }

    public final ImmutableAllShortestPathsDijkstraMutateConfig withRelationshipWeightProperty(String value) {
        String newValue = value;
        if (Objects.equals(this.relationshipWeightProperty, newValue)) {
            return this;
        }
        return ImmutableAllShortestPathsDijkstraMutateConfig.validate(new ImmutableAllShortestPathsDijkstraMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, newValue, this.trackRelationships, this.mutateRelationshipType));
    }

    public final ImmutableAllShortestPathsDijkstraMutateConfig withRelationshipWeightProperty(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.relationshipWeightProperty, value)) {
            return this;
        }
        return ImmutableAllShortestPathsDijkstraMutateConfig.validate(new ImmutableAllShortestPathsDijkstraMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, value, this.trackRelationships, this.mutateRelationshipType));
    }

    public final ImmutableAllShortestPathsDijkstraMutateConfig withTrackRelationships(boolean value) {
        if (this.trackRelationships == value) {
            return this;
        }
        return ImmutableAllShortestPathsDijkstraMutateConfig.validate(new ImmutableAllShortestPathsDijkstraMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.relationshipWeightProperty, value, this.mutateRelationshipType));
    }

    public final ImmutableAllShortestPathsDijkstraMutateConfig withMutateRelationshipType(String value) {
        String newValue = Objects.requireNonNull(value, "mutateRelationshipType");
        if (this.mutateRelationshipType.equals(newValue)) {
            return this;
        }
        return ImmutableAllShortestPathsDijkstraMutateConfig.validate(new ImmutableAllShortestPathsDijkstraMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.relationshipWeightProperty, this.trackRelationships, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAllShortestPathsDijkstraMutateConfig && this.equalTo((ImmutableAllShortestPathsDijkstraMutateConfig)another);
    }

    private boolean equalTo(ImmutableAllShortestPathsDijkstraMutateConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.logProgress == another.logProgress && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && this.jobId.equals((Object)another.jobId) && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && this.sourceNode == another.sourceNode && Objects.equals(this.relationshipWeightProperty, another.relationshipWeightProperty) && this.hasRelationshipWeightProperty == another.hasRelationshipWeightProperty && this.trackRelationships == another.trackRelationships && this.mutateRelationshipType.equals(another.mutateRelationshipType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + Boolean.hashCode(this.logProgress);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + this.jobId.hashCode();
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + Long.hashCode(this.sourceNode);
        h += (h << 5) + Objects.hashCode(this.relationshipWeightProperty);
        h += (h << 5) + Boolean.hashCode(this.hasRelationshipWeightProperty);
        h += (h << 5) + Boolean.hashCode(this.trackRelationships);
        h += (h << 5) + this.mutateRelationshipType.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("AllShortestPathsDijkstraMutateConfig{");
        if (this.usernameOverride != null) {
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        if (builder.length() > 37) {
            builder.append(", ");
        }
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("logProgress=").append(this.logProgress);
        builder.append(", ");
        builder.append("concurrency=").append(this.concurrency);
        builder.append(", ");
        builder.append("minBatchSize=").append(this.minBatchSize);
        builder.append(", ");
        builder.append("jobId=").append(this.jobId);
        builder.append(", ");
        builder.append("relationshipTypes=").append(this.relationshipTypes);
        builder.append(", ");
        builder.append("nodeLabels=").append(this.nodeLabels);
        builder.append(", ");
        builder.append("sourceNode=").append(this.sourceNode);
        if (this.relationshipWeightProperty != null) {
            builder.append(", ");
            builder.append("relationshipWeightProperty=").append(this.relationshipWeightProperty);
        }
        builder.append(", ");
        builder.append("hasRelationshipWeightProperty=").append(this.hasRelationshipWeightProperty);
        builder.append(", ");
        builder.append("trackRelationships=").append(this.trackRelationships);
        builder.append(", ");
        builder.append("mutateRelationshipType=").append(this.mutateRelationshipType);
        return builder.append("}").toString();
    }

    public static AllShortestPathsDijkstraMutateConfig of(int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, long sourceNode, Optional<String> relationshipWeightProperty, boolean trackRelationships, String mutateRelationshipType) {
        return ImmutableAllShortestPathsDijkstraMutateConfig.of(concurrency, minBatchSize, relationshipTypes, nodeLabels, sourceNode, relationshipWeightProperty, trackRelationships, mutateRelationshipType);
    }

    public static AllShortestPathsDijkstraMutateConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, long sourceNode, Optional<String> relationshipWeightProperty, boolean trackRelationships, String mutateRelationshipType) {
        return ImmutableAllShortestPathsDijkstraMutateConfig.validate(new ImmutableAllShortestPathsDijkstraMutateConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, sourceNode, relationshipWeightProperty, trackRelationships, mutateRelationshipType));
    }

    public static AllShortestPathsDijkstraMutateConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, long sourceNode, String relationshipWeightProperty, boolean trackRelationships, String mutateRelationshipType) {
        return ImmutableAllShortestPathsDijkstraMutateConfig.validate(new ImmutableAllShortestPathsDijkstraMutateConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, sourceNode, relationshipWeightProperty, trackRelationships, mutateRelationshipType));
    }

    private static ImmutableAllShortestPathsDijkstraMutateConfig validate(ImmutableAllShortestPathsDijkstraMutateConfig instance) {
        instance.validateRelationshipWeightProperty();
        instance.validateConcurrency();
        return instance;
    }

    public static AllShortestPathsDijkstraMutateConfig copyOf(AllShortestPathsDijkstraMutateConfig instance) {
        if (instance instanceof ImmutableAllShortestPathsDijkstraMutateConfig) {
            return (ImmutableAllShortestPathsDijkstraMutateConfig)instance;
        }
        return ImmutableAllShortestPathsDijkstraMutateConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="AllShortestPathsDijkstraMutateConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_SOURCE_NODE = 1L;
        private static final long INIT_BIT_MUTATE_RELATIONSHIP_TYPE = 2L;
        private static final long OPT_BIT_SUDO = 1L;
        private static final long OPT_BIT_LOG_PROGRESS = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 8L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 16L;
        private static final long OPT_BIT_NODE_LABELS = 32L;
        private static final long OPT_BIT_TRACK_RELATIONSHIPS = 64L;
        private long initBits = 3L;
        private long optBits;
        private String usernameOverride;
        private boolean sudo;
        private boolean logProgress;
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        private JobId jobId;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        private long sourceNode;
        private String relationshipWeightProperty;
        private boolean trackRelationships;
        private String mutateRelationshipType;

        private Builder() {
        }

        public final Builder from(RelationshipWeightConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SourceNodeConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(JobIdConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TrackRelationshipsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MutateRelationshipConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AllShortestPathsDijkstraMutateConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            Optional relationshipWeightPropertyOptional;
            if (object instanceof RelationshipWeightConfig && (relationshipWeightPropertyOptional = (instance = (RelationshipWeightConfig)object).relationshipWeightProperty()).isPresent()) {
                this.relationshipWeightProperty(relationshipWeightPropertyOptional);
            }
            if (object instanceof SourceNodeConfig) {
                instance = (SourceNodeConfig)object;
                this.sourceNode(instance.sourceNode());
            }
            if (object instanceof JobIdConfig) {
                instance = (JobIdConfig)object;
                this.jobId(instance.jobId());
            }
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                this.minBatchSize(instance.minBatchSize());
                this.concurrency(instance.concurrency());
            }
            if (object instanceof TrackRelationshipsConfig) {
                instance = (TrackRelationshipsConfig)object;
                this.trackRelationships(instance.trackRelationships());
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                this.logProgress(instance.logProgress());
                this.sudo(instance.sudo());
                Optional usernameOverrideOptional = instance.usernameOverride();
                if (usernameOverrideOptional.isPresent()) {
                    this.usernameOverride(usernameOverrideOptional);
                }
                this.configKeys(instance.configKeys());
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                this.addAllRelationshipTypes(instance.relationshipTypes());
                this.addAllNodeLabels(instance.nodeLabels());
            }
            if (object instanceof MutateRelationshipConfig) {
                instance = (MutateRelationshipConfig)object;
                this.mutateRelationshipType(instance.mutateRelationshipType());
            }
        }

        public final Builder usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            return this;
        }

        public final Builder usernameOverride(Optional<String> usernameOverride) {
            this.usernameOverride = usernameOverride.orElse(null);
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 1L;
            return this;
        }

        public final Builder logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder jobId(JobId jobId) {
            this.jobId = Objects.requireNonNull(jobId, "jobId");
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder sourceNode(long sourceNode) {
            this.sourceNode = sourceNode;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder relationshipWeightProperty(String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            return this;
        }

        public final Builder relationshipWeightProperty(Optional<String> relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty.orElse(null);
            return this;
        }

        public final Builder trackRelationships(boolean trackRelationships) {
            this.trackRelationships = trackRelationships;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder mutateRelationshipType(String mutateRelationshipType) {
            this.mutateRelationshipType = Objects.requireNonNull(mutateRelationshipType, "mutateRelationshipType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.logProgress = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            this.jobId = null;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.sourceNode = 0L;
            this.relationshipWeightProperty = null;
            this.trackRelationships = false;
            this.mutateRelationshipType = null;
            return this;
        }

        public AllShortestPathsDijkstraMutateConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableAllShortestPathsDijkstraMutateConfig.validate(new ImmutableAllShortestPathsDijkstraMutateConfig(this));
        }

        private boolean sudoIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean logProgressIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean trackRelationshipsIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sourceNode");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("mutateRelationshipType");
            }
            return "Cannot build AllShortestPathsDijkstraMutateConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="AllShortestPathsDijkstraMutateConfig", generator="Immutables")
    private final class InitShim {
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte logProgressBuildStage = 0;
        private boolean logProgress;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte jobIdBuildStage = 0;
        private JobId jobId;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte hasRelationshipWeightPropertyBuildStage = 0;
        private boolean hasRelationshipWeightProperty;
        private byte trackRelationshipsBuildStage = 0;
        private boolean trackRelationships;

        private InitShim() {
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableAllShortestPathsDijkstraMutateConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        boolean logProgress() {
            if (this.logProgressBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.logProgressBuildStage == 0) {
                this.logProgressBuildStage = (byte)-1;
                this.logProgress = ImmutableAllShortestPathsDijkstraMutateConfig.this.logProgressInitialize();
                this.logProgressBuildStage = 1;
            }
            return this.logProgress;
        }

        void logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.logProgressBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableAllShortestPathsDijkstraMutateConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableAllShortestPathsDijkstraMutateConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableAllShortestPathsDijkstraMutateConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutableAllShortestPathsDijkstraMutateConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        JobId jobId() {
            if (this.jobIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.jobIdBuildStage == 0) {
                this.jobIdBuildStage = (byte)-1;
                this.jobId = Objects.requireNonNull(ImmutableAllShortestPathsDijkstraMutateConfig.this.jobIdInitialize(), "jobId");
                this.jobIdBuildStage = 1;
            }
            return this.jobId;
        }

        void jobId(JobId jobId) {
            this.jobId = jobId;
            this.jobIdBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableAllShortestPathsDijkstraMutateConfig.createUnmodifiableList(false, ImmutableAllShortestPathsDijkstraMutateConfig.createSafeList(ImmutableAllShortestPathsDijkstraMutateConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableAllShortestPathsDijkstraMutateConfig.createUnmodifiableList(false, ImmutableAllShortestPathsDijkstraMutateConfig.createSafeList(ImmutableAllShortestPathsDijkstraMutateConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        boolean hasRelationshipWeightProperty() {
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasRelationshipWeightPropertyBuildStage == 0) {
                this.hasRelationshipWeightPropertyBuildStage = (byte)-1;
                this.hasRelationshipWeightProperty = ImmutableAllShortestPathsDijkstraMutateConfig.this.hasRelationshipWeightPropertyInitialize();
                this.hasRelationshipWeightPropertyBuildStage = 1;
            }
            return this.hasRelationshipWeightProperty;
        }

        boolean trackRelationships() {
            if (this.trackRelationshipsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.trackRelationshipsBuildStage == 0) {
                this.trackRelationshipsBuildStage = (byte)-1;
                this.trackRelationships = ImmutableAllShortestPathsDijkstraMutateConfig.this.trackRelationshipsInitialize();
                this.trackRelationshipsBuildStage = 1;
            }
            return this.trackRelationships;
        }

        void trackRelationships(boolean trackRelationships) {
            this.trackRelationships = trackRelationships;
            this.trackRelationshipsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.logProgressBuildStage == -1) {
                attributes.add("logProgress");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.jobIdBuildStage == -1) {
                attributes.add("jobId");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                attributes.add("hasRelationshipWeightProperty");
            }
            if (this.trackRelationshipsBuildStage == -1) {
                attributes.add("trackRelationships");
            }
            return "Cannot build AllShortestPathsDijkstraMutateConfig, attribute initializers form cycle " + attributes;
        }
    }
}

