/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.dijkstra.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.SourceNodeConfig;
import org.neo4j.gds.config.TargetNodeConfig;
import org.neo4j.gds.config.WriteRelationshipConfig;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.paths.dijkstra.config.ShortestPathDijkstraWriteConfig;

public final class ShortestPathDijkstraWriteConfigImpl
implements ShortestPathDijkstraWriteConfig {
    private List<String> relationshipTypes;
    private List<String> nodeLabels;
    private Optional<String> usernameOverride;
    private boolean sudo;
    private boolean logProgress;
    private int concurrency;
    private JobId jobId;
    private long sourceNode;
    private long targetNode;
    private Optional<String> relationshipWeightProperty;
    private String writeRelationshipType;
    private int writeConcurrency;
    private boolean writeNodeIds;
    private boolean writeCosts;

    public ShortestPathDijkstraWriteConfigImpl(@NotNull CypherMapAccess config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.relationshipTypes = (List)CypherMapAccess.failOnNull((String)"relationshipTypes", (Object)((List)config.getChecked("relationshipTypes", (Object)ShortestPathDijkstraWriteConfig.super.relationshipTypes(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeLabels = (List)CypherMapAccess.failOnNull((String)"nodeLabels", (Object)((List)config.getChecked("nodeLabels", (Object)ShortestPathDijkstraWriteConfig.super.nodeLabels(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = (Optional)CypherMapAccess.failOnNull((String)"username", config.getOptional("username", String.class).map(BaseConfig::trim));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", ShortestPathDijkstraWriteConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.logProgress = config.getBool("logProgress", ShortestPathDijkstraWriteConfig.super.logProgress());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.concurrency = config.getInt("concurrency", ShortestPathDijkstraWriteConfig.super.concurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.jobId = (JobId)CypherMapAccess.failOnNull((String)"jobId", (Object)JobId.parse((Object)config.getChecked("jobId", (Object)ShortestPathDijkstraWriteConfig.super.jobId(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sourceNode = SourceNodeConfig.parseSourceNodeId((Object)config.requireChecked("sourceNode", Object.class));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.targetNode = TargetNodeConfig.parseTargetNodeId((Object)config.requireChecked("targetNode", Object.class));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipWeightProperty = (Optional)CypherMapAccess.failOnNull((String)"relationshipWeightProperty", (Object)config.getOptional("relationshipWeightProperty", String.class));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.writeRelationshipType = (String)CypherMapAccess.failOnNull((String)"writeRelationshipType", (Object)WriteRelationshipConfig.validateRelationshipTypeName((String)config.requireString("writeRelationshipType")));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.writeConcurrency = config.getInt("writeConcurrency", ShortestPathDijkstraWriteConfig.super.writeConcurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.writeNodeIds = config.getBool("writeNodeIds", ShortestPathDijkstraWriteConfig.super.writeNodeIds());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.writeCosts = config.getBool("writeCosts", ShortestPathDijkstraWriteConfig.super.writeCosts());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validateRelationshipWeightProperty();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validateWriteConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        return this.nodeLabels;
    }

    public void graphStoreValidation(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        ArrayList<IllegalArgumentException> errors_ = new ArrayList<IllegalArgumentException>();
        try {
            this.validateNodeLabels(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateRelationshipTypes(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateSourceNode(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateTargetNode(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.relationshipWeightValidation(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateGraphIsSuitableForWrite(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        if (!errors_.isEmpty()) {
            if (errors_.size() == 1) {
                throw (IllegalArgumentException)errors_.get(0);
            }
            String combinedErrorMsg_ = errors_.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError_ = new IllegalArgumentException(combinedErrorMsg_);
            errors_.forEach(error_ -> combinedError_.addSuppressed((Throwable)error_));
            throw combinedError_;
        }
    }

    public Optional<String> usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public boolean logProgress() {
        return this.logProgress;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("relationshipTypes", "nodeLabels", "username", "sudo", "logProgress", "concurrency", "jobId", "sourceNode", "targetNode", "relationshipWeightProperty", "writeRelationshipType", "writeConcurrency", "writeNodeIds", "writeCosts");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("nodeLabels", this.nodeLabels());
        this.usernameOverride().ifPresent(username -> map.put("username", username));
        map.put("sudo", this.sudo());
        map.put("logProgress", this.logProgress());
        map.put("concurrency", this.concurrency());
        map.put("jobId", JobId.asString((JobId)this.jobId()));
        map.put("sourceNode", this.sourceNode());
        map.put("targetNode", this.targetNode());
        this.relationshipWeightProperty().ifPresent(relationshipWeightProperty -> map.put("relationshipWeightProperty", relationshipWeightProperty));
        map.put("writeRelationshipType", this.writeRelationshipType());
        map.put("writeConcurrency", this.writeConcurrency());
        map.put("writeNodeIds", this.writeNodeIds());
        map.put("writeCosts", this.writeCosts());
        return map;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public JobId jobId() {
        return this.jobId;
    }

    public long sourceNode() {
        return this.sourceNode;
    }

    public long targetNode() {
        return this.targetNode;
    }

    public Optional<String> relationshipWeightProperty() {
        return this.relationshipWeightProperty;
    }

    public String writeRelationshipType() {
        return this.writeRelationshipType;
    }

    public int writeConcurrency() {
        return this.writeConcurrency;
    }

    @Override
    public boolean writeNodeIds() {
        return this.writeNodeIds;
    }

    @Override
    public boolean writeCosts() {
        return this.writeCosts;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();

        public static Builder from(ShortestPathDijkstraWriteConfig baseConfig) {
            Builder builder = new Builder();
            builder.relationshipTypes(baseConfig.relationshipTypes());
            builder.nodeLabels(baseConfig.nodeLabels());
            builder.usernameOverride(baseConfig.usernameOverride());
            builder.sudo(baseConfig.sudo());
            builder.logProgress(baseConfig.logProgress());
            builder.concurrency(baseConfig.concurrency());
            builder.jobId(baseConfig.jobId());
            builder.sourceNode(baseConfig.sourceNode());
            builder.targetNode(baseConfig.targetNode());
            builder.relationshipWeightProperty(baseConfig.relationshipWeightProperty());
            builder.writeRelationshipType(baseConfig.writeRelationshipType());
            builder.writeConcurrency(baseConfig.writeConcurrency());
            builder.writeNodeIds(baseConfig.writeNodeIds());
            builder.writeCosts(baseConfig.writeCosts());
            return builder;
        }

        public Builder relationshipTypes(List<String> relationshipTypes) {
            this.config.put("relationshipTypes", relationshipTypes);
            return this;
        }

        public Builder nodeLabels(List<String> nodeLabels) {
            this.config.put("nodeLabels", nodeLabels);
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder usernameOverride(Optional<String> usernameOverride) {
            usernameOverride.ifPresent(actualusernameOverride -> this.config.put("username", actualusernameOverride));
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public Builder logProgress(boolean logProgress) {
            this.config.put("logProgress", logProgress);
            return this;
        }

        public Builder concurrency(int concurrency) {
            this.config.put("concurrency", concurrency);
            return this;
        }

        public Builder jobId(Object jobId) {
            this.config.put("jobId", jobId);
            return this;
        }

        public Builder sourceNode(Object sourceNode) {
            this.config.put("sourceNode", sourceNode);
            return this;
        }

        public Builder targetNode(Object targetNode) {
            this.config.put("targetNode", targetNode);
            return this;
        }

        public Builder relationshipWeightProperty(String relationshipWeightProperty) {
            this.config.put("relationshipWeightProperty", relationshipWeightProperty);
            return this;
        }

        public Builder relationshipWeightProperty(Optional<String> relationshipWeightProperty) {
            relationshipWeightProperty.ifPresent(actualrelationshipWeightProperty -> this.config.put("relationshipWeightProperty", actualrelationshipWeightProperty));
            return this;
        }

        public Builder writeRelationshipType(String writeRelationshipType) {
            this.config.put("writeRelationshipType", writeRelationshipType);
            return this;
        }

        public Builder writeConcurrency(int writeConcurrency) {
            this.config.put("writeConcurrency", writeConcurrency);
            return this;
        }

        public Builder writeNodeIds(boolean writeNodeIds) {
            this.config.put("writeNodeIds", writeNodeIds);
            return this;
        }

        public Builder writeCosts(boolean writeCosts) {
            this.config.put("writeCosts", writeCosts);
            return this;
        }

        public ShortestPathDijkstraWriteConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new ShortestPathDijkstraWriteConfigImpl((CypherMapAccess)config);
        }
    }
}

