/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.yens;

import java.util.Arrays;
import org.jetbrains.annotations.TestOnly;
import org.neo4j.gds.paths.ImmutablePathResult;
import org.neo4j.gds.paths.PathResult;

final class MutablePathResult {
    private final long[] EMPTY_ARRAY = new long[0];
    private long index;
    private final long sourceNode;
    private final long targetNode;
    private long[] nodeIds;
    private long[] relationshipIds;
    private double[] costs;

    static MutablePathResult of(PathResult pathResult) {
        return new MutablePathResult(pathResult.index(), pathResult.sourceNode(), pathResult.targetNode(), pathResult.nodeIds(), pathResult.relationshipIds(), pathResult.costs());
    }

    private MutablePathResult(long index, long sourceNode, long targetNode, long[] nodeIds, long[] relationshipIds, double[] costs) {
        this.index = index;
        this.sourceNode = sourceNode;
        this.targetNode = targetNode;
        this.nodeIds = nodeIds;
        this.relationshipIds = relationshipIds;
        this.costs = costs;
    }

    PathResult toPathResult() {
        return ImmutablePathResult.of(this.index, this.sourceNode, this.targetNode, this.nodeIds, this.relationshipIds, this.costs);
    }

    MutablePathResult withIndex(int index) {
        this.index = index;
        return this;
    }

    int nodeCount() {
        return this.nodeIds.length;
    }

    long node(int index) {
        return this.nodeIds[index];
    }

    long relationship(int index) {
        return this.relationshipIds[index];
    }

    double totalCost() {
        return this.costs[this.costs.length - 1];
    }

    MutablePathResult subPath(int index) {
        return new MutablePathResult(index, this.sourceNode, this.targetNode, Arrays.copyOf(this.nodeIds, index), Arrays.copyOf(this.relationshipIds, index - 1), Arrays.copyOf(this.costs, index));
    }

    boolean matches(MutablePathResult path, int index) {
        for (int i = 0; i < index; ++i) {
            if (this.nodeIds[i] == path.nodeIds[i]) continue;
            return false;
        }
        return true;
    }

    boolean matchesExactly(MutablePathResult path, int index) {
        if (this.relationshipIds.length == 0 || path.relationshipIds.length == 0) {
            return this.matches(path, index);
        }
        for (int i = 0; i < index; ++i) {
            if (this.nodeIds[i] != path.nodeIds[i]) {
                return false;
            }
            if (i < 1 || this.relationshipIds[i - 1] == path.relationshipIds[i - 1]) continue;
            return false;
        }
        return true;
    }

    private void append(MutablePathResult path, long[] relationships) {
        assert (this.nodeIds[this.nodeIds.length - 1] == path.nodeIds[0]);
        int oldLength = this.nodeIds.length;
        long[] newNodeIds = new long[oldLength + path.nodeIds.length - 1];
        double[] newCosts = new double[oldLength + path.nodeIds.length - 1];
        System.arraycopy(this.nodeIds, 0, newNodeIds, 0, oldLength);
        System.arraycopy(path.nodeIds, 1, newNodeIds, oldLength, path.nodeIds.length - 1);
        System.arraycopy(this.costs, 0, newCosts, 0, oldLength);
        System.arraycopy(path.costs, 1, newCosts, oldLength, path.costs.length - 1);
        double baseCost = newCosts[oldLength - 1];
        int i = oldLength;
        while (i < newCosts.length) {
            int n = i++;
            newCosts[n] = newCosts[n] + baseCost;
        }
        this.nodeIds = newNodeIds;
        this.relationshipIds = relationships;
        this.costs = newCosts;
    }

    void append(MutablePathResult path) {
        int oldRelationshipIdsLength = this.relationshipIds.length;
        long[] newRelationshipIds = new long[oldRelationshipIdsLength + path.relationshipIds.length];
        System.arraycopy(this.relationshipIds, 0, newRelationshipIds, 0, oldRelationshipIdsLength);
        System.arraycopy(path.relationshipIds, 0, newRelationshipIds, oldRelationshipIdsLength, path.relationshipIds.length);
        this.append(path, newRelationshipIds);
    }

    void appendWithoutRelationshipIds(MutablePathResult path) {
        this.append(path, this.EMPTY_ARRAY);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutablePathResult other = (MutablePathResult)o;
        return Arrays.equals(this.nodeIds, other.nodeIds) && Arrays.equals(this.relationshipIds, other.relationshipIds);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Arrays.hashCode(this.nodeIds);
        h += (h << 5) + Arrays.hashCode(this.relationshipIds);
        return h;
    }

    public String toString() {
        return "MutablePathResult{index=" + this.index + ", sourceNode=" + this.sourceNode + ", targetNode=" + this.targetNode + ", nodeIds=" + Arrays.toString(this.nodeIds) + ", relationshipIds=" + Arrays.toString(this.relationshipIds) + ", costs=" + Arrays.toString(this.costs) + "}";
    }

    @TestOnly
    long index() {
        return this.index;
    }
}

