/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.yens;

import com.carrotsearch.hppc.LongHashSet;
import com.carrotsearch.hppc.LongObjectScatterMap;
import com.carrotsearch.hppc.LongScatterSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.function.BiConsumer;
import java.util.function.ToLongBiFunction;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.mem.MemoryUsage;
import org.neo4j.gds.paths.PathResult;
import org.neo4j.gds.paths.dijkstra.Dijkstra;
import org.neo4j.gds.paths.dijkstra.DijkstraResult;
import org.neo4j.gds.paths.yens.MutablePathResult;
import org.neo4j.gds.paths.yens.config.ImmutableShortestPathYensBaseConfig;
import org.neo4j.gds.paths.yens.config.ShortestPathYensBaseConfig;
import org.neo4j.gds.utils.StringFormatting;

public final class Yens
extends Algorithm<DijkstraResult> {
    private static final LongHashSet EMPTY_SET = new LongHashSet(0);
    private final Graph graph;
    private final ShortestPathYensBaseConfig config;
    private final Dijkstra dijkstra;
    private final LongScatterSet nodeAvoidList;
    private final LongObjectScatterMap<LongHashSet> relationshipAvoidList;
    private final ToLongBiFunction<MutablePathResult, Integer> relationshipAvoidMapper;
    private final BiConsumer<MutablePathResult, PathResult> pathAppender;
    private static final long AVERAGE_BLACKLIST_SIZE = 10L;

    public static Yens sourceTarget(Graph graph, ShortestPathYensBaseConfig config, ProgressTracker progressTracker) {
        boolean shouldTrackRelationships = graph.isMultiGraph();
        ShortestPathYensBaseConfig newConfig = ImmutableShortestPathYensBaseConfig.builder().from(config).trackRelationships(shouldTrackRelationships).build();
        Dijkstra dijkstra = Dijkstra.sourceTarget(graph, newConfig, Optional.empty(), progressTracker);
        return new Yens(graph, dijkstra, newConfig, progressTracker);
    }

    public static MemoryEstimation memoryEstimation() {
        return MemoryEstimations.builder((String)Yens.class.getSimpleName()).add("Dijkstra", Dijkstra.memoryEstimation(false)).fixed("nodeBlackList", MemoryUsage.sizeOfLongArray((long)10L)).fixed("relationshipBlackList", MemoryUsage.sizeOfLongArray((long)20L)).build();
    }

    private Yens(Graph graph, Dijkstra dijkstra, ShortestPathYensBaseConfig config, ProgressTracker progressTracker) {
        super(progressTracker);
        this.graph = graph;
        this.config = config;
        this.nodeAvoidList = new LongScatterSet();
        this.relationshipAvoidList = new LongObjectScatterMap();
        this.dijkstra = dijkstra;
        if (config.trackRelationships()) {
            this.relationshipAvoidMapper = (path, position) -> path.relationship((int)position);
            this.pathAppender = (rootPath, spurPath) -> rootPath.append(MutablePathResult.of(spurPath));
        } else {
            this.relationshipAvoidMapper = (path, position) -> path.node(position + 1);
            this.pathAppender = (rootPath, spurPath) -> rootPath.appendWithoutRelationshipIds(MutablePathResult.of(spurPath));
        }
        dijkstra.withRelationshipFilter((source, target, relationshipId) -> !this.nodeAvoidList.contains(target) && !this.shouldAvoidRelationship(source, target, relationshipId));
    }

    private boolean shouldAvoidRelationship(long source, long target, long relationshipId) {
        long forbidden = this.config.trackRelationships() ? relationshipId : target;
        return ((LongHashSet)this.relationshipAvoidList.getOrDefault(source, (Object)EMPTY_SET)).contains(forbidden);
    }

    public DijkstraResult compute() {
        this.progressTracker.beginSubTask();
        ArrayList<MutablePathResult> kShortestPaths = new ArrayList<MutablePathResult>();
        this.progressTracker.beginSubTask();
        this.progressTracker.beginSubTask();
        Optional<PathResult> shortestPath = this.computeDijkstra(this.config.sourceNode());
        if (shortestPath.isEmpty()) {
            this.progressTracker.endSubTask();
            this.progressTracker.endSubTask();
            return new DijkstraResult(Stream.empty(), () -> ((ProgressTracker)this.progressTracker).endSubTask());
        }
        this.progressTracker.endSubTask();
        kShortestPaths.add(MutablePathResult.of(shortestPath.get()));
        PriorityQueue<MutablePathResult> candidates = this.initCandidatesQueue();
        for (int i = 1; i < this.config.k(); ++i) {
            this.progressTracker.beginSubTask();
            MutablePathResult prevPath = (MutablePathResult)kShortestPaths.get(i - 1);
            for (int n = 0; n < prevPath.nodeCount() - 1; ++n) {
                long spurNode = prevPath.node(n);
                MutablePathResult rootPath = prevPath.subPath(n + 1);
                for (MutablePathResult path : kShortestPaths) {
                    if (!rootPath.matchesExactly(path, n + 1)) continue;
                    long relationshipId = this.relationshipAvoidMapper.applyAsLong(path, n);
                    LongHashSet neighbors = (LongHashSet)this.relationshipAvoidList.get(spurNode);
                    if (neighbors == null) {
                        neighbors = new LongHashSet();
                        this.relationshipAvoidList.put(spurNode, (Object)neighbors);
                    }
                    neighbors.add(relationshipId);
                }
                for (int j = 0; j < n; ++j) {
                    this.nodeAvoidList.add(rootPath.node(j));
                }
                this.dijkstra.resetTraversalState();
                this.dijkstra.withSourceNode(spurNode);
                Optional<PathResult> spurPath = this.computeDijkstra(this.graph.toOriginalNodeId(spurNode));
                this.nodeAvoidList.clear();
                this.relationshipAvoidList.clear();
                if (spurPath.isEmpty()) continue;
                this.pathAppender.accept(rootPath, spurPath.get());
                if (candidates.contains(rootPath)) continue;
                candidates.add(rootPath);
            }
            this.progressTracker.endSubTask();
            if (candidates.isEmpty()) break;
            kShortestPaths.add(candidates.poll().withIndex(i));
        }
        this.progressTracker.endSubTask();
        this.progressTracker.endSubTask();
        return new DijkstraResult(kShortestPaths.stream().map(MutablePathResult::toPathResult));
    }

    @NotNull
    private PriorityQueue<MutablePathResult> initCandidatesQueue() {
        return new PriorityQueue<MutablePathResult>(Comparator.comparingDouble(MutablePathResult::totalCost).thenComparingInt(MutablePathResult::nodeCount));
    }

    public void release() {
        this.dijkstra.release();
        this.nodeAvoidList.release();
        this.relationshipAvoidList.release();
    }

    private Optional<PathResult> computeDijkstra(long sourceNode) {
        this.progressTracker.logInfo(StringFormatting.formatWithLocale((String)"Dijkstra for spur node %d", (Object[])new Object[]{sourceNode}));
        return this.dijkstra.compute().findFirst();
    }
}

