/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.yens;

import java.util.List;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.paths.dijkstra.DijkstraFactory;
import org.neo4j.gds.paths.yens.Yens;
import org.neo4j.gds.paths.yens.config.ShortestPathYensBaseConfig;

public class YensFactory<CONFIG extends ShortestPathYensBaseConfig>
extends GraphAlgorithmFactory<Yens, CONFIG> {
    public MemoryEstimation memoryEstimation(ShortestPathYensBaseConfig configuration) {
        return Yens.memoryEstimation();
    }

    public Task progressTask(Graph graph, CONFIG config) {
        return Tasks.task((String)this.taskName(), (Task)Tasks.iterativeDynamic((String)"Searching path", () -> List.of(Tasks.iterativeOpen((String)"k", () -> List.of(DijkstraFactory.dijkstraProgressTask(graph)))), (int)config.k()), (Task[])new Task[0]);
    }

    public String taskName() {
        return "Yens";
    }

    public Yens build(Graph graph, CONFIG configuration, ProgressTracker progressTracker) {
        return Yens.sourceTarget(graph, configuration, progressTracker);
    }
}

