/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.yens.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.JobIdConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.config.SourceNodeConfig;
import org.neo4j.gds.config.TargetNodeConfig;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.paths.TrackRelationshipsConfig;
import org.neo4j.gds.paths.yens.config.ShortestPathYensBaseConfig;
import org.neo4j.gds.paths.yens.config.ShortestPathYensStreamConfig;

@Generated(from="ShortestPathYensStreamConfig", generator="Immutables")
public final class ImmutableShortestPathYensStreamConfig
implements ShortestPathYensStreamConfig {
    private final String usernameOverride;
    private final boolean sudo;
    private final boolean logProgress;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    private final JobId jobId;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    private final long sourceNode;
    private final long targetNode;
    private final String relationshipWeightProperty;
    private final transient boolean hasRelationshipWeightProperty;
    private final boolean trackRelationships;
    private final int k;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableShortestPathYensStreamConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, long sourceNode, long targetNode, Optional<String> relationshipWeightProperty, boolean trackRelationships, int k) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableShortestPathYensStreamConfig.createUnmodifiableList(false, ImmutableShortestPathYensStreamConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableShortestPathYensStreamConfig.createUnmodifiableList(false, ImmutableShortestPathYensStreamConfig.createSafeList(nodeLabels, true, false)));
        this.sourceNode = sourceNode;
        this.targetNode = targetNode;
        this.relationshipWeightProperty = relationshipWeightProperty.orElse(null);
        this.initShim.trackRelationships(trackRelationships);
        this.k = k;
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.trackRelationships = this.initShim.trackRelationships();
        this.initShim = null;
    }

    private ImmutableShortestPathYensStreamConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, long sourceNode, long targetNode, String relationshipWeightProperty, boolean trackRelationships, int k) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableShortestPathYensStreamConfig.createUnmodifiableList(false, ImmutableShortestPathYensStreamConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableShortestPathYensStreamConfig.createUnmodifiableList(false, ImmutableShortestPathYensStreamConfig.createSafeList(nodeLabels, true, false)));
        this.sourceNode = sourceNode;
        this.targetNode = targetNode;
        this.relationshipWeightProperty = relationshipWeightProperty;
        this.initShim.trackRelationships(trackRelationships);
        this.k = k;
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.trackRelationships = this.initShim.trackRelationships();
        this.initShim = null;
    }

    private ImmutableShortestPathYensStreamConfig(Builder builder) {
        this.usernameOverride = builder.usernameOverride;
        this.sourceNode = builder.sourceNode;
        this.targetNode = builder.targetNode;
        this.relationshipWeightProperty = builder.relationshipWeightProperty;
        this.k = builder.k;
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.logProgressIsSet()) {
            this.initShim.logProgress(builder.logProgress);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.jobId != null) {
            this.initShim.jobId(builder.jobId);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableShortestPathYensStreamConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableShortestPathYensStreamConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.trackRelationshipsIsSet()) {
            this.initShim.trackRelationships(builder.trackRelationships);
        }
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.trackRelationships = this.initShim.trackRelationships();
        this.initShim = null;
    }

    private ImmutableShortestPathYensStreamConfig(String usernameOverride, boolean sudo, boolean logProgress, Collection<String> configKeys, int concurrency, int minBatchSize, JobId jobId, List<String> relationshipTypes, List<String> nodeLabels, long sourceNode, long targetNode, String relationshipWeightProperty, boolean trackRelationships, int k) {
        this.usernameOverride = usernameOverride;
        this.initShim.sudo(sudo);
        this.initShim.logProgress(logProgress);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.jobId(jobId);
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.sourceNode = sourceNode;
        this.targetNode = targetNode;
        this.relationshipWeightProperty = relationshipWeightProperty;
        this.initShim.trackRelationships(trackRelationships);
        this.k = k;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.trackRelationships = this.initShim.trackRelationships();
        this.initShim = null;
    }

    private boolean sudoInitialize() {
        return ShortestPathYensStreamConfig.super.sudo();
    }

    private boolean logProgressInitialize() {
        return ShortestPathYensStreamConfig.super.logProgress();
    }

    private Collection<String> configKeysInitialize() {
        return ShortestPathYensStreamConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return ShortestPathYensStreamConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return ShortestPathYensStreamConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return ShortestPathYensStreamConfig.super.minBatchSize();
    }

    private JobId jobIdInitialize() {
        return ShortestPathYensStreamConfig.super.jobId();
    }

    private List<String> relationshipTypesInitialize() {
        return ShortestPathYensStreamConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return ShortestPathYensStreamConfig.super.nodeLabels();
    }

    private boolean hasRelationshipWeightPropertyInitialize() {
        return ShortestPathYensStreamConfig.super.hasRelationshipWeightProperty();
    }

    private boolean trackRelationshipsInitialize() {
        return ShortestPathYensStreamConfig.super.trackRelationships();
    }

    public Optional<String> usernameOverride() {
        return Optional.ofNullable(this.usernameOverride);
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public boolean logProgress() {
        InitShim shim = this.initShim;
        return shim != null ? shim.logProgress() : this.logProgress;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    public JobId jobId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.jobId() : this.jobId;
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    public long sourceNode() {
        return this.sourceNode;
    }

    public long targetNode() {
        return this.targetNode;
    }

    public Optional<String> relationshipWeightProperty() {
        return Optional.ofNullable(this.relationshipWeightProperty);
    }

    public boolean hasRelationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasRelationshipWeightProperty() : this.hasRelationshipWeightProperty;
    }

    @Override
    public boolean trackRelationships() {
        InitShim shim = this.initShim;
        return shim != null ? shim.trackRelationships() : this.trackRelationships;
    }

    @Override
    public int k() {
        return this.k;
    }

    public final ImmutableShortestPathYensStreamConfig withUsernameOverride(String value) {
        String newValue = value;
        if (Objects.equals(this.usernameOverride, newValue)) {
            return this;
        }
        return ImmutableShortestPathYensStreamConfig.validate(new ImmutableShortestPathYensStreamConfig(newValue, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNode, this.relationshipWeightProperty, this.trackRelationships, this.k));
    }

    public final ImmutableShortestPathYensStreamConfig withUsernameOverride(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableShortestPathYensStreamConfig.validate(new ImmutableShortestPathYensStreamConfig(value, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNode, this.relationshipWeightProperty, this.trackRelationships, this.k));
    }

    public final ImmutableShortestPathYensStreamConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableShortestPathYensStreamConfig.validate(new ImmutableShortestPathYensStreamConfig(this.usernameOverride, value, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNode, this.relationshipWeightProperty, this.trackRelationships, this.k));
    }

    public final ImmutableShortestPathYensStreamConfig withLogProgress(boolean value) {
        if (this.logProgress == value) {
            return this;
        }
        return ImmutableShortestPathYensStreamConfig.validate(new ImmutableShortestPathYensStreamConfig(this.usernameOverride, this.sudo, value, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNode, this.relationshipWeightProperty, this.trackRelationships, this.k));
    }

    public final ImmutableShortestPathYensStreamConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableShortestPathYensStreamConfig.validate(new ImmutableShortestPathYensStreamConfig(this.usernameOverride, this.sudo, this.logProgress, newValue, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNode, this.relationshipWeightProperty, this.trackRelationships, this.k));
    }

    public final ImmutableShortestPathYensStreamConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableShortestPathYensStreamConfig.validate(new ImmutableShortestPathYensStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, value, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNode, this.relationshipWeightProperty, this.trackRelationships, this.k));
    }

    public final ImmutableShortestPathYensStreamConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutableShortestPathYensStreamConfig.validate(new ImmutableShortestPathYensStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, value, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNode, this.relationshipWeightProperty, this.trackRelationships, this.k));
    }

    public final ImmutableShortestPathYensStreamConfig withJobId(JobId value) {
        if (this.jobId == value) {
            return this;
        }
        JobId newValue = Objects.requireNonNull(value, "jobId");
        return ImmutableShortestPathYensStreamConfig.validate(new ImmutableShortestPathYensStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNode, this.relationshipWeightProperty, this.trackRelationships, this.k));
    }

    public final ImmutableShortestPathYensStreamConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableShortestPathYensStreamConfig.createUnmodifiableList(false, ImmutableShortestPathYensStreamConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableShortestPathYensStreamConfig.validate(new ImmutableShortestPathYensStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, newValue, this.nodeLabels, this.sourceNode, this.targetNode, this.relationshipWeightProperty, this.trackRelationships, this.k));
    }

    public final ImmutableShortestPathYensStreamConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableShortestPathYensStreamConfig.createUnmodifiableList(false, ImmutableShortestPathYensStreamConfig.createSafeList(elements, true, false));
        return ImmutableShortestPathYensStreamConfig.validate(new ImmutableShortestPathYensStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, newValue, this.nodeLabels, this.sourceNode, this.targetNode, this.relationshipWeightProperty, this.trackRelationships, this.k));
    }

    public final ImmutableShortestPathYensStreamConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableShortestPathYensStreamConfig.createUnmodifiableList(false, ImmutableShortestPathYensStreamConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableShortestPathYensStreamConfig.validate(new ImmutableShortestPathYensStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, newValue, this.sourceNode, this.targetNode, this.relationshipWeightProperty, this.trackRelationships, this.k));
    }

    public final ImmutableShortestPathYensStreamConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableShortestPathYensStreamConfig.createUnmodifiableList(false, ImmutableShortestPathYensStreamConfig.createSafeList(elements, true, false));
        return ImmutableShortestPathYensStreamConfig.validate(new ImmutableShortestPathYensStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, newValue, this.sourceNode, this.targetNode, this.relationshipWeightProperty, this.trackRelationships, this.k));
    }

    public final ImmutableShortestPathYensStreamConfig withSourceNode(long value) {
        if (this.sourceNode == value) {
            return this;
        }
        return ImmutableShortestPathYensStreamConfig.validate(new ImmutableShortestPathYensStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, value, this.targetNode, this.relationshipWeightProperty, this.trackRelationships, this.k));
    }

    public final ImmutableShortestPathYensStreamConfig withTargetNode(long value) {
        if (this.targetNode == value) {
            return this;
        }
        return ImmutableShortestPathYensStreamConfig.validate(new ImmutableShortestPathYensStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, value, this.relationshipWeightProperty, this.trackRelationships, this.k));
    }

    public final ImmutableShortestPathYensStreamConfig withRelationshipWeightProperty(String value) {
        String newValue = value;
        if (Objects.equals(this.relationshipWeightProperty, newValue)) {
            return this;
        }
        return ImmutableShortestPathYensStreamConfig.validate(new ImmutableShortestPathYensStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNode, newValue, this.trackRelationships, this.k));
    }

    public final ImmutableShortestPathYensStreamConfig withRelationshipWeightProperty(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.relationshipWeightProperty, value)) {
            return this;
        }
        return ImmutableShortestPathYensStreamConfig.validate(new ImmutableShortestPathYensStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNode, value, this.trackRelationships, this.k));
    }

    public final ImmutableShortestPathYensStreamConfig withTrackRelationships(boolean value) {
        if (this.trackRelationships == value) {
            return this;
        }
        return ImmutableShortestPathYensStreamConfig.validate(new ImmutableShortestPathYensStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNode, this.relationshipWeightProperty, value, this.k));
    }

    public final ImmutableShortestPathYensStreamConfig withK(int value) {
        if (this.k == value) {
            return this;
        }
        return ImmutableShortestPathYensStreamConfig.validate(new ImmutableShortestPathYensStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNode, this.relationshipWeightProperty, this.trackRelationships, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableShortestPathYensStreamConfig && this.equalTo((ImmutableShortestPathYensStreamConfig)another);
    }

    private boolean equalTo(ImmutableShortestPathYensStreamConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.logProgress == another.logProgress && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && this.jobId.equals((Object)another.jobId) && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && this.sourceNode == another.sourceNode && this.targetNode == another.targetNode && Objects.equals(this.relationshipWeightProperty, another.relationshipWeightProperty) && this.hasRelationshipWeightProperty == another.hasRelationshipWeightProperty && this.trackRelationships == another.trackRelationships && this.k == another.k;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + Boolean.hashCode(this.logProgress);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + this.jobId.hashCode();
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + Long.hashCode(this.sourceNode);
        h += (h << 5) + Long.hashCode(this.targetNode);
        h += (h << 5) + Objects.hashCode(this.relationshipWeightProperty);
        h += (h << 5) + Boolean.hashCode(this.hasRelationshipWeightProperty);
        h += (h << 5) + Boolean.hashCode(this.trackRelationships);
        h += (h << 5) + this.k;
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ShortestPathYensStreamConfig{");
        if (this.usernameOverride != null) {
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        if (builder.length() > 29) {
            builder.append(", ");
        }
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("logProgress=").append(this.logProgress);
        builder.append(", ");
        builder.append("concurrency=").append(this.concurrency);
        builder.append(", ");
        builder.append("minBatchSize=").append(this.minBatchSize);
        builder.append(", ");
        builder.append("jobId=").append(this.jobId);
        builder.append(", ");
        builder.append("relationshipTypes=").append(this.relationshipTypes);
        builder.append(", ");
        builder.append("nodeLabels=").append(this.nodeLabels);
        builder.append(", ");
        builder.append("sourceNode=").append(this.sourceNode);
        builder.append(", ");
        builder.append("targetNode=").append(this.targetNode);
        if (this.relationshipWeightProperty != null) {
            builder.append(", ");
            builder.append("relationshipWeightProperty=").append(this.relationshipWeightProperty);
        }
        builder.append(", ");
        builder.append("hasRelationshipWeightProperty=").append(this.hasRelationshipWeightProperty);
        builder.append(", ");
        builder.append("trackRelationships=").append(this.trackRelationships);
        builder.append(", ");
        builder.append("k=").append(this.k);
        return builder.append("}").toString();
    }

    public static ShortestPathYensStreamConfig of(int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, long sourceNode, long targetNode, Optional<String> relationshipWeightProperty, boolean trackRelationships, int k) {
        return ImmutableShortestPathYensStreamConfig.of(concurrency, minBatchSize, relationshipTypes, nodeLabels, sourceNode, targetNode, relationshipWeightProperty, trackRelationships, k);
    }

    public static ShortestPathYensStreamConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, long sourceNode, long targetNode, Optional<String> relationshipWeightProperty, boolean trackRelationships, int k) {
        return ImmutableShortestPathYensStreamConfig.validate(new ImmutableShortestPathYensStreamConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, sourceNode, targetNode, relationshipWeightProperty, trackRelationships, k));
    }

    public static ShortestPathYensStreamConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, long sourceNode, long targetNode, String relationshipWeightProperty, boolean trackRelationships, int k) {
        return ImmutableShortestPathYensStreamConfig.validate(new ImmutableShortestPathYensStreamConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, sourceNode, targetNode, relationshipWeightProperty, trackRelationships, k));
    }

    private static ImmutableShortestPathYensStreamConfig validate(ImmutableShortestPathYensStreamConfig instance) {
        instance.validateRelationshipWeightProperty();
        instance.validateConcurrency();
        return instance;
    }

    public static ShortestPathYensStreamConfig copyOf(ShortestPathYensStreamConfig instance) {
        if (instance instanceof ImmutableShortestPathYensStreamConfig) {
            return (ImmutableShortestPathYensStreamConfig)instance;
        }
        return ImmutableShortestPathYensStreamConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ShortestPathYensStreamConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_SOURCE_NODE = 1L;
        private static final long INIT_BIT_TARGET_NODE = 2L;
        private static final long INIT_BIT_K = 4L;
        private static final long OPT_BIT_SUDO = 1L;
        private static final long OPT_BIT_LOG_PROGRESS = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 8L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 16L;
        private static final long OPT_BIT_NODE_LABELS = 32L;
        private static final long OPT_BIT_TRACK_RELATIONSHIPS = 64L;
        private long initBits = 7L;
        private long optBits;
        private String usernameOverride;
        private boolean sudo;
        private boolean logProgress;
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        private JobId jobId;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        private long sourceNode;
        private long targetNode;
        private String relationshipWeightProperty;
        private boolean trackRelationships;
        private int k;

        private Builder() {
        }

        public final Builder from(RelationshipWeightConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SourceNodeConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(JobIdConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TargetNodeConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TrackRelationshipsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ShortestPathYensBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ShortestPathYensStreamConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            Optional relationshipWeightPropertyOptional;
            if (object instanceof RelationshipWeightConfig && (relationshipWeightPropertyOptional = (instance = (RelationshipWeightConfig)object).relationshipWeightProperty()).isPresent()) {
                this.relationshipWeightProperty(relationshipWeightPropertyOptional);
            }
            if (object instanceof SourceNodeConfig) {
                instance = (SourceNodeConfig)object;
                this.sourceNode(instance.sourceNode());
            }
            if (object instanceof JobIdConfig) {
                instance = (JobIdConfig)object;
                this.jobId(instance.jobId());
            }
            if (object instanceof TargetNodeConfig) {
                instance = (TargetNodeConfig)object;
                this.targetNode(instance.targetNode());
            }
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                this.minBatchSize(instance.minBatchSize());
                this.concurrency(instance.concurrency());
            }
            if (object instanceof TrackRelationshipsConfig) {
                instance = (TrackRelationshipsConfig)object;
                this.trackRelationships(instance.trackRelationships());
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                this.logProgress(instance.logProgress());
                this.sudo(instance.sudo());
                Optional usernameOverrideOptional = instance.usernameOverride();
                if (usernameOverrideOptional.isPresent()) {
                    this.usernameOverride(usernameOverrideOptional);
                }
                this.configKeys(instance.configKeys());
            }
            if (object instanceof ShortestPathYensBaseConfig) {
                instance = (ShortestPathYensBaseConfig)object;
                this.k(instance.k());
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                this.addAllRelationshipTypes(instance.relationshipTypes());
                this.addAllNodeLabels(instance.nodeLabels());
            }
        }

        public final Builder usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            return this;
        }

        public final Builder usernameOverride(Optional<String> usernameOverride) {
            this.usernameOverride = usernameOverride.orElse(null);
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 1L;
            return this;
        }

        public final Builder logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder jobId(JobId jobId) {
            this.jobId = Objects.requireNonNull(jobId, "jobId");
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder sourceNode(long sourceNode) {
            this.sourceNode = sourceNode;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder targetNode(long targetNode) {
            this.targetNode = targetNode;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder relationshipWeightProperty(String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            return this;
        }

        public final Builder relationshipWeightProperty(Optional<String> relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty.orElse(null);
            return this;
        }

        public final Builder trackRelationships(boolean trackRelationships) {
            this.trackRelationships = trackRelationships;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder k(int k) {
            this.k = k;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder clear() {
            this.initBits = 7L;
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.logProgress = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            this.jobId = null;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.sourceNode = 0L;
            this.targetNode = 0L;
            this.relationshipWeightProperty = null;
            this.trackRelationships = false;
            this.k = 0;
            return this;
        }

        public ShortestPathYensStreamConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableShortestPathYensStreamConfig.validate(new ImmutableShortestPathYensStreamConfig(this));
        }

        private boolean sudoIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean logProgressIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean trackRelationshipsIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sourceNode");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("targetNode");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("k");
            }
            return "Cannot build ShortestPathYensStreamConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="ShortestPathYensStreamConfig", generator="Immutables")
    private final class InitShim {
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte logProgressBuildStage = 0;
        private boolean logProgress;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte jobIdBuildStage = 0;
        private JobId jobId;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte hasRelationshipWeightPropertyBuildStage = 0;
        private boolean hasRelationshipWeightProperty;
        private byte trackRelationshipsBuildStage = 0;
        private boolean trackRelationships;

        private InitShim() {
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableShortestPathYensStreamConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        boolean logProgress() {
            if (this.logProgressBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.logProgressBuildStage == 0) {
                this.logProgressBuildStage = (byte)-1;
                this.logProgress = ImmutableShortestPathYensStreamConfig.this.logProgressInitialize();
                this.logProgressBuildStage = 1;
            }
            return this.logProgress;
        }

        void logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.logProgressBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableShortestPathYensStreamConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableShortestPathYensStreamConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableShortestPathYensStreamConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutableShortestPathYensStreamConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        JobId jobId() {
            if (this.jobIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.jobIdBuildStage == 0) {
                this.jobIdBuildStage = (byte)-1;
                this.jobId = Objects.requireNonNull(ImmutableShortestPathYensStreamConfig.this.jobIdInitialize(), "jobId");
                this.jobIdBuildStage = 1;
            }
            return this.jobId;
        }

        void jobId(JobId jobId) {
            this.jobId = jobId;
            this.jobIdBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableShortestPathYensStreamConfig.createUnmodifiableList(false, ImmutableShortestPathYensStreamConfig.createSafeList(ImmutableShortestPathYensStreamConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableShortestPathYensStreamConfig.createUnmodifiableList(false, ImmutableShortestPathYensStreamConfig.createSafeList(ImmutableShortestPathYensStreamConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        boolean hasRelationshipWeightProperty() {
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasRelationshipWeightPropertyBuildStage == 0) {
                this.hasRelationshipWeightPropertyBuildStage = (byte)-1;
                this.hasRelationshipWeightProperty = ImmutableShortestPathYensStreamConfig.this.hasRelationshipWeightPropertyInitialize();
                this.hasRelationshipWeightPropertyBuildStage = 1;
            }
            return this.hasRelationshipWeightProperty;
        }

        boolean trackRelationships() {
            if (this.trackRelationshipsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.trackRelationshipsBuildStage == 0) {
                this.trackRelationshipsBuildStage = (byte)-1;
                this.trackRelationships = ImmutableShortestPathYensStreamConfig.this.trackRelationshipsInitialize();
                this.trackRelationshipsBuildStage = 1;
            }
            return this.trackRelationships;
        }

        void trackRelationships(boolean trackRelationships) {
            this.trackRelationships = trackRelationships;
            this.trackRelationshipsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.logProgressBuildStage == -1) {
                attributes.add("logProgress");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.jobIdBuildStage == -1) {
                attributes.add("jobId");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                attributes.add("hasRelationshipWeightProperty");
            }
            if (this.trackRelationshipsBuildStage == -1) {
                attributes.add("trackRelationships");
            }
            return "Cannot build ShortestPathYensStreamConfig, attribute initializers form cycle " + attributes;
        }
    }
}

