/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.filteredknn;

import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.similarity.filteredknn.FilteredKnnBaseConfig;
import org.neo4j.gds.similarity.filteredknn.FilteredKnnResult;
import org.neo4j.gds.similarity.filteredknn.ImmutableFilteredKnnResult;
import org.neo4j.gds.similarity.filteredknn.TargetNodeFiltering;
import org.neo4j.gds.similarity.filtering.NodeFilter;
import org.neo4j.gds.similarity.knn.Knn;
import org.neo4j.gds.similarity.knn.KnnContext;
import org.neo4j.gds.similarity.knn.SimilarityFunction;

public class FilteredKnn
extends Algorithm<FilteredKnnResult> {
    private final Knn delegate;
    private final TargetNodeFiltering targetNodeFiltering;
    private final NodeFilter sourceNodeFilter;

    public static FilteredKnn createWithoutSeeding(Graph graph, FilteredKnnBaseConfig config, KnnContext context) {
        return FilteredKnn.create(graph, config, context, Optional.empty());
    }

    public static FilteredKnn createWithDefaultSeeding(Graph graph, FilteredKnnBaseConfig config, KnnContext context) {
        SimilarityFunction similarityFunction = Knn.defaultSimilarityFunction(graph, config.nodeProperties());
        return FilteredKnn.create(graph, config, context, Optional.of(similarityFunction));
    }

    static FilteredKnn create(Graph graph, FilteredKnnBaseConfig config, KnnContext context, Optional<SimilarityFunction> optionalSimilarityFunction) {
        NodeFilter targetNodeFilter = config.targetNodeFilter().toNodeFilter((IdMap)graph);
        TargetNodeFiltering targetNodeFiltering = TargetNodeFiltering.create(graph.nodeCount(), config.boundedK(graph.nodeCount()), targetNodeFilter, graph, optionalSimilarityFunction, config.similarityCutoff());
        SimilarityFunction similarityFunction = optionalSimilarityFunction.orElse(Knn.defaultSimilarityFunction(graph, config.nodeProperties()));
        Knn knn = Knn.createWithDefaultsAndInstrumentation(graph, config, context, targetNodeFiltering, similarityFunction);
        NodeFilter sourceNodeFilter = config.sourceNodeFilter().toNodeFilter((IdMap)graph);
        return new FilteredKnn(context.progressTracker(), knn, targetNodeFiltering, sourceNodeFilter);
    }

    private FilteredKnn(ProgressTracker progressTracker, Knn delegate, TargetNodeFiltering targetNodeFiltering, NodeFilter sourceNodeFilter) {
        super(progressTracker);
        this.delegate = delegate;
        this.targetNodeFiltering = targetNodeFiltering;
        this.sourceNodeFilter = sourceNodeFilter;
    }

    public FilteredKnnResult compute() {
        Knn.Result result = this.delegate.compute();
        return ImmutableFilteredKnnResult.of(result.ranIterations(), result.didConverge(), result.nodePairsConsidered(), this.targetNodeFiltering, this.sourceNodeFilter);
    }

    public void release() {
        this.delegate.release();
    }

    long nodeCount() {
        return this.delegate.nodeCount();
    }

    ExecutorService executorService() {
        return this.delegate.executorService();
    }
}

