/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.filteredknn;

import java.util.Collection;
import org.immutables.value.Value;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.similarity.filtering.NodeFilterSpec;
import org.neo4j.gds.similarity.knn.KnnBaseConfig;

@ValueClass
@Configuration
public interface FilteredKnnBaseConfig
extends KnnBaseConfig {
    @Value.Default
    @Configuration.ConvertWith(method="org.neo4j.gds.similarity.filtering.NodeFilterSpecFactory#create")
    @Configuration.ToMapValue(value="org.neo4j.gds.similarity.filtering.NodeFilterSpecFactory#render")
    default public NodeFilterSpec sourceNodeFilter() {
        return NodeFilterSpec.noOp;
    }

    @Value.Default
    @Configuration.ConvertWith(method="org.neo4j.gds.similarity.filtering.NodeFilterSpecFactory#create")
    @Configuration.ToMapValue(value="org.neo4j.gds.similarity.filtering.NodeFilterSpecFactory#render")
    default public NodeFilterSpec targetNodeFilter() {
        return NodeFilterSpec.noOp;
    }

    @Value.Default
    default public boolean seedTargetNodes() {
        return false;
    }

    @Configuration.GraphStoreValidationCheck
    default public void validateSourceNodeFilter(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        this.sourceNodeFilter().validate(graphStore, selectedLabels, "sourceNodeFilter");
    }

    @Configuration.GraphStoreValidationCheck
    default public void validateTargetNodeFilter(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        this.targetNodeFilter().validate(graphStore, selectedLabels, "targetNodeFilter");
    }
}

