/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.filteredknn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.similarity.filteredknn.FilteredKnnBaseConfig;
import org.neo4j.gds.similarity.filtering.NodeFilterSpec;
import org.neo4j.gds.similarity.filtering.NodeFilterSpecFactory;
import org.neo4j.gds.similarity.knn.KnnNodePropertySpec;
import org.neo4j.gds.similarity.knn.KnnNodePropertySpecParser;
import org.neo4j.gds.similarity.knn.KnnSampler;

public final class FilteredKnnBaseConfigImpl
implements FilteredKnnBaseConfig {
    private NodeFilterSpec sourceNodeFilter;
    private NodeFilterSpec targetNodeFilter;
    private boolean seedTargetNodes;
    private List<KnnNodePropertySpec> nodeProperties;
    private int topK;
    private double sampleRate;
    private double perturbationRate;
    private double deltaThreshold;
    private double similarityCutoff;
    private int maxIterations;
    private int randomJoins;
    private KnnSampler.SamplerType initialSampler;
    private List<String> relationshipTypes;
    private List<String> nodeLabels;
    private Optional<String> usernameOverride;
    private boolean sudo;
    private boolean logProgress;
    private int concurrency;
    private JobId jobId;
    private Optional<Long> randomSeed;

    public FilteredKnnBaseConfigImpl(@NotNull CypherMapAccess config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.sourceNodeFilter = (NodeFilterSpec)CypherMapAccess.failOnNull((String)"sourceNodeFilter", (Object)NodeFilterSpecFactory.create(config.getChecked("sourceNodeFilter", (Object)FilteredKnnBaseConfig.super.sourceNodeFilter(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.targetNodeFilter = (NodeFilterSpec)CypherMapAccess.failOnNull((String)"targetNodeFilter", (Object)NodeFilterSpecFactory.create(config.getChecked("targetNodeFilter", (Object)FilteredKnnBaseConfig.super.targetNodeFilter(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.seedTargetNodes = config.getBool("seedTargetNodes", FilteredKnnBaseConfig.super.seedTargetNodes());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeProperties = (List)CypherMapAccess.failOnNull((String)"nodeProperties", KnnNodePropertySpecParser.parse(config.requireChecked("nodeProperties", Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.topK = config.getInt("topK", FilteredKnnBaseConfig.super.topK());
            CypherMapAccess.validateIntegerRange((String)"topK", (int)this.topK, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sampleRate = config.getDouble("sampleRate", FilteredKnnBaseConfig.super.sampleRate());
            CypherMapAccess.validateDoubleRange((String)"sampleRate", (double)this.sampleRate, (double)0.0, (double)1.0, (boolean)false, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.perturbationRate = config.getDouble("perturbationRate", FilteredKnnBaseConfig.super.perturbationRate());
            CypherMapAccess.validateDoubleRange((String)"perturbationRate", (double)this.perturbationRate, (double)0.0, (double)1.0, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.deltaThreshold = config.getDouble("deltaThreshold", FilteredKnnBaseConfig.super.deltaThreshold());
            CypherMapAccess.validateDoubleRange((String)"deltaThreshold", (double)this.deltaThreshold, (double)0.0, (double)1.0, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.similarityCutoff = config.getDouble("similarityCutoff", FilteredKnnBaseConfig.super.similarityCutoff());
            CypherMapAccess.validateDoubleRange((String)"similarityCutoff", (double)this.similarityCutoff, (double)0.0, (double)1.0, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.maxIterations = config.getInt("maxIterations", FilteredKnnBaseConfig.super.maxIterations());
            CypherMapAccess.validateIntegerRange((String)"maxIterations", (int)this.maxIterations, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.randomJoins = config.getInt("randomJoins", FilteredKnnBaseConfig.super.randomJoins());
            CypherMapAccess.validateIntegerRange((String)"randomJoins", (int)this.randomJoins, (int)0, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.initialSampler = (KnnSampler.SamplerType)((Object)CypherMapAccess.failOnNull((String)"initialSampler", (Object)((Object)KnnSampler.SamplerType.parse(config.getChecked("initialSampler", (Object)FilteredKnnBaseConfig.super.initialSampler(), Object.class)))));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipTypes = (List)CypherMapAccess.failOnNull((String)"relationshipTypes", (Object)((List)config.getChecked("relationshipTypes", (Object)FilteredKnnBaseConfig.super.relationshipTypes(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeLabels = (List)CypherMapAccess.failOnNull((String)"nodeLabels", (Object)((List)config.getChecked("nodeLabels", (Object)FilteredKnnBaseConfig.super.nodeLabels(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = (Optional)CypherMapAccess.failOnNull((String)"username", config.getOptional("username", String.class).map(BaseConfig::trim));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", FilteredKnnBaseConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.logProgress = config.getBool("logProgress", FilteredKnnBaseConfig.super.logProgress());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.concurrency = config.getInt("concurrency", FilteredKnnBaseConfig.super.concurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.jobId = (JobId)CypherMapAccess.failOnNull((String)"jobId", (Object)JobId.parse((Object)config.getChecked("jobId", (Object)FilteredKnnBaseConfig.super.jobId(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.randomSeed = (Optional)CypherMapAccess.failOnNull((String)"randomSeed", (Object)config.getOptional("randomSeed", Long.class));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validate();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public NodeFilterSpec sourceNodeFilter() {
        return this.sourceNodeFilter;
    }

    @Override
    public NodeFilterSpec targetNodeFilter() {
        return this.targetNodeFilter;
    }

    @Override
    public boolean seedTargetNodes() {
        return this.seedTargetNodes;
    }

    @Override
    public List<KnnNodePropertySpec> nodeProperties() {
        return this.nodeProperties;
    }

    @Override
    public int topK() {
        return this.topK;
    }

    @Override
    public double sampleRate() {
        return this.sampleRate;
    }

    @Override
    public double perturbationRate() {
        return this.perturbationRate;
    }

    @Override
    public double deltaThreshold() {
        return this.deltaThreshold;
    }

    @Override
    public double similarityCutoff() {
        return this.similarityCutoff;
    }

    @Override
    public int maxIterations() {
        return this.maxIterations;
    }

    @Override
    public int randomJoins() {
        return this.randomJoins;
    }

    @Override
    public KnnSampler.SamplerType initialSampler() {
        return this.initialSampler;
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        return this.nodeLabels;
    }

    public void graphStoreValidation(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        ArrayList<IllegalArgumentException> errors_ = new ArrayList<IllegalArgumentException>();
        try {
            this.validateSourceNodeFilter(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateTargetNodeFilter(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateNodeLabels(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateRelationshipTypes(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        if (!errors_.isEmpty()) {
            if (errors_.size() == 1) {
                throw (IllegalArgumentException)errors_.get(0);
            }
            String combinedErrorMsg_ = errors_.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError_ = new IllegalArgumentException(combinedErrorMsg_);
            errors_.forEach(error_ -> combinedError_.addSuppressed((Throwable)error_));
            throw combinedError_;
        }
    }

    public Optional<String> usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public boolean logProgress() {
        return this.logProgress;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("sourceNodeFilter", "targetNodeFilter", "seedTargetNodes", "nodeProperties", "topK", "sampleRate", "perturbationRate", "deltaThreshold", "similarityCutoff", "maxIterations", "randomJoins", "initialSampler", "relationshipTypes", "nodeLabels", "username", "sudo", "logProgress", "concurrency", "jobId", "randomSeed");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("sourceNodeFilter", NodeFilterSpecFactory.render(this.sourceNodeFilter()));
        map.put("targetNodeFilter", NodeFilterSpecFactory.render(this.targetNodeFilter()));
        map.put("seedTargetNodes", this.seedTargetNodes());
        map.put("nodeProperties", KnnNodePropertySpecParser.render(this.nodeProperties()));
        map.put("topK", this.topK());
        map.put("sampleRate", this.sampleRate());
        map.put("perturbationRate", this.perturbationRate());
        map.put("deltaThreshold", this.deltaThreshold());
        map.put("similarityCutoff", this.similarityCutoff());
        map.put("maxIterations", this.maxIterations());
        map.put("randomJoins", this.randomJoins());
        map.put("initialSampler", KnnSampler.SamplerType.toString(this.initialSampler()));
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("nodeLabels", this.nodeLabels());
        this.usernameOverride().ifPresent(username -> map.put("username", username));
        map.put("sudo", this.sudo());
        map.put("logProgress", this.logProgress());
        map.put("concurrency", this.concurrency());
        map.put("jobId", JobId.asString((JobId)this.jobId()));
        this.randomSeed().ifPresent(randomSeed -> map.put("randomSeed", randomSeed));
        return map;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public JobId jobId() {
        return this.jobId;
    }

    public Optional<Long> randomSeed() {
        return this.randomSeed;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();

        public static Builder from(FilteredKnnBaseConfig baseConfig) {
            Builder builder = new Builder();
            builder.sourceNodeFilter(baseConfig.sourceNodeFilter());
            builder.targetNodeFilter(baseConfig.targetNodeFilter());
            builder.seedTargetNodes(baseConfig.seedTargetNodes());
            builder.nodeProperties(baseConfig.nodeProperties());
            builder.topK(baseConfig.topK());
            builder.sampleRate(baseConfig.sampleRate());
            builder.perturbationRate(baseConfig.perturbationRate());
            builder.deltaThreshold(baseConfig.deltaThreshold());
            builder.similarityCutoff(baseConfig.similarityCutoff());
            builder.maxIterations(baseConfig.maxIterations());
            builder.randomJoins(baseConfig.randomJoins());
            builder.initialSampler((Object)baseConfig.initialSampler());
            builder.relationshipTypes(baseConfig.relationshipTypes());
            builder.nodeLabels(baseConfig.nodeLabels());
            builder.usernameOverride(baseConfig.usernameOverride());
            builder.sudo(baseConfig.sudo());
            builder.logProgress(baseConfig.logProgress());
            builder.concurrency(baseConfig.concurrency());
            builder.jobId(baseConfig.jobId());
            builder.randomSeed(baseConfig.randomSeed());
            return builder;
        }

        public Builder sourceNodeFilter(Object sourceNodeFilter) {
            this.config.put("sourceNodeFilter", sourceNodeFilter);
            return this;
        }

        public Builder targetNodeFilter(Object targetNodeFilter) {
            this.config.put("targetNodeFilter", targetNodeFilter);
            return this;
        }

        public Builder seedTargetNodes(boolean seedTargetNodes) {
            this.config.put("seedTargetNodes", seedTargetNodes);
            return this;
        }

        public Builder nodeProperties(Object nodeProperties) {
            this.config.put("nodeProperties", nodeProperties);
            return this;
        }

        public Builder topK(int topK) {
            this.config.put("topK", topK);
            return this;
        }

        public Builder sampleRate(double sampleRate) {
            this.config.put("sampleRate", sampleRate);
            return this;
        }

        public Builder perturbationRate(double perturbationRate) {
            this.config.put("perturbationRate", perturbationRate);
            return this;
        }

        public Builder deltaThreshold(double deltaThreshold) {
            this.config.put("deltaThreshold", deltaThreshold);
            return this;
        }

        public Builder similarityCutoff(double similarityCutoff) {
            this.config.put("similarityCutoff", similarityCutoff);
            return this;
        }

        public Builder maxIterations(int maxIterations) {
            this.config.put("maxIterations", maxIterations);
            return this;
        }

        public Builder randomJoins(int randomJoins) {
            this.config.put("randomJoins", randomJoins);
            return this;
        }

        public Builder initialSampler(Object initialSampler) {
            this.config.put("initialSampler", initialSampler);
            return this;
        }

        public Builder relationshipTypes(List<String> relationshipTypes) {
            this.config.put("relationshipTypes", relationshipTypes);
            return this;
        }

        public Builder nodeLabels(List<String> nodeLabels) {
            this.config.put("nodeLabels", nodeLabels);
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder usernameOverride(Optional<String> usernameOverride) {
            usernameOverride.ifPresent(actualusernameOverride -> this.config.put("username", actualusernameOverride));
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public Builder logProgress(boolean logProgress) {
            this.config.put("logProgress", logProgress);
            return this;
        }

        public Builder concurrency(int concurrency) {
            this.config.put("concurrency", concurrency);
            return this;
        }

        public Builder jobId(Object jobId) {
            this.config.put("jobId", jobId);
            return this;
        }

        public Builder randomSeed(Long randomSeed) {
            this.config.put("randomSeed", randomSeed);
            return this;
        }

        public Builder randomSeed(Optional<Long> randomSeed) {
            randomSeed.ifPresent(actualrandomSeed -> this.config.put("randomSeed", actualrandomSeed));
            return this;
        }

        public FilteredKnnBaseConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new FilteredKnnBaseConfigImpl((CypherMapAccess)config);
        }
    }
}

