/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.filteredknn;

import java.util.stream.Stream;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.similarity.SimilarityResult;
import org.neo4j.gds.similarity.filteredknn.TargetNodeFiltering;
import org.neo4j.gds.similarity.filtering.NodeFilter;

@ValueClass
public abstract class FilteredKnnResult {
    public abstract int ranIterations();

    public abstract boolean didConverge();

    public abstract long nodePairsConsidered();

    public Stream<SimilarityResult> similarityResultStream() {
        TargetNodeFiltering neighbourConsumers = this.neighbourConsumers();
        NodeFilter sourceNodeFilter = this.sourceNodeFilter();
        return neighbourConsumers.asSimilarityResultStream(sourceNodeFilter);
    }

    public long numberOfSimilarityPairs() {
        TargetNodeFiltering neighbourConsumers = this.neighbourConsumers();
        NodeFilter sourceNodeFilter = this.sourceNodeFilter();
        return neighbourConsumers.numberOfSimilarityPairs(sourceNodeFilter);
    }

    abstract TargetNodeFiltering neighbourConsumers();

    abstract NodeFilter sourceNodeFilter();
}

