/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.filteredknn;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.similarity.filteredknn.FilteredKnnResult;
import org.neo4j.gds.similarity.filteredknn.TargetNodeFiltering;
import org.neo4j.gds.similarity.filtering.NodeFilter;

@Generated(from="FilteredKnnResult", generator="Immutables")
public final class ImmutableFilteredKnnResult
extends FilteredKnnResult {
    private final int ranIterations;
    private final boolean didConverge;
    private final long nodePairsConsidered;
    private final TargetNodeFiltering neighbourConsumers;
    private final NodeFilter sourceNodeFilter;

    private ImmutableFilteredKnnResult(int ranIterations, boolean didConverge, long nodePairsConsidered, TargetNodeFiltering neighbourConsumers, NodeFilter sourceNodeFilter) {
        this.ranIterations = ranIterations;
        this.didConverge = didConverge;
        this.nodePairsConsidered = nodePairsConsidered;
        this.neighbourConsumers = Objects.requireNonNull(neighbourConsumers, "neighbourConsumers");
        this.sourceNodeFilter = Objects.requireNonNull(sourceNodeFilter, "sourceNodeFilter");
    }

    private ImmutableFilteredKnnResult(ImmutableFilteredKnnResult original, int ranIterations, boolean didConverge, long nodePairsConsidered, TargetNodeFiltering neighbourConsumers, NodeFilter sourceNodeFilter) {
        this.ranIterations = ranIterations;
        this.didConverge = didConverge;
        this.nodePairsConsidered = nodePairsConsidered;
        this.neighbourConsumers = neighbourConsumers;
        this.sourceNodeFilter = sourceNodeFilter;
    }

    @Override
    public int ranIterations() {
        return this.ranIterations;
    }

    @Override
    public boolean didConverge() {
        return this.didConverge;
    }

    @Override
    public long nodePairsConsidered() {
        return this.nodePairsConsidered;
    }

    @Override
    public TargetNodeFiltering neighbourConsumers() {
        return this.neighbourConsumers;
    }

    @Override
    public NodeFilter sourceNodeFilter() {
        return this.sourceNodeFilter;
    }

    public final ImmutableFilteredKnnResult withRanIterations(int value) {
        if (this.ranIterations == value) {
            return this;
        }
        return new ImmutableFilteredKnnResult(this, value, this.didConverge, this.nodePairsConsidered, this.neighbourConsumers, this.sourceNodeFilter);
    }

    public final ImmutableFilteredKnnResult withDidConverge(boolean value) {
        if (this.didConverge == value) {
            return this;
        }
        return new ImmutableFilteredKnnResult(this, this.ranIterations, value, this.nodePairsConsidered, this.neighbourConsumers, this.sourceNodeFilter);
    }

    public final ImmutableFilteredKnnResult withNodePairsConsidered(long value) {
        if (this.nodePairsConsidered == value) {
            return this;
        }
        return new ImmutableFilteredKnnResult(this, this.ranIterations, this.didConverge, value, this.neighbourConsumers, this.sourceNodeFilter);
    }

    public final ImmutableFilteredKnnResult withNeighbourConsumers(TargetNodeFiltering value) {
        if (this.neighbourConsumers == value) {
            return this;
        }
        TargetNodeFiltering newValue = Objects.requireNonNull(value, "neighbourConsumers");
        return new ImmutableFilteredKnnResult(this, this.ranIterations, this.didConverge, this.nodePairsConsidered, newValue, this.sourceNodeFilter);
    }

    public final ImmutableFilteredKnnResult withSourceNodeFilter(NodeFilter value) {
        if (this.sourceNodeFilter == value) {
            return this;
        }
        NodeFilter newValue = Objects.requireNonNull(value, "sourceNodeFilter");
        return new ImmutableFilteredKnnResult(this, this.ranIterations, this.didConverge, this.nodePairsConsidered, this.neighbourConsumers, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFilteredKnnResult && this.equalTo((ImmutableFilteredKnnResult)another);
    }

    private boolean equalTo(ImmutableFilteredKnnResult another) {
        return this.ranIterations == another.ranIterations && this.didConverge == another.didConverge && this.nodePairsConsidered == another.nodePairsConsidered && this.neighbourConsumers.equals(another.neighbourConsumers) && this.sourceNodeFilter.equals(another.sourceNodeFilter);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.ranIterations;
        h += (h << 5) + Boolean.hashCode(this.didConverge);
        h += (h << 5) + Long.hashCode(this.nodePairsConsidered);
        h += (h << 5) + this.neighbourConsumers.hashCode();
        h += (h << 5) + this.sourceNodeFilter.hashCode();
        return h;
    }

    public String toString() {
        return "FilteredKnnResult{ranIterations=" + this.ranIterations + ", didConverge=" + this.didConverge + ", nodePairsConsidered=" + this.nodePairsConsidered + ", neighbourConsumers=" + this.neighbourConsumers + ", sourceNodeFilter=" + this.sourceNodeFilter + "}";
    }

    public static FilteredKnnResult of(int ranIterations, boolean didConverge, long nodePairsConsidered, TargetNodeFiltering neighbourConsumers, NodeFilter sourceNodeFilter) {
        return new ImmutableFilteredKnnResult(ranIterations, didConverge, nodePairsConsidered, neighbourConsumers, sourceNodeFilter);
    }

    public static FilteredKnnResult copyOf(FilteredKnnResult instance) {
        if (instance instanceof ImmutableFilteredKnnResult) {
            return (ImmutableFilteredKnnResult)instance;
        }
        return ImmutableFilteredKnnResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FilteredKnnResult", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_RAN_ITERATIONS = 1L;
        private static final long INIT_BIT_DID_CONVERGE = 2L;
        private static final long INIT_BIT_NODE_PAIRS_CONSIDERED = 4L;
        private static final long INIT_BIT_NEIGHBOUR_CONSUMERS = 8L;
        private static final long INIT_BIT_SOURCE_NODE_FILTER = 16L;
        private long initBits = 31L;
        private int ranIterations;
        private boolean didConverge;
        private long nodePairsConsidered;
        private TargetNodeFiltering neighbourConsumers;
        private NodeFilter sourceNodeFilter;

        private Builder() {
        }

        public final Builder from(FilteredKnnResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.ranIterations(instance.ranIterations());
            this.didConverge(instance.didConverge());
            this.nodePairsConsidered(instance.nodePairsConsidered());
            this.neighbourConsumers(instance.neighbourConsumers());
            this.sourceNodeFilter(instance.sourceNodeFilter());
            return this;
        }

        public final Builder ranIterations(int ranIterations) {
            this.ranIterations = ranIterations;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder didConverge(boolean didConverge) {
            this.didConverge = didConverge;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder nodePairsConsidered(long nodePairsConsidered) {
            this.nodePairsConsidered = nodePairsConsidered;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder neighbourConsumers(TargetNodeFiltering neighbourConsumers) {
            this.neighbourConsumers = Objects.requireNonNull(neighbourConsumers, "neighbourConsumers");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder sourceNodeFilter(NodeFilter sourceNodeFilter) {
            this.sourceNodeFilter = Objects.requireNonNull(sourceNodeFilter, "sourceNodeFilter");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public Builder clear() {
            this.initBits = 31L;
            this.ranIterations = 0;
            this.didConverge = false;
            this.nodePairsConsidered = 0L;
            this.neighbourConsumers = null;
            this.sourceNodeFilter = null;
            return this;
        }

        public FilteredKnnResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFilteredKnnResult(null, this.ranIterations, this.didConverge, this.nodePairsConsidered, this.neighbourConsumers, this.sourceNodeFilter);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("ranIterations");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("didConverge");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("nodePairsConsidered");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("neighbourConsumers");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("sourceNodeFilter");
            }
            return "Cannot build FilteredKnnResult, some of required attributes are not set " + attributes;
        }
    }
}

