/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.filteredknn;

import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.LongPredicate;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.neo4j.gds.similarity.SimilarityResult;
import org.neo4j.gds.similarity.knn.NeighbourConsumer;

public final class TargetNodeFilter
implements NeighbourConsumer {
    private final TreeSet<Pair<Double, Long>> priorityQueue;
    private final LongPredicate predicate;
    private final int bound;
    private final boolean seeded;
    private final double similarityCutoff;

    static TargetNodeFilter create(LongPredicate targetNodePredicate, int bound, Optional<Set<Pair<Double, Long>>> seeds, double similarityCutoff) {
        TreeSet<Pair<Double, Long>> priorityQueue = new TreeSet<Pair<Double, Long>>(Comparator.reverseOrder());
        seeds.ifPresent(priorityQueue::addAll);
        return new TargetNodeFilter(priorityQueue, seeds.isPresent(), similarityCutoff, targetNodePredicate, bound);
    }

    TargetNodeFilter(TreeSet<Pair<Double, Long>> priorityQueue, boolean seeded, double similarityCutoff, LongPredicate predicate, int bound) {
        this.priorityQueue = priorityQueue;
        this.seeded = seeded;
        this.similarityCutoff = similarityCutoff;
        this.predicate = predicate;
        this.bound = bound;
    }

    @Override
    public void offer(long element, double priority) {
        if (!this.seeded && priority < this.similarityCutoff) {
            return;
        }
        if (!this.predicate.test(element)) {
            return;
        }
        this.priorityQueue.add((Pair<Double, Long>)Pair.of((Object)priority, (Object)element));
        if (this.priorityQueue.size() > this.bound) {
            this.priorityQueue.pollLast();
        }
    }

    Stream<SimilarityResult> asSimilarityStream(long nodeId) {
        return this.priorityQueue.stream().map(p -> new SimilarityResult(nodeId, (Long)p.getRight(), (Double)p.getLeft()));
    }

    long size() {
        return this.priorityQueue.size();
    }
}

