/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.filterednodesim;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.WritePropertyConfig;
import org.neo4j.gds.config.WriteRelationshipConfig;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.similarity.filterednodesim.FilteredNodeSimilarityWriteConfig;
import org.neo4j.gds.similarity.filtering.NodeFilterSpec;
import org.neo4j.gds.similarity.filtering.NodeFilterSpecFactory;
import org.neo4j.gds.similarity.nodesim.MetricSimilarityComputer;

public final class FilteredNodeSimilarityWriteConfigImpl
implements FilteredNodeSimilarityWriteConfig {
    private NodeFilterSpec sourceNodeFilter;
    private NodeFilterSpec targetNodeFilter;
    private double similarityCutoff;
    private MetricSimilarityComputer.MetricSimilarityComputerBuilder similarityMetric;
    private int degreeCutoff;
    private int topK;
    private int topN;
    private int bottomK;
    private int bottomN;
    private List<String> relationshipTypes;
    private List<String> nodeLabels;
    private Optional<String> usernameOverride;
    private boolean sudo;
    private boolean logProgress;
    private int concurrency;
    private JobId jobId;
    private Optional<String> relationshipWeightProperty;
    private String writeProperty;
    private int writeConcurrency;
    private String writeRelationshipType;

    public FilteredNodeSimilarityWriteConfigImpl(@NotNull CypherMapAccess config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.sourceNodeFilter = (NodeFilterSpec)CypherMapAccess.failOnNull((String)"sourceNodeFilter", (Object)NodeFilterSpecFactory.create(config.getChecked("sourceNodeFilter", (Object)FilteredNodeSimilarityWriteConfig.super.sourceNodeFilter(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.targetNodeFilter = (NodeFilterSpec)CypherMapAccess.failOnNull((String)"targetNodeFilter", (Object)NodeFilterSpecFactory.create(config.getChecked("targetNodeFilter", (Object)FilteredNodeSimilarityWriteConfig.super.targetNodeFilter(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.similarityCutoff = config.getDouble("similarityCutoff", FilteredNodeSimilarityWriteConfig.super.similarityCutoff());
            CypherMapAccess.validateDoubleRange((String)"similarityCutoff", (double)this.similarityCutoff, (double)0.0, (double)1.0, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.similarityMetric = (MetricSimilarityComputer.MetricSimilarityComputerBuilder)CypherMapAccess.failOnNull((String)"similarityMetric", (Object)MetricSimilarityComputer.parse(config.getChecked("similarityMetric", (Object)FilteredNodeSimilarityWriteConfig.super.similarityMetric(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.degreeCutoff = config.getInt("degreeCutoff", FilteredNodeSimilarityWriteConfig.super.degreeCutoff());
            CypherMapAccess.validateIntegerRange((String)"degreeCutoff", (int)this.degreeCutoff, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.topK = config.getInt("topK", FilteredNodeSimilarityWriteConfig.super.topK());
            CypherMapAccess.validateIntegerRange((String)"topK", (int)this.topK, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.topN = config.getInt("topN", FilteredNodeSimilarityWriteConfig.super.topN());
            CypherMapAccess.validateIntegerRange((String)"topN", (int)this.topN, (int)0, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.bottomK = config.getInt("bottomK", FilteredNodeSimilarityWriteConfig.super.bottomK());
            CypherMapAccess.validateIntegerRange((String)"bottomK", (int)this.bottomK, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.bottomN = config.getInt("bottomN", FilteredNodeSimilarityWriteConfig.super.bottomN());
            CypherMapAccess.validateIntegerRange((String)"bottomN", (int)this.bottomN, (int)0, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipTypes = (List)CypherMapAccess.failOnNull((String)"relationshipTypes", (Object)((List)config.getChecked("relationshipTypes", (Object)FilteredNodeSimilarityWriteConfig.super.relationshipTypes(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeLabels = (List)CypherMapAccess.failOnNull((String)"nodeLabels", (Object)((List)config.getChecked("nodeLabels", (Object)FilteredNodeSimilarityWriteConfig.super.nodeLabels(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = (Optional)CypherMapAccess.failOnNull((String)"username", config.getOptional("username", String.class).map(BaseConfig::trim));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", FilteredNodeSimilarityWriteConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.logProgress = config.getBool("logProgress", FilteredNodeSimilarityWriteConfig.super.logProgress());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.concurrency = config.getInt("concurrency", FilteredNodeSimilarityWriteConfig.super.concurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.jobId = (JobId)CypherMapAccess.failOnNull((String)"jobId", (Object)JobId.parse((Object)config.getChecked("jobId", (Object)FilteredNodeSimilarityWriteConfig.super.jobId(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipWeightProperty = (Optional)CypherMapAccess.failOnNull((String)"relationshipWeightProperty", (Object)config.getOptional("relationshipWeightProperty", String.class));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.writeProperty = (String)CypherMapAccess.failOnNull((String)"writeProperty", (Object)WritePropertyConfig.validatePropertyName((String)config.requireString("writeProperty")));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.writeConcurrency = config.getInt("writeConcurrency", FilteredNodeSimilarityWriteConfig.super.writeConcurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.writeRelationshipType = (String)CypherMapAccess.failOnNull((String)"writeRelationshipType", (Object)WriteRelationshipConfig.validateRelationshipTypeName((String)config.requireString("writeRelationshipType")));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validate();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validateConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validateRelationshipWeightProperty();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validateWriteConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public NodeFilterSpec sourceNodeFilter() {
        return this.sourceNodeFilter;
    }

    @Override
    public NodeFilterSpec targetNodeFilter() {
        return this.targetNodeFilter;
    }

    @Override
    public double similarityCutoff() {
        return this.similarityCutoff;
    }

    @Override
    public MetricSimilarityComputer.MetricSimilarityComputerBuilder similarityMetric() {
        return this.similarityMetric;
    }

    @Override
    public int degreeCutoff() {
        return this.degreeCutoff;
    }

    @Override
    public int topK() {
        return this.topK;
    }

    @Override
    public int topN() {
        return this.topN;
    }

    @Override
    public int bottomK() {
        return this.bottomK;
    }

    @Override
    public int bottomN() {
        return this.bottomN;
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        return this.nodeLabels;
    }

    public void graphStoreValidation(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        ArrayList<IllegalArgumentException> errors_ = new ArrayList<IllegalArgumentException>();
        try {
            this.validateNodeLabels(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateRelationshipTypes(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.relationshipWeightValidation(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateGraphIsSuitableForWrite(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        if (!errors_.isEmpty()) {
            if (errors_.size() == 1) {
                throw (IllegalArgumentException)errors_.get(0);
            }
            String combinedErrorMsg_ = errors_.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError_ = new IllegalArgumentException(combinedErrorMsg_);
            errors_.forEach(error_ -> combinedError_.addSuppressed((Throwable)error_));
            throw combinedError_;
        }
    }

    public Optional<String> usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public boolean logProgress() {
        return this.logProgress;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("sourceNodeFilter", "targetNodeFilter", "similarityCutoff", "similarityMetric", "degreeCutoff", "topK", "topN", "bottomK", "bottomN", "relationshipTypes", "nodeLabels", "username", "sudo", "logProgress", "concurrency", "jobId", "relationshipWeightProperty", "writeProperty", "writeConcurrency", "writeRelationshipType");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("sourceNodeFilter", NodeFilterSpecFactory.render(this.sourceNodeFilter()));
        map.put("targetNodeFilter", NodeFilterSpecFactory.render(this.targetNodeFilter()));
        map.put("similarityCutoff", this.similarityCutoff());
        map.put("similarityMetric", MetricSimilarityComputer.render(this.similarityMetric()));
        map.put("degreeCutoff", this.degreeCutoff());
        map.put("topK", this.topK());
        map.put("topN", this.topN());
        map.put("bottomK", this.bottomK());
        map.put("bottomN", this.bottomN());
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("nodeLabels", this.nodeLabels());
        this.usernameOverride().ifPresent(username -> map.put("username", username));
        map.put("sudo", this.sudo());
        map.put("logProgress", this.logProgress());
        map.put("concurrency", this.concurrency());
        map.put("jobId", JobId.asString((JobId)this.jobId()));
        this.relationshipWeightProperty().ifPresent(relationshipWeightProperty -> map.put("relationshipWeightProperty", relationshipWeightProperty));
        map.put("writeProperty", this.writeProperty());
        map.put("writeConcurrency", this.writeConcurrency());
        map.put("writeRelationshipType", this.writeRelationshipType());
        return map;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public JobId jobId() {
        return this.jobId;
    }

    public Optional<String> relationshipWeightProperty() {
        return this.relationshipWeightProperty;
    }

    public String writeProperty() {
        return this.writeProperty;
    }

    public int writeConcurrency() {
        return this.writeConcurrency;
    }

    public String writeRelationshipType() {
        return this.writeRelationshipType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();

        public static Builder from(FilteredNodeSimilarityWriteConfig baseConfig) {
            Builder builder = new Builder();
            builder.sourceNodeFilter(baseConfig.sourceNodeFilter());
            builder.targetNodeFilter(baseConfig.targetNodeFilter());
            builder.similarityCutoff(baseConfig.similarityCutoff());
            builder.similarityMetric(baseConfig.similarityMetric());
            builder.degreeCutoff(baseConfig.degreeCutoff());
            builder.topK(baseConfig.topK());
            builder.topN(baseConfig.topN());
            builder.bottomK(baseConfig.bottomK());
            builder.bottomN(baseConfig.bottomN());
            builder.relationshipTypes(baseConfig.relationshipTypes());
            builder.nodeLabels(baseConfig.nodeLabels());
            builder.usernameOverride(baseConfig.usernameOverride());
            builder.sudo(baseConfig.sudo());
            builder.logProgress(baseConfig.logProgress());
            builder.concurrency(baseConfig.concurrency());
            builder.jobId(baseConfig.jobId());
            builder.relationshipWeightProperty(baseConfig.relationshipWeightProperty());
            builder.writeProperty(baseConfig.writeProperty());
            builder.writeConcurrency(baseConfig.writeConcurrency());
            builder.writeRelationshipType(baseConfig.writeRelationshipType());
            return builder;
        }

        public Builder sourceNodeFilter(Object sourceNodeFilter) {
            this.config.put("sourceNodeFilter", sourceNodeFilter);
            return this;
        }

        public Builder targetNodeFilter(Object targetNodeFilter) {
            this.config.put("targetNodeFilter", targetNodeFilter);
            return this;
        }

        public Builder similarityCutoff(double similarityCutoff) {
            this.config.put("similarityCutoff", similarityCutoff);
            return this;
        }

        public Builder similarityMetric(Object similarityMetric) {
            this.config.put("similarityMetric", similarityMetric);
            return this;
        }

        public Builder degreeCutoff(int degreeCutoff) {
            this.config.put("degreeCutoff", degreeCutoff);
            return this;
        }

        public Builder topK(int topK) {
            this.config.put("topK", topK);
            return this;
        }

        public Builder topN(int topN) {
            this.config.put("topN", topN);
            return this;
        }

        public Builder bottomK(int bottomK) {
            this.config.put("bottomK", bottomK);
            return this;
        }

        public Builder bottomN(int bottomN) {
            this.config.put("bottomN", bottomN);
            return this;
        }

        public Builder relationshipTypes(List<String> relationshipTypes) {
            this.config.put("relationshipTypes", relationshipTypes);
            return this;
        }

        public Builder nodeLabels(List<String> nodeLabels) {
            this.config.put("nodeLabels", nodeLabels);
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder usernameOverride(Optional<String> usernameOverride) {
            usernameOverride.ifPresent(actualusernameOverride -> this.config.put("username", actualusernameOverride));
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public Builder logProgress(boolean logProgress) {
            this.config.put("logProgress", logProgress);
            return this;
        }

        public Builder concurrency(int concurrency) {
            this.config.put("concurrency", concurrency);
            return this;
        }

        public Builder jobId(Object jobId) {
            this.config.put("jobId", jobId);
            return this;
        }

        public Builder relationshipWeightProperty(String relationshipWeightProperty) {
            this.config.put("relationshipWeightProperty", relationshipWeightProperty);
            return this;
        }

        public Builder relationshipWeightProperty(Optional<String> relationshipWeightProperty) {
            relationshipWeightProperty.ifPresent(actualrelationshipWeightProperty -> this.config.put("relationshipWeightProperty", actualrelationshipWeightProperty));
            return this;
        }

        public Builder writeProperty(String writeProperty) {
            this.config.put("writeProperty", writeProperty);
            return this;
        }

        public Builder writeConcurrency(int writeConcurrency) {
            this.config.put("writeConcurrency", writeConcurrency);
            return this;
        }

        public Builder writeRelationshipType(String writeRelationshipType) {
            this.config.put("writeRelationshipType", writeRelationshipType);
            return this;
        }

        public FilteredNodeSimilarityWriteConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new FilteredNodeSimilarityWriteConfigImpl((CypherMapAccess)config);
        }
    }
}

