/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.filterednodesim;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.JobIdConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.similarity.filterednodesim.FilteredNodeSimilarityBaseConfig;
import org.neo4j.gds.similarity.filterednodesim.FilteredNodeSimilarityStreamConfig;
import org.neo4j.gds.similarity.filtering.NodeFilterSpec;
import org.neo4j.gds.similarity.nodesim.MetricSimilarityComputer;
import org.neo4j.gds.similarity.nodesim.NodeSimilarityBaseConfig;

@Generated(from="FilteredNodeSimilarityStreamConfig", generator="Immutables")
public final class ImmutableFilteredNodeSimilarityStreamConfig
implements FilteredNodeSimilarityStreamConfig {
    private final String usernameOverride;
    private final boolean sudo;
    private final boolean logProgress;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    private final JobId jobId;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    private final String relationshipWeightProperty;
    private final transient boolean hasRelationshipWeightProperty;
    private final double similarityCutoff;
    private final MetricSimilarityComputer.MetricSimilarityComputerBuilder similarityMetric;
    private final int degreeCutoff;
    private final int topK;
    private final int topN;
    private final int bottomK;
    private final int bottomN;
    private final transient int normalizedK;
    private final transient int normalizedN;
    private final transient boolean isParallel;
    private final transient boolean hasTopK;
    private final transient boolean hasTopN;
    private final transient boolean computeToGraph;
    private final NodeFilterSpec sourceNodeFilter;
    private final NodeFilterSpec targetNodeFilter;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableFilteredNodeSimilarityStreamConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<String> relationshipWeightProperty, double similarityCutoff, MetricSimilarityComputer.MetricSimilarityComputerBuilder similarityMetric, int degreeCutoff, int topK, int topN, int bottomK, int bottomN, NodeFilterSpec sourceNodeFilter, NodeFilterSpec targetNodeFilter) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableFilteredNodeSimilarityStreamConfig.createUnmodifiableList(false, ImmutableFilteredNodeSimilarityStreamConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableFilteredNodeSimilarityStreamConfig.createUnmodifiableList(false, ImmutableFilteredNodeSimilarityStreamConfig.createSafeList(nodeLabels, true, false)));
        this.relationshipWeightProperty = relationshipWeightProperty.orElse(null);
        this.initShim.similarityCutoff(similarityCutoff);
        this.initShim.similarityMetric(Objects.requireNonNull(similarityMetric, "similarityMetric"));
        this.initShim.degreeCutoff(degreeCutoff);
        this.initShim.topK(topK);
        this.initShim.topN(topN);
        this.initShim.bottomK(bottomK);
        this.initShim.bottomN(bottomN);
        this.initShim.sourceNodeFilter(Objects.requireNonNull(sourceNodeFilter, "sourceNodeFilter"));
        this.initShim.targetNodeFilter(Objects.requireNonNull(targetNodeFilter, "targetNodeFilter"));
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.similarityCutoff = this.initShim.similarityCutoff();
        this.similarityMetric = this.initShim.similarityMetric();
        this.degreeCutoff = this.initShim.degreeCutoff();
        this.topK = this.initShim.topK();
        this.topN = this.initShim.topN();
        this.bottomK = this.initShim.bottomK();
        this.bottomN = this.initShim.bottomN();
        this.normalizedK = this.initShim.normalizedK();
        this.normalizedN = this.initShim.normalizedN();
        this.isParallel = this.initShim.isParallel();
        this.hasTopK = this.initShim.hasTopK();
        this.hasTopN = this.initShim.hasTopN();
        this.computeToGraph = this.initShim.computeToGraph();
        this.sourceNodeFilter = this.initShim.sourceNodeFilter();
        this.targetNodeFilter = this.initShim.targetNodeFilter();
        this.initShim = null;
    }

    private ImmutableFilteredNodeSimilarityStreamConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, String relationshipWeightProperty, double similarityCutoff, MetricSimilarityComputer.MetricSimilarityComputerBuilder similarityMetric, int degreeCutoff, int topK, int topN, int bottomK, int bottomN, NodeFilterSpec sourceNodeFilter, NodeFilterSpec targetNodeFilter) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableFilteredNodeSimilarityStreamConfig.createUnmodifiableList(false, ImmutableFilteredNodeSimilarityStreamConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableFilteredNodeSimilarityStreamConfig.createUnmodifiableList(false, ImmutableFilteredNodeSimilarityStreamConfig.createSafeList(nodeLabels, true, false)));
        this.relationshipWeightProperty = relationshipWeightProperty;
        this.initShim.similarityCutoff(similarityCutoff);
        this.initShim.similarityMetric(Objects.requireNonNull(similarityMetric, "similarityMetric"));
        this.initShim.degreeCutoff(degreeCutoff);
        this.initShim.topK(topK);
        this.initShim.topN(topN);
        this.initShim.bottomK(bottomK);
        this.initShim.bottomN(bottomN);
        this.initShim.sourceNodeFilter(Objects.requireNonNull(sourceNodeFilter, "sourceNodeFilter"));
        this.initShim.targetNodeFilter(Objects.requireNonNull(targetNodeFilter, "targetNodeFilter"));
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.similarityCutoff = this.initShim.similarityCutoff();
        this.similarityMetric = this.initShim.similarityMetric();
        this.degreeCutoff = this.initShim.degreeCutoff();
        this.topK = this.initShim.topK();
        this.topN = this.initShim.topN();
        this.bottomK = this.initShim.bottomK();
        this.bottomN = this.initShim.bottomN();
        this.normalizedK = this.initShim.normalizedK();
        this.normalizedN = this.initShim.normalizedN();
        this.isParallel = this.initShim.isParallel();
        this.hasTopK = this.initShim.hasTopK();
        this.hasTopN = this.initShim.hasTopN();
        this.computeToGraph = this.initShim.computeToGraph();
        this.sourceNodeFilter = this.initShim.sourceNodeFilter();
        this.targetNodeFilter = this.initShim.targetNodeFilter();
        this.initShim = null;
    }

    private ImmutableFilteredNodeSimilarityStreamConfig(Builder builder) {
        this.usernameOverride = builder.usernameOverride;
        this.relationshipWeightProperty = builder.relationshipWeightProperty;
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.logProgressIsSet()) {
            this.initShim.logProgress(builder.logProgress);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.jobId != null) {
            this.initShim.jobId(builder.jobId);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableFilteredNodeSimilarityStreamConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableFilteredNodeSimilarityStreamConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.similarityCutoffIsSet()) {
            this.initShim.similarityCutoff(builder.similarityCutoff);
        }
        if (builder.similarityMetric != null) {
            this.initShim.similarityMetric(builder.similarityMetric);
        }
        if (builder.degreeCutoffIsSet()) {
            this.initShim.degreeCutoff(builder.degreeCutoff);
        }
        if (builder.topKIsSet()) {
            this.initShim.topK(builder.topK);
        }
        if (builder.topNIsSet()) {
            this.initShim.topN(builder.topN);
        }
        if (builder.bottomKIsSet()) {
            this.initShim.bottomK(builder.bottomK);
        }
        if (builder.bottomNIsSet()) {
            this.initShim.bottomN(builder.bottomN);
        }
        if (builder.sourceNodeFilter != null) {
            this.initShim.sourceNodeFilter(builder.sourceNodeFilter);
        }
        if (builder.targetNodeFilter != null) {
            this.initShim.targetNodeFilter(builder.targetNodeFilter);
        }
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.similarityCutoff = this.initShim.similarityCutoff();
        this.similarityMetric = this.initShim.similarityMetric();
        this.degreeCutoff = this.initShim.degreeCutoff();
        this.topK = this.initShim.topK();
        this.topN = this.initShim.topN();
        this.bottomK = this.initShim.bottomK();
        this.bottomN = this.initShim.bottomN();
        this.normalizedK = this.initShim.normalizedK();
        this.normalizedN = this.initShim.normalizedN();
        this.isParallel = this.initShim.isParallel();
        this.hasTopK = this.initShim.hasTopK();
        this.hasTopN = this.initShim.hasTopN();
        this.computeToGraph = this.initShim.computeToGraph();
        this.sourceNodeFilter = this.initShim.sourceNodeFilter();
        this.targetNodeFilter = this.initShim.targetNodeFilter();
        this.initShim = null;
    }

    private ImmutableFilteredNodeSimilarityStreamConfig(String usernameOverride, boolean sudo, boolean logProgress, Collection<String> configKeys, int concurrency, int minBatchSize, JobId jobId, List<String> relationshipTypes, List<String> nodeLabels, String relationshipWeightProperty, double similarityCutoff, MetricSimilarityComputer.MetricSimilarityComputerBuilder similarityMetric, int degreeCutoff, int topK, int topN, int bottomK, int bottomN, NodeFilterSpec sourceNodeFilter, NodeFilterSpec targetNodeFilter) {
        this.usernameOverride = usernameOverride;
        this.initShim.sudo(sudo);
        this.initShim.logProgress(logProgress);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.jobId(jobId);
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.relationshipWeightProperty = relationshipWeightProperty;
        this.initShim.similarityCutoff(similarityCutoff);
        this.initShim.similarityMetric(similarityMetric);
        this.initShim.degreeCutoff(degreeCutoff);
        this.initShim.topK(topK);
        this.initShim.topN(topN);
        this.initShim.bottomK(bottomK);
        this.initShim.bottomN(bottomN);
        this.initShim.sourceNodeFilter(sourceNodeFilter);
        this.initShim.targetNodeFilter(targetNodeFilter);
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.similarityCutoff = this.initShim.similarityCutoff();
        this.similarityMetric = this.initShim.similarityMetric();
        this.degreeCutoff = this.initShim.degreeCutoff();
        this.topK = this.initShim.topK();
        this.topN = this.initShim.topN();
        this.bottomK = this.initShim.bottomK();
        this.bottomN = this.initShim.bottomN();
        this.normalizedK = this.initShim.normalizedK();
        this.normalizedN = this.initShim.normalizedN();
        this.isParallel = this.initShim.isParallel();
        this.hasTopK = this.initShim.hasTopK();
        this.hasTopN = this.initShim.hasTopN();
        this.computeToGraph = this.initShim.computeToGraph();
        this.sourceNodeFilter = this.initShim.sourceNodeFilter();
        this.targetNodeFilter = this.initShim.targetNodeFilter();
        this.initShim = null;
    }

    private boolean sudoInitialize() {
        return FilteredNodeSimilarityStreamConfig.super.sudo();
    }

    private boolean logProgressInitialize() {
        return FilteredNodeSimilarityStreamConfig.super.logProgress();
    }

    private Collection<String> configKeysInitialize() {
        return FilteredNodeSimilarityStreamConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return FilteredNodeSimilarityStreamConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return FilteredNodeSimilarityStreamConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return FilteredNodeSimilarityStreamConfig.super.minBatchSize();
    }

    private JobId jobIdInitialize() {
        return FilteredNodeSimilarityStreamConfig.super.jobId();
    }

    private List<String> relationshipTypesInitialize() {
        return FilteredNodeSimilarityStreamConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return FilteredNodeSimilarityStreamConfig.super.nodeLabels();
    }

    private boolean hasRelationshipWeightPropertyInitialize() {
        return FilteredNodeSimilarityStreamConfig.super.hasRelationshipWeightProperty();
    }

    private double similarityCutoffInitialize() {
        return FilteredNodeSimilarityStreamConfig.super.similarityCutoff();
    }

    private MetricSimilarityComputer.MetricSimilarityComputerBuilder similarityMetricInitialize() {
        return FilteredNodeSimilarityStreamConfig.super.similarityMetric();
    }

    private int degreeCutoffInitialize() {
        return FilteredNodeSimilarityStreamConfig.super.degreeCutoff();
    }

    private int topKInitialize() {
        return FilteredNodeSimilarityStreamConfig.super.topK();
    }

    private int topNInitialize() {
        return FilteredNodeSimilarityStreamConfig.super.topN();
    }

    private int bottomKInitialize() {
        return FilteredNodeSimilarityStreamConfig.super.bottomK();
    }

    private int bottomNInitialize() {
        return FilteredNodeSimilarityStreamConfig.super.bottomN();
    }

    private int normalizedKInitialize() {
        return FilteredNodeSimilarityStreamConfig.super.normalizedK();
    }

    private int normalizedNInitialize() {
        return FilteredNodeSimilarityStreamConfig.super.normalizedN();
    }

    private boolean isParallelInitialize() {
        return FilteredNodeSimilarityStreamConfig.super.isParallel();
    }

    private boolean hasTopKInitialize() {
        return FilteredNodeSimilarityStreamConfig.super.hasTopK();
    }

    private boolean hasTopNInitialize() {
        return FilteredNodeSimilarityStreamConfig.super.hasTopN();
    }

    private boolean computeToGraphInitialize() {
        return FilteredNodeSimilarityStreamConfig.super.computeToGraph();
    }

    private NodeFilterSpec sourceNodeFilterInitialize() {
        return FilteredNodeSimilarityStreamConfig.super.sourceNodeFilter();
    }

    private NodeFilterSpec targetNodeFilterInitialize() {
        return FilteredNodeSimilarityStreamConfig.super.targetNodeFilter();
    }

    public Optional<String> usernameOverride() {
        return Optional.ofNullable(this.usernameOverride);
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public boolean logProgress() {
        InitShim shim = this.initShim;
        return shim != null ? shim.logProgress() : this.logProgress;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    public JobId jobId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.jobId() : this.jobId;
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    public Optional<String> relationshipWeightProperty() {
        return Optional.ofNullable(this.relationshipWeightProperty);
    }

    public boolean hasRelationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasRelationshipWeightProperty() : this.hasRelationshipWeightProperty;
    }

    @Override
    public double similarityCutoff() {
        InitShim shim = this.initShim;
        return shim != null ? shim.similarityCutoff() : this.similarityCutoff;
    }

    @Override
    public MetricSimilarityComputer.MetricSimilarityComputerBuilder similarityMetric() {
        InitShim shim = this.initShim;
        return shim != null ? shim.similarityMetric() : this.similarityMetric;
    }

    @Override
    public int degreeCutoff() {
        InitShim shim = this.initShim;
        return shim != null ? shim.degreeCutoff() : this.degreeCutoff;
    }

    @Override
    public int topK() {
        InitShim shim = this.initShim;
        return shim != null ? shim.topK() : this.topK;
    }

    @Override
    public int topN() {
        InitShim shim = this.initShim;
        return shim != null ? shim.topN() : this.topN;
    }

    @Override
    public int bottomK() {
        InitShim shim = this.initShim;
        return shim != null ? shim.bottomK() : this.bottomK;
    }

    @Override
    public int bottomN() {
        InitShim shim = this.initShim;
        return shim != null ? shim.bottomN() : this.bottomN;
    }

    @Override
    public int normalizedK() {
        InitShim shim = this.initShim;
        return shim != null ? shim.normalizedK() : this.normalizedK;
    }

    @Override
    public int normalizedN() {
        InitShim shim = this.initShim;
        return shim != null ? shim.normalizedN() : this.normalizedN;
    }

    @Override
    public boolean isParallel() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isParallel() : this.isParallel;
    }

    @Override
    public boolean hasTopK() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasTopK() : this.hasTopK;
    }

    @Override
    public boolean hasTopN() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasTopN() : this.hasTopN;
    }

    @Override
    public boolean computeToGraph() {
        InitShim shim = this.initShim;
        return shim != null ? shim.computeToGraph() : this.computeToGraph;
    }

    @Override
    public NodeFilterSpec sourceNodeFilter() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sourceNodeFilter() : this.sourceNodeFilter;
    }

    @Override
    public NodeFilterSpec targetNodeFilter() {
        InitShim shim = this.initShim;
        return shim != null ? shim.targetNodeFilter() : this.targetNodeFilter;
    }

    public final ImmutableFilteredNodeSimilarityStreamConfig withUsernameOverride(String value) {
        String newValue = value;
        if (Objects.equals(this.usernameOverride, newValue)) {
            return this;
        }
        return ImmutableFilteredNodeSimilarityStreamConfig.validate(new ImmutableFilteredNodeSimilarityStreamConfig(newValue, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.sourceNodeFilter, this.targetNodeFilter));
    }

    public final ImmutableFilteredNodeSimilarityStreamConfig withUsernameOverride(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableFilteredNodeSimilarityStreamConfig.validate(new ImmutableFilteredNodeSimilarityStreamConfig(value, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.sourceNodeFilter, this.targetNodeFilter));
    }

    public final ImmutableFilteredNodeSimilarityStreamConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableFilteredNodeSimilarityStreamConfig.validate(new ImmutableFilteredNodeSimilarityStreamConfig(this.usernameOverride, value, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.sourceNodeFilter, this.targetNodeFilter));
    }

    public final ImmutableFilteredNodeSimilarityStreamConfig withLogProgress(boolean value) {
        if (this.logProgress == value) {
            return this;
        }
        return ImmutableFilteredNodeSimilarityStreamConfig.validate(new ImmutableFilteredNodeSimilarityStreamConfig(this.usernameOverride, this.sudo, value, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.sourceNodeFilter, this.targetNodeFilter));
    }

    public final ImmutableFilteredNodeSimilarityStreamConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableFilteredNodeSimilarityStreamConfig.validate(new ImmutableFilteredNodeSimilarityStreamConfig(this.usernameOverride, this.sudo, this.logProgress, newValue, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.sourceNodeFilter, this.targetNodeFilter));
    }

    public final ImmutableFilteredNodeSimilarityStreamConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableFilteredNodeSimilarityStreamConfig.validate(new ImmutableFilteredNodeSimilarityStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, value, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.sourceNodeFilter, this.targetNodeFilter));
    }

    public final ImmutableFilteredNodeSimilarityStreamConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutableFilteredNodeSimilarityStreamConfig.validate(new ImmutableFilteredNodeSimilarityStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, value, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.sourceNodeFilter, this.targetNodeFilter));
    }

    public final ImmutableFilteredNodeSimilarityStreamConfig withJobId(JobId value) {
        if (this.jobId == value) {
            return this;
        }
        JobId newValue = Objects.requireNonNull(value, "jobId");
        return ImmutableFilteredNodeSimilarityStreamConfig.validate(new ImmutableFilteredNodeSimilarityStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.sourceNodeFilter, this.targetNodeFilter));
    }

    public final ImmutableFilteredNodeSimilarityStreamConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableFilteredNodeSimilarityStreamConfig.createUnmodifiableList(false, ImmutableFilteredNodeSimilarityStreamConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableFilteredNodeSimilarityStreamConfig.validate(new ImmutableFilteredNodeSimilarityStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, newValue, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.sourceNodeFilter, this.targetNodeFilter));
    }

    public final ImmutableFilteredNodeSimilarityStreamConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableFilteredNodeSimilarityStreamConfig.createUnmodifiableList(false, ImmutableFilteredNodeSimilarityStreamConfig.createSafeList(elements, true, false));
        return ImmutableFilteredNodeSimilarityStreamConfig.validate(new ImmutableFilteredNodeSimilarityStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, newValue, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.sourceNodeFilter, this.targetNodeFilter));
    }

    public final ImmutableFilteredNodeSimilarityStreamConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableFilteredNodeSimilarityStreamConfig.createUnmodifiableList(false, ImmutableFilteredNodeSimilarityStreamConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableFilteredNodeSimilarityStreamConfig.validate(new ImmutableFilteredNodeSimilarityStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, newValue, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.sourceNodeFilter, this.targetNodeFilter));
    }

    public final ImmutableFilteredNodeSimilarityStreamConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableFilteredNodeSimilarityStreamConfig.createUnmodifiableList(false, ImmutableFilteredNodeSimilarityStreamConfig.createSafeList(elements, true, false));
        return ImmutableFilteredNodeSimilarityStreamConfig.validate(new ImmutableFilteredNodeSimilarityStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, newValue, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.sourceNodeFilter, this.targetNodeFilter));
    }

    public final ImmutableFilteredNodeSimilarityStreamConfig withRelationshipWeightProperty(String value) {
        String newValue = value;
        if (Objects.equals(this.relationshipWeightProperty, newValue)) {
            return this;
        }
        return ImmutableFilteredNodeSimilarityStreamConfig.validate(new ImmutableFilteredNodeSimilarityStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, newValue, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.sourceNodeFilter, this.targetNodeFilter));
    }

    public final ImmutableFilteredNodeSimilarityStreamConfig withRelationshipWeightProperty(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.relationshipWeightProperty, value)) {
            return this;
        }
        return ImmutableFilteredNodeSimilarityStreamConfig.validate(new ImmutableFilteredNodeSimilarityStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, value, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.sourceNodeFilter, this.targetNodeFilter));
    }

    public final ImmutableFilteredNodeSimilarityStreamConfig withSimilarityCutoff(double value) {
        if (Double.doubleToLongBits(this.similarityCutoff) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableFilteredNodeSimilarityStreamConfig.validate(new ImmutableFilteredNodeSimilarityStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, value, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.sourceNodeFilter, this.targetNodeFilter));
    }

    public final ImmutableFilteredNodeSimilarityStreamConfig withSimilarityMetric(MetricSimilarityComputer.MetricSimilarityComputerBuilder value) {
        if (this.similarityMetric == value) {
            return this;
        }
        MetricSimilarityComputer.MetricSimilarityComputerBuilder newValue = Objects.requireNonNull(value, "similarityMetric");
        return ImmutableFilteredNodeSimilarityStreamConfig.validate(new ImmutableFilteredNodeSimilarityStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, newValue, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.sourceNodeFilter, this.targetNodeFilter));
    }

    public final ImmutableFilteredNodeSimilarityStreamConfig withDegreeCutoff(int value) {
        if (this.degreeCutoff == value) {
            return this;
        }
        return ImmutableFilteredNodeSimilarityStreamConfig.validate(new ImmutableFilteredNodeSimilarityStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, value, this.topK, this.topN, this.bottomK, this.bottomN, this.sourceNodeFilter, this.targetNodeFilter));
    }

    public final ImmutableFilteredNodeSimilarityStreamConfig withTopK(int value) {
        if (this.topK == value) {
            return this;
        }
        return ImmutableFilteredNodeSimilarityStreamConfig.validate(new ImmutableFilteredNodeSimilarityStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, value, this.topN, this.bottomK, this.bottomN, this.sourceNodeFilter, this.targetNodeFilter));
    }

    public final ImmutableFilteredNodeSimilarityStreamConfig withTopN(int value) {
        if (this.topN == value) {
            return this;
        }
        return ImmutableFilteredNodeSimilarityStreamConfig.validate(new ImmutableFilteredNodeSimilarityStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, value, this.bottomK, this.bottomN, this.sourceNodeFilter, this.targetNodeFilter));
    }

    public final ImmutableFilteredNodeSimilarityStreamConfig withBottomK(int value) {
        if (this.bottomK == value) {
            return this;
        }
        return ImmutableFilteredNodeSimilarityStreamConfig.validate(new ImmutableFilteredNodeSimilarityStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, value, this.bottomN, this.sourceNodeFilter, this.targetNodeFilter));
    }

    public final ImmutableFilteredNodeSimilarityStreamConfig withBottomN(int value) {
        if (this.bottomN == value) {
            return this;
        }
        return ImmutableFilteredNodeSimilarityStreamConfig.validate(new ImmutableFilteredNodeSimilarityStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, value, this.sourceNodeFilter, this.targetNodeFilter));
    }

    public final ImmutableFilteredNodeSimilarityStreamConfig withSourceNodeFilter(NodeFilterSpec value) {
        if (this.sourceNodeFilter == value) {
            return this;
        }
        NodeFilterSpec newValue = Objects.requireNonNull(value, "sourceNodeFilter");
        return ImmutableFilteredNodeSimilarityStreamConfig.validate(new ImmutableFilteredNodeSimilarityStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, newValue, this.targetNodeFilter));
    }

    public final ImmutableFilteredNodeSimilarityStreamConfig withTargetNodeFilter(NodeFilterSpec value) {
        if (this.targetNodeFilter == value) {
            return this;
        }
        NodeFilterSpec newValue = Objects.requireNonNull(value, "targetNodeFilter");
        return ImmutableFilteredNodeSimilarityStreamConfig.validate(new ImmutableFilteredNodeSimilarityStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.sourceNodeFilter, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFilteredNodeSimilarityStreamConfig && this.equalTo((ImmutableFilteredNodeSimilarityStreamConfig)another);
    }

    private boolean equalTo(ImmutableFilteredNodeSimilarityStreamConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.logProgress == another.logProgress && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && this.jobId.equals((Object)another.jobId) && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && Objects.equals(this.relationshipWeightProperty, another.relationshipWeightProperty) && this.hasRelationshipWeightProperty == another.hasRelationshipWeightProperty && Double.doubleToLongBits(this.similarityCutoff) == Double.doubleToLongBits(another.similarityCutoff) && this.similarityMetric.equals(another.similarityMetric) && this.degreeCutoff == another.degreeCutoff && this.topK == another.topK && this.topN == another.topN && this.bottomK == another.bottomK && this.bottomN == another.bottomN && this.normalizedK == another.normalizedK && this.normalizedN == another.normalizedN && this.isParallel == another.isParallel && this.hasTopK == another.hasTopK && this.hasTopN == another.hasTopN && this.computeToGraph == another.computeToGraph && this.sourceNodeFilter.equals(another.sourceNodeFilter) && this.targetNodeFilter.equals(another.targetNodeFilter);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + Boolean.hashCode(this.logProgress);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + this.jobId.hashCode();
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + Objects.hashCode(this.relationshipWeightProperty);
        h += (h << 5) + Boolean.hashCode(this.hasRelationshipWeightProperty);
        h += (h << 5) + Double.hashCode(this.similarityCutoff);
        h += (h << 5) + this.similarityMetric.hashCode();
        h += (h << 5) + this.degreeCutoff;
        h += (h << 5) + this.topK;
        h += (h << 5) + this.topN;
        h += (h << 5) + this.bottomK;
        h += (h << 5) + this.bottomN;
        h += (h << 5) + this.normalizedK;
        h += (h << 5) + this.normalizedN;
        h += (h << 5) + Boolean.hashCode(this.isParallel);
        h += (h << 5) + Boolean.hashCode(this.hasTopK);
        h += (h << 5) + Boolean.hashCode(this.hasTopN);
        h += (h << 5) + Boolean.hashCode(this.computeToGraph);
        h += (h << 5) + this.sourceNodeFilter.hashCode();
        h += (h << 5) + this.targetNodeFilter.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("FilteredNodeSimilarityStreamConfig{");
        if (this.usernameOverride != null) {
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        if (builder.length() > 35) {
            builder.append(", ");
        }
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("logProgress=").append(this.logProgress);
        builder.append(", ");
        builder.append("concurrency=").append(this.concurrency);
        builder.append(", ");
        builder.append("minBatchSize=").append(this.minBatchSize);
        builder.append(", ");
        builder.append("jobId=").append(this.jobId);
        builder.append(", ");
        builder.append("relationshipTypes=").append(this.relationshipTypes);
        builder.append(", ");
        builder.append("nodeLabels=").append(this.nodeLabels);
        if (this.relationshipWeightProperty != null) {
            builder.append(", ");
            builder.append("relationshipWeightProperty=").append(this.relationshipWeightProperty);
        }
        builder.append(", ");
        builder.append("hasRelationshipWeightProperty=").append(this.hasRelationshipWeightProperty);
        builder.append(", ");
        builder.append("similarityCutoff=").append(this.similarityCutoff);
        builder.append(", ");
        builder.append("similarityMetric=").append(this.similarityMetric);
        builder.append(", ");
        builder.append("degreeCutoff=").append(this.degreeCutoff);
        builder.append(", ");
        builder.append("topK=").append(this.topK);
        builder.append(", ");
        builder.append("topN=").append(this.topN);
        builder.append(", ");
        builder.append("bottomK=").append(this.bottomK);
        builder.append(", ");
        builder.append("bottomN=").append(this.bottomN);
        builder.append(", ");
        builder.append("normalizedK=").append(this.normalizedK);
        builder.append(", ");
        builder.append("normalizedN=").append(this.normalizedN);
        builder.append(", ");
        builder.append("isParallel=").append(this.isParallel);
        builder.append(", ");
        builder.append("hasTopK=").append(this.hasTopK);
        builder.append(", ");
        builder.append("hasTopN=").append(this.hasTopN);
        builder.append(", ");
        builder.append("computeToGraph=").append(this.computeToGraph);
        builder.append(", ");
        builder.append("sourceNodeFilter=").append(this.sourceNodeFilter);
        builder.append(", ");
        builder.append("targetNodeFilter=").append(this.targetNodeFilter);
        return builder.append("}").toString();
    }

    public static FilteredNodeSimilarityStreamConfig of(int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, Optional<String> relationshipWeightProperty, double similarityCutoff, MetricSimilarityComputer.MetricSimilarityComputerBuilder similarityMetric, int degreeCutoff, int topK, int topN, int bottomK, int bottomN, NodeFilterSpec sourceNodeFilter, NodeFilterSpec targetNodeFilter) {
        return ImmutableFilteredNodeSimilarityStreamConfig.of(concurrency, minBatchSize, relationshipTypes, nodeLabels, relationshipWeightProperty, similarityCutoff, similarityMetric, degreeCutoff, topK, topN, bottomK, bottomN, sourceNodeFilter, targetNodeFilter);
    }

    public static FilteredNodeSimilarityStreamConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<String> relationshipWeightProperty, double similarityCutoff, MetricSimilarityComputer.MetricSimilarityComputerBuilder similarityMetric, int degreeCutoff, int topK, int topN, int bottomK, int bottomN, NodeFilterSpec sourceNodeFilter, NodeFilterSpec targetNodeFilter) {
        return ImmutableFilteredNodeSimilarityStreamConfig.validate(new ImmutableFilteredNodeSimilarityStreamConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, relationshipWeightProperty, similarityCutoff, similarityMetric, degreeCutoff, topK, topN, bottomK, bottomN, sourceNodeFilter, targetNodeFilter));
    }

    public static FilteredNodeSimilarityStreamConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, String relationshipWeightProperty, double similarityCutoff, MetricSimilarityComputer.MetricSimilarityComputerBuilder similarityMetric, int degreeCutoff, int topK, int topN, int bottomK, int bottomN, NodeFilterSpec sourceNodeFilter, NodeFilterSpec targetNodeFilter) {
        return ImmutableFilteredNodeSimilarityStreamConfig.validate(new ImmutableFilteredNodeSimilarityStreamConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, relationshipWeightProperty, similarityCutoff, similarityMetric, degreeCutoff, topK, topN, bottomK, bottomN, sourceNodeFilter, targetNodeFilter));
    }

    private static ImmutableFilteredNodeSimilarityStreamConfig validate(ImmutableFilteredNodeSimilarityStreamConfig instance) {
        instance.validate();
        instance.validateRelationshipWeightProperty();
        instance.validateConcurrency();
        return instance;
    }

    public static FilteredNodeSimilarityStreamConfig copyOf(FilteredNodeSimilarityStreamConfig instance) {
        if (instance instanceof ImmutableFilteredNodeSimilarityStreamConfig) {
            return (ImmutableFilteredNodeSimilarityStreamConfig)instance;
        }
        return ImmutableFilteredNodeSimilarityStreamConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="FilteredNodeSimilarityStreamConfig", generator="Immutables")
    public static final class Builder {
        private static final long OPT_BIT_SUDO = 1L;
        private static final long OPT_BIT_LOG_PROGRESS = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 8L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 16L;
        private static final long OPT_BIT_NODE_LABELS = 32L;
        private static final long OPT_BIT_SIMILARITY_CUTOFF = 64L;
        private static final long OPT_BIT_DEGREE_CUTOFF = 128L;
        private static final long OPT_BIT_TOP_K = 256L;
        private static final long OPT_BIT_TOP_N = 512L;
        private static final long OPT_BIT_BOTTOM_K = 1024L;
        private static final long OPT_BIT_BOTTOM_N = 2048L;
        private long optBits;
        private String usernameOverride;
        private boolean sudo;
        private boolean logProgress;
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        private JobId jobId;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        private String relationshipWeightProperty;
        private double similarityCutoff;
        private MetricSimilarityComputer.MetricSimilarityComputerBuilder similarityMetric;
        private int degreeCutoff;
        private int topK;
        private int topN;
        private int bottomK;
        private int bottomN;
        private NodeFilterSpec sourceNodeFilter;
        private NodeFilterSpec targetNodeFilter;

        private Builder() {
        }

        public final Builder from(NodeSimilarityBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RelationshipWeightConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(JobIdConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(FilteredNodeSimilarityBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(FilteredNodeSimilarityStreamConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional relationshipWeightPropertyOptional;
            NodeSimilarityBaseConfig instance;
            if (object instanceof NodeSimilarityBaseConfig) {
                instance = (NodeSimilarityBaseConfig)object;
                this.topK(instance.topK());
                this.similarityMetric(instance.similarityMetric());
                this.bottomK(instance.bottomK());
                this.degreeCutoff(instance.degreeCutoff());
                this.bottomN(instance.bottomN());
                this.similarityCutoff(instance.similarityCutoff());
                this.topN(instance.topN());
            }
            if (object instanceof RelationshipWeightConfig && (relationshipWeightPropertyOptional = (instance = (RelationshipWeightConfig)object).relationshipWeightProperty()).isPresent()) {
                this.relationshipWeightProperty(relationshipWeightPropertyOptional);
            }
            if (object instanceof JobIdConfig) {
                instance = (JobIdConfig)object;
                this.jobId(instance.jobId());
            }
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                this.minBatchSize(instance.minBatchSize());
                this.concurrency(instance.concurrency());
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                this.logProgress(instance.logProgress());
                this.sudo(instance.sudo());
                Optional usernameOverrideOptional = instance.usernameOverride();
                if (usernameOverrideOptional.isPresent()) {
                    this.usernameOverride(usernameOverrideOptional);
                }
                this.configKeys(instance.configKeys());
            }
            if (object instanceof FilteredNodeSimilarityBaseConfig) {
                instance = (FilteredNodeSimilarityBaseConfig)object;
                this.targetNodeFilter(instance.targetNodeFilter());
                this.sourceNodeFilter(instance.sourceNodeFilter());
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                this.addAllRelationshipTypes(instance.relationshipTypes());
                this.addAllNodeLabels(instance.nodeLabels());
            }
        }

        public final Builder usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            return this;
        }

        public final Builder usernameOverride(Optional<String> usernameOverride) {
            this.usernameOverride = usernameOverride.orElse(null);
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 1L;
            return this;
        }

        public final Builder logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder jobId(JobId jobId) {
            this.jobId = Objects.requireNonNull(jobId, "jobId");
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder relationshipWeightProperty(String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            return this;
        }

        public final Builder relationshipWeightProperty(Optional<String> relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty.orElse(null);
            return this;
        }

        public final Builder similarityCutoff(double similarityCutoff) {
            this.similarityCutoff = similarityCutoff;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder similarityMetric(MetricSimilarityComputer.MetricSimilarityComputerBuilder similarityMetric) {
            this.similarityMetric = Objects.requireNonNull(similarityMetric, "similarityMetric");
            return this;
        }

        public final Builder degreeCutoff(int degreeCutoff) {
            this.degreeCutoff = degreeCutoff;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder topK(int topK) {
            this.topK = topK;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder topN(int topN) {
            this.topN = topN;
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder bottomK(int bottomK) {
            this.bottomK = bottomK;
            this.optBits |= 0x400L;
            return this;
        }

        public final Builder bottomN(int bottomN) {
            this.bottomN = bottomN;
            this.optBits |= 0x800L;
            return this;
        }

        public final Builder sourceNodeFilter(NodeFilterSpec sourceNodeFilter) {
            this.sourceNodeFilter = Objects.requireNonNull(sourceNodeFilter, "sourceNodeFilter");
            return this;
        }

        public final Builder targetNodeFilter(NodeFilterSpec targetNodeFilter) {
            this.targetNodeFilter = Objects.requireNonNull(targetNodeFilter, "targetNodeFilter");
            return this;
        }

        public Builder clear() {
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.logProgress = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            this.jobId = null;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.relationshipWeightProperty = null;
            this.similarityCutoff = 0.0;
            this.similarityMetric = null;
            this.degreeCutoff = 0;
            this.topK = 0;
            this.topN = 0;
            this.bottomK = 0;
            this.bottomN = 0;
            this.sourceNodeFilter = null;
            this.targetNodeFilter = null;
            return this;
        }

        public FilteredNodeSimilarityStreamConfig build() {
            return ImmutableFilteredNodeSimilarityStreamConfig.validate(new ImmutableFilteredNodeSimilarityStreamConfig(this));
        }

        private boolean sudoIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean logProgressIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean similarityCutoffIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean degreeCutoffIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean topKIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean topNIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean bottomKIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private boolean bottomNIsSet() {
            return (this.optBits & 0x800L) != 0L;
        }
    }

    @Generated(from="FilteredNodeSimilarityStreamConfig", generator="Immutables")
    private final class InitShim {
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte logProgressBuildStage = 0;
        private boolean logProgress;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte jobIdBuildStage = 0;
        private JobId jobId;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte hasRelationshipWeightPropertyBuildStage = 0;
        private boolean hasRelationshipWeightProperty;
        private byte similarityCutoffBuildStage = 0;
        private double similarityCutoff;
        private byte similarityMetricBuildStage = 0;
        private MetricSimilarityComputer.MetricSimilarityComputerBuilder similarityMetric;
        private byte degreeCutoffBuildStage = 0;
        private int degreeCutoff;
        private byte topKBuildStage = 0;
        private int topK;
        private byte topNBuildStage = 0;
        private int topN;
        private byte bottomKBuildStage = 0;
        private int bottomK;
        private byte bottomNBuildStage = 0;
        private int bottomN;
        private byte normalizedKBuildStage = 0;
        private int normalizedK;
        private byte normalizedNBuildStage = 0;
        private int normalizedN;
        private byte isParallelBuildStage = 0;
        private boolean isParallel;
        private byte hasTopKBuildStage = 0;
        private boolean hasTopK;
        private byte hasTopNBuildStage = 0;
        private boolean hasTopN;
        private byte computeToGraphBuildStage = 0;
        private boolean computeToGraph;
        private byte sourceNodeFilterBuildStage = 0;
        private NodeFilterSpec sourceNodeFilter;
        private byte targetNodeFilterBuildStage = 0;
        private NodeFilterSpec targetNodeFilter;

        private InitShim() {
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableFilteredNodeSimilarityStreamConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        boolean logProgress() {
            if (this.logProgressBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.logProgressBuildStage == 0) {
                this.logProgressBuildStage = (byte)-1;
                this.logProgress = ImmutableFilteredNodeSimilarityStreamConfig.this.logProgressInitialize();
                this.logProgressBuildStage = 1;
            }
            return this.logProgress;
        }

        void logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.logProgressBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableFilteredNodeSimilarityStreamConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableFilteredNodeSimilarityStreamConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableFilteredNodeSimilarityStreamConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutableFilteredNodeSimilarityStreamConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        JobId jobId() {
            if (this.jobIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.jobIdBuildStage == 0) {
                this.jobIdBuildStage = (byte)-1;
                this.jobId = Objects.requireNonNull(ImmutableFilteredNodeSimilarityStreamConfig.this.jobIdInitialize(), "jobId");
                this.jobIdBuildStage = 1;
            }
            return this.jobId;
        }

        void jobId(JobId jobId) {
            this.jobId = jobId;
            this.jobIdBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableFilteredNodeSimilarityStreamConfig.createUnmodifiableList(false, ImmutableFilteredNodeSimilarityStreamConfig.createSafeList(ImmutableFilteredNodeSimilarityStreamConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableFilteredNodeSimilarityStreamConfig.createUnmodifiableList(false, ImmutableFilteredNodeSimilarityStreamConfig.createSafeList(ImmutableFilteredNodeSimilarityStreamConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        boolean hasRelationshipWeightProperty() {
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasRelationshipWeightPropertyBuildStage == 0) {
                this.hasRelationshipWeightPropertyBuildStage = (byte)-1;
                this.hasRelationshipWeightProperty = ImmutableFilteredNodeSimilarityStreamConfig.this.hasRelationshipWeightPropertyInitialize();
                this.hasRelationshipWeightPropertyBuildStage = 1;
            }
            return this.hasRelationshipWeightProperty;
        }

        double similarityCutoff() {
            if (this.similarityCutoffBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.similarityCutoffBuildStage == 0) {
                this.similarityCutoffBuildStage = (byte)-1;
                this.similarityCutoff = ImmutableFilteredNodeSimilarityStreamConfig.this.similarityCutoffInitialize();
                this.similarityCutoffBuildStage = 1;
            }
            return this.similarityCutoff;
        }

        void similarityCutoff(double similarityCutoff) {
            this.similarityCutoff = similarityCutoff;
            this.similarityCutoffBuildStage = 1;
        }

        MetricSimilarityComputer.MetricSimilarityComputerBuilder similarityMetric() {
            if (this.similarityMetricBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.similarityMetricBuildStage == 0) {
                this.similarityMetricBuildStage = (byte)-1;
                this.similarityMetric = Objects.requireNonNull(ImmutableFilteredNodeSimilarityStreamConfig.this.similarityMetricInitialize(), "similarityMetric");
                this.similarityMetricBuildStage = 1;
            }
            return this.similarityMetric;
        }

        void similarityMetric(MetricSimilarityComputer.MetricSimilarityComputerBuilder similarityMetric) {
            this.similarityMetric = similarityMetric;
            this.similarityMetricBuildStage = 1;
        }

        int degreeCutoff() {
            if (this.degreeCutoffBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.degreeCutoffBuildStage == 0) {
                this.degreeCutoffBuildStage = (byte)-1;
                this.degreeCutoff = ImmutableFilteredNodeSimilarityStreamConfig.this.degreeCutoffInitialize();
                this.degreeCutoffBuildStage = 1;
            }
            return this.degreeCutoff;
        }

        void degreeCutoff(int degreeCutoff) {
            this.degreeCutoff = degreeCutoff;
            this.degreeCutoffBuildStage = 1;
        }

        int topK() {
            if (this.topKBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.topKBuildStage == 0) {
                this.topKBuildStage = (byte)-1;
                this.topK = ImmutableFilteredNodeSimilarityStreamConfig.this.topKInitialize();
                this.topKBuildStage = 1;
            }
            return this.topK;
        }

        void topK(int topK) {
            this.topK = topK;
            this.topKBuildStage = 1;
        }

        int topN() {
            if (this.topNBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.topNBuildStage == 0) {
                this.topNBuildStage = (byte)-1;
                this.topN = ImmutableFilteredNodeSimilarityStreamConfig.this.topNInitialize();
                this.topNBuildStage = 1;
            }
            return this.topN;
        }

        void topN(int topN) {
            this.topN = topN;
            this.topNBuildStage = 1;
        }

        int bottomK() {
            if (this.bottomKBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.bottomKBuildStage == 0) {
                this.bottomKBuildStage = (byte)-1;
                this.bottomK = ImmutableFilteredNodeSimilarityStreamConfig.this.bottomKInitialize();
                this.bottomKBuildStage = 1;
            }
            return this.bottomK;
        }

        void bottomK(int bottomK) {
            this.bottomK = bottomK;
            this.bottomKBuildStage = 1;
        }

        int bottomN() {
            if (this.bottomNBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.bottomNBuildStage == 0) {
                this.bottomNBuildStage = (byte)-1;
                this.bottomN = ImmutableFilteredNodeSimilarityStreamConfig.this.bottomNInitialize();
                this.bottomNBuildStage = 1;
            }
            return this.bottomN;
        }

        void bottomN(int bottomN) {
            this.bottomN = bottomN;
            this.bottomNBuildStage = 1;
        }

        int normalizedK() {
            if (this.normalizedKBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.normalizedKBuildStage == 0) {
                this.normalizedKBuildStage = (byte)-1;
                this.normalizedK = ImmutableFilteredNodeSimilarityStreamConfig.this.normalizedKInitialize();
                this.normalizedKBuildStage = 1;
            }
            return this.normalizedK;
        }

        int normalizedN() {
            if (this.normalizedNBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.normalizedNBuildStage == 0) {
                this.normalizedNBuildStage = (byte)-1;
                this.normalizedN = ImmutableFilteredNodeSimilarityStreamConfig.this.normalizedNInitialize();
                this.normalizedNBuildStage = 1;
            }
            return this.normalizedN;
        }

        boolean isParallel() {
            if (this.isParallelBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isParallelBuildStage == 0) {
                this.isParallelBuildStage = (byte)-1;
                this.isParallel = ImmutableFilteredNodeSimilarityStreamConfig.this.isParallelInitialize();
                this.isParallelBuildStage = 1;
            }
            return this.isParallel;
        }

        boolean hasTopK() {
            if (this.hasTopKBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasTopKBuildStage == 0) {
                this.hasTopKBuildStage = (byte)-1;
                this.hasTopK = ImmutableFilteredNodeSimilarityStreamConfig.this.hasTopKInitialize();
                this.hasTopKBuildStage = 1;
            }
            return this.hasTopK;
        }

        boolean hasTopN() {
            if (this.hasTopNBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasTopNBuildStage == 0) {
                this.hasTopNBuildStage = (byte)-1;
                this.hasTopN = ImmutableFilteredNodeSimilarityStreamConfig.this.hasTopNInitialize();
                this.hasTopNBuildStage = 1;
            }
            return this.hasTopN;
        }

        boolean computeToGraph() {
            if (this.computeToGraphBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.computeToGraphBuildStage == 0) {
                this.computeToGraphBuildStage = (byte)-1;
                this.computeToGraph = ImmutableFilteredNodeSimilarityStreamConfig.this.computeToGraphInitialize();
                this.computeToGraphBuildStage = 1;
            }
            return this.computeToGraph;
        }

        NodeFilterSpec sourceNodeFilter() {
            if (this.sourceNodeFilterBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sourceNodeFilterBuildStage == 0) {
                this.sourceNodeFilterBuildStage = (byte)-1;
                this.sourceNodeFilter = Objects.requireNonNull(ImmutableFilteredNodeSimilarityStreamConfig.this.sourceNodeFilterInitialize(), "sourceNodeFilter");
                this.sourceNodeFilterBuildStage = 1;
            }
            return this.sourceNodeFilter;
        }

        void sourceNodeFilter(NodeFilterSpec sourceNodeFilter) {
            this.sourceNodeFilter = sourceNodeFilter;
            this.sourceNodeFilterBuildStage = 1;
        }

        NodeFilterSpec targetNodeFilter() {
            if (this.targetNodeFilterBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.targetNodeFilterBuildStage == 0) {
                this.targetNodeFilterBuildStage = (byte)-1;
                this.targetNodeFilter = Objects.requireNonNull(ImmutableFilteredNodeSimilarityStreamConfig.this.targetNodeFilterInitialize(), "targetNodeFilter");
                this.targetNodeFilterBuildStage = 1;
            }
            return this.targetNodeFilter;
        }

        void targetNodeFilter(NodeFilterSpec targetNodeFilter) {
            this.targetNodeFilter = targetNodeFilter;
            this.targetNodeFilterBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.logProgressBuildStage == -1) {
                attributes.add("logProgress");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.jobIdBuildStage == -1) {
                attributes.add("jobId");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                attributes.add("hasRelationshipWeightProperty");
            }
            if (this.similarityCutoffBuildStage == -1) {
                attributes.add("similarityCutoff");
            }
            if (this.similarityMetricBuildStage == -1) {
                attributes.add("similarityMetric");
            }
            if (this.degreeCutoffBuildStage == -1) {
                attributes.add("degreeCutoff");
            }
            if (this.topKBuildStage == -1) {
                attributes.add("topK");
            }
            if (this.topNBuildStage == -1) {
                attributes.add("topN");
            }
            if (this.bottomKBuildStage == -1) {
                attributes.add("bottomK");
            }
            if (this.bottomNBuildStage == -1) {
                attributes.add("bottomN");
            }
            if (this.normalizedKBuildStage == -1) {
                attributes.add("normalizedK");
            }
            if (this.normalizedNBuildStage == -1) {
                attributes.add("normalizedN");
            }
            if (this.isParallelBuildStage == -1) {
                attributes.add("isParallel");
            }
            if (this.hasTopKBuildStage == -1) {
                attributes.add("hasTopK");
            }
            if (this.hasTopNBuildStage == -1) {
                attributes.add("hasTopN");
            }
            if (this.computeToGraphBuildStage == -1) {
                attributes.add("computeToGraph");
            }
            if (this.sourceNodeFilterBuildStage == -1) {
                attributes.add("sourceNodeFilter");
            }
            if (this.targetNodeFilterBuildStage == -1) {
                attributes.add("targetNodeFilter");
            }
            return "Cannot build FilteredNodeSimilarityStreamConfig, attribute initializers form cycle " + attributes;
        }
    }
}

