/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.filtering;

import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.similarity.filtering.NodeFilter;
import org.neo4j.gds.utils.StringFormatting;

public final class LabelNodeFilter
implements NodeFilter {
    private final NodeLabel label;
    private final IdMap idMap;

    public static LabelNodeFilter create(String labelString, IdMap idMap) {
        NodeLabel label = null;
        for (NodeLabel existingLabel : idMap.availableNodeLabels()) {
            if (!existingLabel.name.equalsIgnoreCase(labelString)) continue;
            label = existingLabel;
        }
        if (null == label) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"The label `%s` does not exist in the graph", (Object[])new Object[]{labelString}));
        }
        return new LabelNodeFilter(label, idMap);
    }

    private LabelNodeFilter(NodeLabel label, IdMap idMap) {
        this.label = label;
        this.idMap = idMap;
    }

    @Override
    public boolean test(long nodeId) {
        return this.idMap.hasLabel(nodeId, this.label);
    }
}

