/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.filtering;

import java.util.Collection;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.similarity.filtering.LabelNodeFilter;
import org.neo4j.gds.similarity.filtering.NodeFilter;
import org.neo4j.gds.similarity.filtering.NodeFilterSpec;
import org.neo4j.gds.utils.StringFormatting;

public class LabelNodeFilterSpec
implements NodeFilterSpec {
    private final String labelString;

    LabelNodeFilterSpec(String labelString) {
        this.labelString = labelString;
    }

    @Override
    public NodeFilter toNodeFilter(IdMap idMap) {
        return LabelNodeFilter.create(this.labelString, idMap);
    }

    @Override
    public String render() {
        return "NodeFilter[label=" + this.labelString + "]";
    }

    @Override
    public void validate(GraphStore graphStore, Collection<NodeLabel> selectedLabels, String nodeFilterType) throws IllegalArgumentException {
        boolean nodeLabelIsMissing;
        boolean bl = nodeLabelIsMissing = !graphStore.nodeLabels().contains(NodeLabel.of((String)this.labelString));
        if (nodeLabelIsMissing) {
            String errorMessage = StringFormatting.formatWithLocale((String)"Invalid configuration value '%s', the node label `%s` is missing from the graph.", (Object[])new Object[]{nodeFilterType, this.labelString});
            throw new IllegalArgumentException(errorMessage);
        }
    }
}

