/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.filtering;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.neo4j.gds.similarity.filtering.LabelNodeFilterSpec;
import org.neo4j.gds.similarity.filtering.NodeFilterSpec;
import org.neo4j.gds.similarity.filtering.NodeIdNodeFilterSpec;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.graphdb.Node;

public final class NodeFilterSpecFactory {
    private NodeFilterSpecFactory() {
    }

    public static NodeFilterSpec create(Object input) {
        if (input instanceof NodeFilterSpec) {
            return (NodeFilterSpec)input;
        }
        if (input instanceof String) {
            return new LabelNodeFilterSpec((String)input);
        }
        Set<Long> nodeIds = null;
        if (input instanceof List) {
            nodeIds = NodeFilterSpecFactory.parseFromList((List)input);
        }
        if (input instanceof Long) {
            nodeIds = NodeFilterSpecFactory.parseFromLong((Long)input);
        }
        if (input instanceof Node) {
            nodeIds = NodeFilterSpecFactory.parseFromNode((Node)input);
        }
        if (nodeIds == null) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Invalid scalar type. Expected Long or Node but found: %s", (Object[])new Object[]{input.getClass().getSimpleName()}));
        }
        if (nodeIds.isEmpty()) {
            return NodeFilterSpec.noOp;
        }
        return new NodeIdNodeFilterSpec(nodeIds);
    }

    private static Set<Long> parseFromLong(Long input) {
        HashSet<Long> nodeIds = new HashSet<Long>();
        nodeIds.add(input);
        return nodeIds;
    }

    private static Set<Long> parseFromNode(Node input) {
        HashSet<Long> nodeIds = new HashSet<Long>();
        nodeIds.add(input.getId());
        return nodeIds;
    }

    private static Set<Long> parseFromList(List input) {
        HashSet<Long> nodeIds = new HashSet<Long>();
        ArrayList badTypes = new ArrayList();
        input.forEach(o -> {
            if (o instanceof Long) {
                nodeIds.add((Long)o);
            } else if (o instanceof Node) {
                nodeIds.add(((Node)o).getId());
            } else {
                badTypes.add(o.getClass().getSimpleName());
            }
        });
        if (badTypes.isEmpty()) {
            return nodeIds;
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Invalid types in list. Expected Longs or Nodes but found %s", (Object[])new Object[]{badTypes}));
    }

    public static String render(NodeFilterSpec spec) {
        return spec.render();
    }
}

