/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.filtering;

import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.similarity.filtering.NodeFilter;

public final class NodeIdNodeFilter
implements NodeFilter {
    private final Set<Long> nodeIds;

    public static NodeIdNodeFilter create(Set<Long> externalNodeIds, IdMap idMap) {
        Set<Long> mappedNodeIds = externalNodeIds.stream().map(arg_0 -> ((IdMap)idMap).toMappedNodeId(arg_0)).collect(Collectors.toSet());
        return new NodeIdNodeFilter(mappedNodeIds);
    }

    private NodeIdNodeFilter(Set<Long> nodeIds) {
        this.nodeIds = nodeIds;
    }

    @Override
    public boolean test(long nodeId) {
        return this.nodeIds.contains(nodeId);
    }
}

