/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.filtering;

import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.similarity.filtering.NodeFilter;
import org.neo4j.gds.similarity.filtering.NodeFilterSpec;
import org.neo4j.gds.similarity.filtering.NodeIdNodeFilter;
import org.neo4j.gds.utils.StringFormatting;

public class NodeIdNodeFilterSpec
implements NodeFilterSpec {
    private final Set<Long> nodeIds;

    NodeIdNodeFilterSpec(Set<Long> nodeIds) {
        this.nodeIds = nodeIds;
    }

    @Override
    public NodeFilter toNodeFilter(IdMap idMap) {
        return NodeIdNodeFilter.create(this.nodeIds, idMap);
    }

    @Override
    public String render() {
        return "NodeFilter" + this.nodeIds.toString();
    }

    @Override
    public void validate(GraphStore graphStore, Collection<NodeLabel> selectedLabels, String nodeFilterType) throws IllegalArgumentException {
        IdMap existingNodeIds = graphStore.nodes();
        String missingNodes = this.nodeIds.stream().filter(Predicate.not(arg_0 -> ((IdMap)existingNodeIds).contains(arg_0))).map(String::valueOf).collect(Collectors.joining(","));
        if (!missingNodes.isBlank()) {
            String errorMessage = StringFormatting.formatWithLocale((String)"Invalid configuration value `%s`, the following nodes are missing from the graph: [%s]", (Object[])new Object[]{nodeFilterType, String.join((CharSequence)",", missingNodes)});
            throw new IllegalArgumentException(errorMessage);
        }
    }
}

