/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.knn;

import java.util.SplittableRandom;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.similarity.knn.KnnSampler;
import org.neo4j.gds.similarity.knn.NeighborFilter;
import org.neo4j.gds.similarity.knn.NeighborList;
import org.neo4j.gds.similarity.knn.NeighbourConsumers;
import org.neo4j.gds.similarity.knn.SimilarityFunction;

final class GenerateRandomNeighbors
implements Runnable {
    private final KnnSampler sampler;
    private final SplittableRandom random;
    private final SimilarityFunction similarityFunction;
    private final NeighborFilter neighborFilter;
    private final HugeObjectArray<NeighborList> neighbors;
    private final int boundedK;
    private final ProgressTracker progressTracker;
    private final Partition partition;
    private final NeighbourConsumers neighbourConsumers;
    private long neighborsFound;

    GenerateRandomNeighbors(KnnSampler sampler, SplittableRandom random, SimilarityFunction similarityFunction, NeighborFilter neighborFilter, HugeObjectArray<NeighborList> neighbors, int boundedK, Partition partition, ProgressTracker progressTracker, NeighbourConsumers neighbourConsumers) {
        this.sampler = sampler;
        this.random = random;
        this.similarityFunction = similarityFunction;
        this.neighborFilter = neighborFilter;
        this.neighbors = neighbors;
        this.boundedK = boundedK;
        this.progressTracker = progressTracker;
        this.partition = partition;
        this.neighborsFound = 0L;
        this.neighbourConsumers = neighbourConsumers;
    }

    @Override
    public void run() {
        SplittableRandom rng = this.random;
        SimilarityFunction similarityFunction = this.similarityFunction;
        int boundedK = this.boundedK;
        NeighborFilter neighborFilter = this.neighborFilter;
        this.partition.consume(nodeId -> {
            long[] chosen = this.sampler.sample(nodeId, neighborFilter.lowerBoundOfPotentialNeighbours(nodeId), boundedK, l -> neighborFilter.excludeNodePair(nodeId, l));
            NeighborList neighbors = new NeighborList(boundedK, this.neighbourConsumers.get(nodeId));
            for (long candidate : chosen) {
                double similarity = similarityFunction.computeSimilarity(nodeId, candidate);
                neighbors.add(candidate, similarity, rng, 0.0);
            }
            assert ((long)neighbors.size() >= Math.min(neighborFilter.lowerBoundOfPotentialNeighbours(nodeId), (long)boundedK));
            this.neighbors.set(nodeId, (Object)neighbors);
            this.neighborsFound += (long)neighbors.size();
        });
        this.progressTracker.logProgress(this.partition.nodeCount());
    }

    long neighborsFound() {
        return this.neighborsFound;
    }
}

