/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.knn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.IterationsConfig;
import org.neo4j.gds.config.JobIdConfig;
import org.neo4j.gds.config.RandomSeedConfig;
import org.neo4j.gds.config.WriteConfig;
import org.neo4j.gds.config.WritePropertyConfig;
import org.neo4j.gds.config.WriteRelationshipConfig;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.similarity.knn.KnnBaseConfig;
import org.neo4j.gds.similarity.knn.KnnNodePropertySpec;
import org.neo4j.gds.similarity.knn.KnnSampler;
import org.neo4j.gds.similarity.knn.KnnWriteConfig;

@Generated(from="KnnWriteConfig", generator="Immutables")
public final class ImmutableKnnWriteConfig
implements KnnWriteConfig {
    private final String usernameOverride;
    private final boolean sudo;
    private final boolean logProgress;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final JobId jobId;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    private final Long randomSeed;
    private final List<KnnNodePropertySpec> nodeProperties;
    private final int topK;
    private final double sampleRate;
    private final double perturbationRate;
    private final double deltaThreshold;
    private final double similarityCutoff;
    private final int maxIterations;
    private final int minBatchSize;
    private final int randomJoins;
    private final KnnSampler.SamplerType initialSampler;
    private final int writeConcurrency;
    private final String writeProperty;
    private final String writeRelationshipType;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableKnnWriteConfig(int concurrency, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<Long> randomSeed, Iterable<? extends KnnNodePropertySpec> nodeProperties, int topK, double sampleRate, double perturbationRate, double deltaThreshold, double similarityCutoff, int maxIterations, int minBatchSize, int randomJoins, KnnSampler.SamplerType initialSampler, int writeConcurrency, String writeProperty, String writeRelationshipType) {
        this.initShim.concurrency(concurrency);
        this.initShim.relationshipTypes(ImmutableKnnWriteConfig.createUnmodifiableList(false, ImmutableKnnWriteConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableKnnWriteConfig.createUnmodifiableList(false, ImmutableKnnWriteConfig.createSafeList(nodeLabels, true, false)));
        this.randomSeed = randomSeed.orElse(null);
        this.nodeProperties = ImmutableKnnWriteConfig.createUnmodifiableList(false, ImmutableKnnWriteConfig.createSafeList(nodeProperties, true, false));
        this.initShim.topK(topK);
        this.initShim.sampleRate(sampleRate);
        this.initShim.perturbationRate(perturbationRate);
        this.initShim.deltaThreshold(deltaThreshold);
        this.initShim.similarityCutoff(similarityCutoff);
        this.initShim.maxIterations(maxIterations);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.randomJoins(randomJoins);
        this.initShim.initialSampler(Objects.requireNonNull(initialSampler, "initialSampler"));
        this.initShim.writeConcurrency(writeConcurrency);
        this.writeProperty = Objects.requireNonNull(writeProperty, "writeProperty");
        this.writeRelationshipType = Objects.requireNonNull(writeRelationshipType, "writeRelationshipType");
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.topK = this.initShim.topK();
        this.sampleRate = this.initShim.sampleRate();
        this.perturbationRate = this.initShim.perturbationRate();
        this.deltaThreshold = this.initShim.deltaThreshold();
        this.similarityCutoff = this.initShim.similarityCutoff();
        this.maxIterations = this.initShim.maxIterations();
        this.minBatchSize = this.initShim.minBatchSize();
        this.randomJoins = this.initShim.randomJoins();
        this.initialSampler = this.initShim.initialSampler();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private ImmutableKnnWriteConfig(int concurrency, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Long randomSeed, Iterable<? extends KnnNodePropertySpec> nodeProperties, int topK, double sampleRate, double perturbationRate, double deltaThreshold, double similarityCutoff, int maxIterations, int minBatchSize, int randomJoins, KnnSampler.SamplerType initialSampler, int writeConcurrency, String writeProperty, String writeRelationshipType) {
        this.initShim.concurrency(concurrency);
        this.initShim.relationshipTypes(ImmutableKnnWriteConfig.createUnmodifiableList(false, ImmutableKnnWriteConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableKnnWriteConfig.createUnmodifiableList(false, ImmutableKnnWriteConfig.createSafeList(nodeLabels, true, false)));
        this.randomSeed = randomSeed;
        this.nodeProperties = ImmutableKnnWriteConfig.createUnmodifiableList(false, ImmutableKnnWriteConfig.createSafeList(nodeProperties, true, false));
        this.initShim.topK(topK);
        this.initShim.sampleRate(sampleRate);
        this.initShim.perturbationRate(perturbationRate);
        this.initShim.deltaThreshold(deltaThreshold);
        this.initShim.similarityCutoff(similarityCutoff);
        this.initShim.maxIterations(maxIterations);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.randomJoins(randomJoins);
        this.initShim.initialSampler(Objects.requireNonNull(initialSampler, "initialSampler"));
        this.initShim.writeConcurrency(writeConcurrency);
        this.writeProperty = Objects.requireNonNull(writeProperty, "writeProperty");
        this.writeRelationshipType = Objects.requireNonNull(writeRelationshipType, "writeRelationshipType");
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.topK = this.initShim.topK();
        this.sampleRate = this.initShim.sampleRate();
        this.perturbationRate = this.initShim.perturbationRate();
        this.deltaThreshold = this.initShim.deltaThreshold();
        this.similarityCutoff = this.initShim.similarityCutoff();
        this.maxIterations = this.initShim.maxIterations();
        this.minBatchSize = this.initShim.minBatchSize();
        this.randomJoins = this.initShim.randomJoins();
        this.initialSampler = this.initShim.initialSampler();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private ImmutableKnnWriteConfig(Builder builder) {
        this.usernameOverride = builder.usernameOverride;
        this.randomSeed = builder.randomSeed;
        this.nodeProperties = builder.nodeProperties == null ? Collections.emptyList() : ImmutableKnnWriteConfig.createUnmodifiableList(true, builder.nodeProperties);
        this.writeProperty = builder.writeProperty;
        this.writeRelationshipType = builder.writeRelationshipType;
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.logProgressIsSet()) {
            this.initShim.logProgress(builder.logProgress);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.jobId != null) {
            this.initShim.jobId(builder.jobId);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableKnnWriteConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableKnnWriteConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.topKIsSet()) {
            this.initShim.topK(builder.topK);
        }
        if (builder.sampleRateIsSet()) {
            this.initShim.sampleRate(builder.sampleRate);
        }
        if (builder.perturbationRateIsSet()) {
            this.initShim.perturbationRate(builder.perturbationRate);
        }
        if (builder.deltaThresholdIsSet()) {
            this.initShim.deltaThreshold(builder.deltaThreshold);
        }
        if (builder.similarityCutoffIsSet()) {
            this.initShim.similarityCutoff(builder.similarityCutoff);
        }
        if (builder.maxIterationsIsSet()) {
            this.initShim.maxIterations(builder.maxIterations);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.randomJoinsIsSet()) {
            this.initShim.randomJoins(builder.randomJoins);
        }
        if (builder.initialSampler != null) {
            this.initShim.initialSampler(builder.initialSampler);
        }
        if (builder.writeConcurrencyIsSet()) {
            this.initShim.writeConcurrency(builder.writeConcurrency);
        }
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.topK = this.initShim.topK();
        this.sampleRate = this.initShim.sampleRate();
        this.perturbationRate = this.initShim.perturbationRate();
        this.deltaThreshold = this.initShim.deltaThreshold();
        this.similarityCutoff = this.initShim.similarityCutoff();
        this.maxIterations = this.initShim.maxIterations();
        this.minBatchSize = this.initShim.minBatchSize();
        this.randomJoins = this.initShim.randomJoins();
        this.initialSampler = this.initShim.initialSampler();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private ImmutableKnnWriteConfig(String usernameOverride, boolean sudo, boolean logProgress, Collection<String> configKeys, int concurrency, JobId jobId, List<String> relationshipTypes, List<String> nodeLabels, Long randomSeed, List<KnnNodePropertySpec> nodeProperties, int topK, double sampleRate, double perturbationRate, double deltaThreshold, double similarityCutoff, int maxIterations, int minBatchSize, int randomJoins, KnnSampler.SamplerType initialSampler, int writeConcurrency, String writeProperty, String writeRelationshipType) {
        this.usernameOverride = usernameOverride;
        this.initShim.sudo(sudo);
        this.initShim.logProgress(logProgress);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.jobId(jobId);
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.randomSeed = randomSeed;
        this.nodeProperties = nodeProperties;
        this.initShim.topK(topK);
        this.initShim.sampleRate(sampleRate);
        this.initShim.perturbationRate(perturbationRate);
        this.initShim.deltaThreshold(deltaThreshold);
        this.initShim.similarityCutoff(similarityCutoff);
        this.initShim.maxIterations(maxIterations);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.randomJoins(randomJoins);
        this.initShim.initialSampler(initialSampler);
        this.initShim.writeConcurrency(writeConcurrency);
        this.writeProperty = writeProperty;
        this.writeRelationshipType = writeRelationshipType;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.topK = this.initShim.topK();
        this.sampleRate = this.initShim.sampleRate();
        this.perturbationRate = this.initShim.perturbationRate();
        this.deltaThreshold = this.initShim.deltaThreshold();
        this.similarityCutoff = this.initShim.similarityCutoff();
        this.maxIterations = this.initShim.maxIterations();
        this.minBatchSize = this.initShim.minBatchSize();
        this.randomJoins = this.initShim.randomJoins();
        this.initialSampler = this.initShim.initialSampler();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private boolean sudoInitialize() {
        return KnnWriteConfig.super.sudo();
    }

    private boolean logProgressInitialize() {
        return KnnWriteConfig.super.logProgress();
    }

    private Collection<String> configKeysInitialize() {
        return KnnWriteConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return KnnWriteConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return KnnWriteConfig.super.concurrency();
    }

    private JobId jobIdInitialize() {
        return KnnWriteConfig.super.jobId();
    }

    private List<String> relationshipTypesInitialize() {
        return KnnWriteConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return KnnWriteConfig.super.nodeLabels();
    }

    private int topKInitialize() {
        return KnnWriteConfig.super.topK();
    }

    private double sampleRateInitialize() {
        return KnnWriteConfig.super.sampleRate();
    }

    private double perturbationRateInitialize() {
        return KnnWriteConfig.super.perturbationRate();
    }

    private double deltaThresholdInitialize() {
        return KnnWriteConfig.super.deltaThreshold();
    }

    private double similarityCutoffInitialize() {
        return KnnWriteConfig.super.similarityCutoff();
    }

    private int maxIterationsInitialize() {
        return KnnWriteConfig.super.maxIterations();
    }

    private int minBatchSizeInitialize() {
        return KnnWriteConfig.super.minBatchSize();
    }

    private int randomJoinsInitialize() {
        return KnnWriteConfig.super.randomJoins();
    }

    private KnnSampler.SamplerType initialSamplerInitialize() {
        return KnnWriteConfig.super.initialSampler();
    }

    private int writeConcurrencyInitialize() {
        return KnnWriteConfig.super.writeConcurrency();
    }

    public Optional<String> usernameOverride() {
        return Optional.ofNullable(this.usernameOverride);
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public boolean logProgress() {
        InitShim shim = this.initShim;
        return shim != null ? shim.logProgress() : this.logProgress;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public JobId jobId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.jobId() : this.jobId;
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    public Optional<Long> randomSeed() {
        return Optional.ofNullable(this.randomSeed);
    }

    @Override
    public List<KnnNodePropertySpec> nodeProperties() {
        return this.nodeProperties;
    }

    @Override
    public int topK() {
        InitShim shim = this.initShim;
        return shim != null ? shim.topK() : this.topK;
    }

    @Override
    public double sampleRate() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sampleRate() : this.sampleRate;
    }

    @Override
    public double perturbationRate() {
        InitShim shim = this.initShim;
        return shim != null ? shim.perturbationRate() : this.perturbationRate;
    }

    @Override
    public double deltaThreshold() {
        InitShim shim = this.initShim;
        return shim != null ? shim.deltaThreshold() : this.deltaThreshold;
    }

    @Override
    public double similarityCutoff() {
        InitShim shim = this.initShim;
        return shim != null ? shim.similarityCutoff() : this.similarityCutoff;
    }

    @Override
    public int maxIterations() {
        InitShim shim = this.initShim;
        return shim != null ? shim.maxIterations() : this.maxIterations;
    }

    @Override
    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    @Override
    public int randomJoins() {
        InitShim shim = this.initShim;
        return shim != null ? shim.randomJoins() : this.randomJoins;
    }

    @Override
    public KnnSampler.SamplerType initialSampler() {
        InitShim shim = this.initShim;
        return shim != null ? shim.initialSampler() : this.initialSampler;
    }

    public int writeConcurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.writeConcurrency() : this.writeConcurrency;
    }

    public String writeProperty() {
        return this.writeProperty;
    }

    public String writeRelationshipType() {
        return this.writeRelationshipType;
    }

    public final ImmutableKnnWriteConfig withUsernameOverride(String value) {
        String newValue = value;
        if (Objects.equals(this.usernameOverride, newValue)) {
            return this;
        }
        return ImmutableKnnWriteConfig.validate(new ImmutableKnnWriteConfig(newValue, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.jobId, this.relationshipTypes, this.nodeLabels, this.randomSeed, this.nodeProperties, this.topK, this.sampleRate, this.perturbationRate, this.deltaThreshold, this.similarityCutoff, this.maxIterations, this.minBatchSize, this.randomJoins, this.initialSampler, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableKnnWriteConfig withUsernameOverride(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableKnnWriteConfig.validate(new ImmutableKnnWriteConfig(value, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.jobId, this.relationshipTypes, this.nodeLabels, this.randomSeed, this.nodeProperties, this.topK, this.sampleRate, this.perturbationRate, this.deltaThreshold, this.similarityCutoff, this.maxIterations, this.minBatchSize, this.randomJoins, this.initialSampler, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableKnnWriteConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableKnnWriteConfig.validate(new ImmutableKnnWriteConfig(this.usernameOverride, value, this.logProgress, this.configKeys, this.concurrency, this.jobId, this.relationshipTypes, this.nodeLabels, this.randomSeed, this.nodeProperties, this.topK, this.sampleRate, this.perturbationRate, this.deltaThreshold, this.similarityCutoff, this.maxIterations, this.minBatchSize, this.randomJoins, this.initialSampler, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableKnnWriteConfig withLogProgress(boolean value) {
        if (this.logProgress == value) {
            return this;
        }
        return ImmutableKnnWriteConfig.validate(new ImmutableKnnWriteConfig(this.usernameOverride, this.sudo, value, this.configKeys, this.concurrency, this.jobId, this.relationshipTypes, this.nodeLabels, this.randomSeed, this.nodeProperties, this.topK, this.sampleRate, this.perturbationRate, this.deltaThreshold, this.similarityCutoff, this.maxIterations, this.minBatchSize, this.randomJoins, this.initialSampler, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableKnnWriteConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableKnnWriteConfig.validate(new ImmutableKnnWriteConfig(this.usernameOverride, this.sudo, this.logProgress, newValue, this.concurrency, this.jobId, this.relationshipTypes, this.nodeLabels, this.randomSeed, this.nodeProperties, this.topK, this.sampleRate, this.perturbationRate, this.deltaThreshold, this.similarityCutoff, this.maxIterations, this.minBatchSize, this.randomJoins, this.initialSampler, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableKnnWriteConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableKnnWriteConfig.validate(new ImmutableKnnWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, value, this.jobId, this.relationshipTypes, this.nodeLabels, this.randomSeed, this.nodeProperties, this.topK, this.sampleRate, this.perturbationRate, this.deltaThreshold, this.similarityCutoff, this.maxIterations, this.minBatchSize, this.randomJoins, this.initialSampler, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableKnnWriteConfig withJobId(JobId value) {
        if (this.jobId == value) {
            return this;
        }
        JobId newValue = Objects.requireNonNull(value, "jobId");
        return ImmutableKnnWriteConfig.validate(new ImmutableKnnWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, newValue, this.relationshipTypes, this.nodeLabels, this.randomSeed, this.nodeProperties, this.topK, this.sampleRate, this.perturbationRate, this.deltaThreshold, this.similarityCutoff, this.maxIterations, this.minBatchSize, this.randomJoins, this.initialSampler, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableKnnWriteConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableKnnWriteConfig.createUnmodifiableList(false, ImmutableKnnWriteConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableKnnWriteConfig.validate(new ImmutableKnnWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.jobId, newValue, this.nodeLabels, this.randomSeed, this.nodeProperties, this.topK, this.sampleRate, this.perturbationRate, this.deltaThreshold, this.similarityCutoff, this.maxIterations, this.minBatchSize, this.randomJoins, this.initialSampler, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableKnnWriteConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableKnnWriteConfig.createUnmodifiableList(false, ImmutableKnnWriteConfig.createSafeList(elements, true, false));
        return ImmutableKnnWriteConfig.validate(new ImmutableKnnWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.jobId, newValue, this.nodeLabels, this.randomSeed, this.nodeProperties, this.topK, this.sampleRate, this.perturbationRate, this.deltaThreshold, this.similarityCutoff, this.maxIterations, this.minBatchSize, this.randomJoins, this.initialSampler, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableKnnWriteConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableKnnWriteConfig.createUnmodifiableList(false, ImmutableKnnWriteConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableKnnWriteConfig.validate(new ImmutableKnnWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.jobId, this.relationshipTypes, newValue, this.randomSeed, this.nodeProperties, this.topK, this.sampleRate, this.perturbationRate, this.deltaThreshold, this.similarityCutoff, this.maxIterations, this.minBatchSize, this.randomJoins, this.initialSampler, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableKnnWriteConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableKnnWriteConfig.createUnmodifiableList(false, ImmutableKnnWriteConfig.createSafeList(elements, true, false));
        return ImmutableKnnWriteConfig.validate(new ImmutableKnnWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.jobId, this.relationshipTypes, newValue, this.randomSeed, this.nodeProperties, this.topK, this.sampleRate, this.perturbationRate, this.deltaThreshold, this.similarityCutoff, this.maxIterations, this.minBatchSize, this.randomJoins, this.initialSampler, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableKnnWriteConfig withRandomSeed(Long value) {
        Long newValue = value;
        if (Objects.equals(this.randomSeed, newValue)) {
            return this;
        }
        return ImmutableKnnWriteConfig.validate(new ImmutableKnnWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.jobId, this.relationshipTypes, this.nodeLabels, newValue, this.nodeProperties, this.topK, this.sampleRate, this.perturbationRate, this.deltaThreshold, this.similarityCutoff, this.maxIterations, this.minBatchSize, this.randomJoins, this.initialSampler, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableKnnWriteConfig withRandomSeed(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.randomSeed, value)) {
            return this;
        }
        return ImmutableKnnWriteConfig.validate(new ImmutableKnnWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.jobId, this.relationshipTypes, this.nodeLabels, value, this.nodeProperties, this.topK, this.sampleRate, this.perturbationRate, this.deltaThreshold, this.similarityCutoff, this.maxIterations, this.minBatchSize, this.randomJoins, this.initialSampler, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableKnnWriteConfig withNodeProperties(KnnNodePropertySpec ... elements) {
        List<KnnNodePropertySpec> newValue = ImmutableKnnWriteConfig.createUnmodifiableList(false, ImmutableKnnWriteConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableKnnWriteConfig.validate(new ImmutableKnnWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.jobId, this.relationshipTypes, this.nodeLabels, this.randomSeed, newValue, this.topK, this.sampleRate, this.perturbationRate, this.deltaThreshold, this.similarityCutoff, this.maxIterations, this.minBatchSize, this.randomJoins, this.initialSampler, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableKnnWriteConfig withNodeProperties(Iterable<? extends KnnNodePropertySpec> elements) {
        if (this.nodeProperties == elements) {
            return this;
        }
        List<KnnNodePropertySpec> newValue = ImmutableKnnWriteConfig.createUnmodifiableList(false, ImmutableKnnWriteConfig.createSafeList(elements, true, false));
        return ImmutableKnnWriteConfig.validate(new ImmutableKnnWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.jobId, this.relationshipTypes, this.nodeLabels, this.randomSeed, newValue, this.topK, this.sampleRate, this.perturbationRate, this.deltaThreshold, this.similarityCutoff, this.maxIterations, this.minBatchSize, this.randomJoins, this.initialSampler, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableKnnWriteConfig withTopK(int value) {
        if (this.topK == value) {
            return this;
        }
        return ImmutableKnnWriteConfig.validate(new ImmutableKnnWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.jobId, this.relationshipTypes, this.nodeLabels, this.randomSeed, this.nodeProperties, value, this.sampleRate, this.perturbationRate, this.deltaThreshold, this.similarityCutoff, this.maxIterations, this.minBatchSize, this.randomJoins, this.initialSampler, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableKnnWriteConfig withSampleRate(double value) {
        if (Double.doubleToLongBits(this.sampleRate) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableKnnWriteConfig.validate(new ImmutableKnnWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.jobId, this.relationshipTypes, this.nodeLabels, this.randomSeed, this.nodeProperties, this.topK, value, this.perturbationRate, this.deltaThreshold, this.similarityCutoff, this.maxIterations, this.minBatchSize, this.randomJoins, this.initialSampler, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableKnnWriteConfig withPerturbationRate(double value) {
        if (Double.doubleToLongBits(this.perturbationRate) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableKnnWriteConfig.validate(new ImmutableKnnWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.jobId, this.relationshipTypes, this.nodeLabels, this.randomSeed, this.nodeProperties, this.topK, this.sampleRate, value, this.deltaThreshold, this.similarityCutoff, this.maxIterations, this.minBatchSize, this.randomJoins, this.initialSampler, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableKnnWriteConfig withDeltaThreshold(double value) {
        if (Double.doubleToLongBits(this.deltaThreshold) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableKnnWriteConfig.validate(new ImmutableKnnWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.jobId, this.relationshipTypes, this.nodeLabels, this.randomSeed, this.nodeProperties, this.topK, this.sampleRate, this.perturbationRate, value, this.similarityCutoff, this.maxIterations, this.minBatchSize, this.randomJoins, this.initialSampler, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableKnnWriteConfig withSimilarityCutoff(double value) {
        if (Double.doubleToLongBits(this.similarityCutoff) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableKnnWriteConfig.validate(new ImmutableKnnWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.jobId, this.relationshipTypes, this.nodeLabels, this.randomSeed, this.nodeProperties, this.topK, this.sampleRate, this.perturbationRate, this.deltaThreshold, value, this.maxIterations, this.minBatchSize, this.randomJoins, this.initialSampler, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableKnnWriteConfig withMaxIterations(int value) {
        if (this.maxIterations == value) {
            return this;
        }
        return ImmutableKnnWriteConfig.validate(new ImmutableKnnWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.jobId, this.relationshipTypes, this.nodeLabels, this.randomSeed, this.nodeProperties, this.topK, this.sampleRate, this.perturbationRate, this.deltaThreshold, this.similarityCutoff, value, this.minBatchSize, this.randomJoins, this.initialSampler, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableKnnWriteConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutableKnnWriteConfig.validate(new ImmutableKnnWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.jobId, this.relationshipTypes, this.nodeLabels, this.randomSeed, this.nodeProperties, this.topK, this.sampleRate, this.perturbationRate, this.deltaThreshold, this.similarityCutoff, this.maxIterations, value, this.randomJoins, this.initialSampler, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableKnnWriteConfig withRandomJoins(int value) {
        if (this.randomJoins == value) {
            return this;
        }
        return ImmutableKnnWriteConfig.validate(new ImmutableKnnWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.jobId, this.relationshipTypes, this.nodeLabels, this.randomSeed, this.nodeProperties, this.topK, this.sampleRate, this.perturbationRate, this.deltaThreshold, this.similarityCutoff, this.maxIterations, this.minBatchSize, value, this.initialSampler, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableKnnWriteConfig withInitialSampler(KnnSampler.SamplerType value) {
        if (this.initialSampler == value) {
            return this;
        }
        KnnSampler.SamplerType newValue = Objects.requireNonNull(value, "initialSampler");
        if (this.initialSampler.equals((Object)newValue)) {
            return this;
        }
        return ImmutableKnnWriteConfig.validate(new ImmutableKnnWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.jobId, this.relationshipTypes, this.nodeLabels, this.randomSeed, this.nodeProperties, this.topK, this.sampleRate, this.perturbationRate, this.deltaThreshold, this.similarityCutoff, this.maxIterations, this.minBatchSize, this.randomJoins, newValue, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableKnnWriteConfig withWriteConcurrency(int value) {
        if (this.writeConcurrency == value) {
            return this;
        }
        return ImmutableKnnWriteConfig.validate(new ImmutableKnnWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.jobId, this.relationshipTypes, this.nodeLabels, this.randomSeed, this.nodeProperties, this.topK, this.sampleRate, this.perturbationRate, this.deltaThreshold, this.similarityCutoff, this.maxIterations, this.minBatchSize, this.randomJoins, this.initialSampler, value, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableKnnWriteConfig withWriteProperty(String value) {
        String newValue = Objects.requireNonNull(value, "writeProperty");
        if (this.writeProperty.equals(newValue)) {
            return this;
        }
        return ImmutableKnnWriteConfig.validate(new ImmutableKnnWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.jobId, this.relationshipTypes, this.nodeLabels, this.randomSeed, this.nodeProperties, this.topK, this.sampleRate, this.perturbationRate, this.deltaThreshold, this.similarityCutoff, this.maxIterations, this.minBatchSize, this.randomJoins, this.initialSampler, this.writeConcurrency, newValue, this.writeRelationshipType));
    }

    public final ImmutableKnnWriteConfig withWriteRelationshipType(String value) {
        String newValue = Objects.requireNonNull(value, "writeRelationshipType");
        if (this.writeRelationshipType.equals(newValue)) {
            return this;
        }
        return ImmutableKnnWriteConfig.validate(new ImmutableKnnWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.jobId, this.relationshipTypes, this.nodeLabels, this.randomSeed, this.nodeProperties, this.topK, this.sampleRate, this.perturbationRate, this.deltaThreshold, this.similarityCutoff, this.maxIterations, this.minBatchSize, this.randomJoins, this.initialSampler, this.writeConcurrency, this.writeProperty, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKnnWriteConfig && this.equalTo((ImmutableKnnWriteConfig)another);
    }

    private boolean equalTo(ImmutableKnnWriteConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.logProgress == another.logProgress && this.concurrency == another.concurrency && this.jobId.equals((Object)another.jobId) && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && Objects.equals(this.randomSeed, another.randomSeed) && this.nodeProperties.equals(another.nodeProperties) && this.topK == another.topK && Double.doubleToLongBits(this.sampleRate) == Double.doubleToLongBits(another.sampleRate) && Double.doubleToLongBits(this.perturbationRate) == Double.doubleToLongBits(another.perturbationRate) && Double.doubleToLongBits(this.deltaThreshold) == Double.doubleToLongBits(another.deltaThreshold) && Double.doubleToLongBits(this.similarityCutoff) == Double.doubleToLongBits(another.similarityCutoff) && this.maxIterations == another.maxIterations && this.minBatchSize == another.minBatchSize && this.randomJoins == another.randomJoins && this.initialSampler.equals((Object)another.initialSampler) && this.writeConcurrency == another.writeConcurrency && this.writeProperty.equals(another.writeProperty) && this.writeRelationshipType.equals(another.writeRelationshipType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + Boolean.hashCode(this.logProgress);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.jobId.hashCode();
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + Objects.hashCode(this.randomSeed);
        h += (h << 5) + this.nodeProperties.hashCode();
        h += (h << 5) + this.topK;
        h += (h << 5) + Double.hashCode(this.sampleRate);
        h += (h << 5) + Double.hashCode(this.perturbationRate);
        h += (h << 5) + Double.hashCode(this.deltaThreshold);
        h += (h << 5) + Double.hashCode(this.similarityCutoff);
        h += (h << 5) + this.maxIterations;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + this.randomJoins;
        h += (h << 5) + this.initialSampler.hashCode();
        h += (h << 5) + this.writeConcurrency;
        h += (h << 5) + this.writeProperty.hashCode();
        h += (h << 5) + this.writeRelationshipType.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("KnnWriteConfig{");
        if (this.usernameOverride != null) {
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        if (builder.length() > 15) {
            builder.append(", ");
        }
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("logProgress=").append(this.logProgress);
        builder.append(", ");
        builder.append("concurrency=").append(this.concurrency);
        builder.append(", ");
        builder.append("jobId=").append(this.jobId);
        builder.append(", ");
        builder.append("relationshipTypes=").append(this.relationshipTypes);
        builder.append(", ");
        builder.append("nodeLabels=").append(this.nodeLabels);
        if (this.randomSeed != null) {
            builder.append(", ");
            builder.append("randomSeed=").append(this.randomSeed);
        }
        builder.append(", ");
        builder.append("nodeProperties=").append(this.nodeProperties);
        builder.append(", ");
        builder.append("topK=").append(this.topK);
        builder.append(", ");
        builder.append("sampleRate=").append(this.sampleRate);
        builder.append(", ");
        builder.append("perturbationRate=").append(this.perturbationRate);
        builder.append(", ");
        builder.append("deltaThreshold=").append(this.deltaThreshold);
        builder.append(", ");
        builder.append("similarityCutoff=").append(this.similarityCutoff);
        builder.append(", ");
        builder.append("maxIterations=").append(this.maxIterations);
        builder.append(", ");
        builder.append("minBatchSize=").append(this.minBatchSize);
        builder.append(", ");
        builder.append("randomJoins=").append(this.randomJoins);
        builder.append(", ");
        builder.append("initialSampler=").append((Object)this.initialSampler);
        builder.append(", ");
        builder.append("writeConcurrency=").append(this.writeConcurrency);
        builder.append(", ");
        builder.append("writeProperty=").append(this.writeProperty);
        builder.append(", ");
        builder.append("writeRelationshipType=").append(this.writeRelationshipType);
        return builder.append("}").toString();
    }

    public static KnnWriteConfig of(int concurrency, List<String> relationshipTypes, List<String> nodeLabels, Optional<Long> randomSeed, List<KnnNodePropertySpec> nodeProperties, int topK, double sampleRate, double perturbationRate, double deltaThreshold, double similarityCutoff, int maxIterations, int minBatchSize, int randomJoins, KnnSampler.SamplerType initialSampler, int writeConcurrency, String writeProperty, String writeRelationshipType) {
        return ImmutableKnnWriteConfig.of(concurrency, relationshipTypes, nodeLabels, randomSeed, nodeProperties, topK, sampleRate, perturbationRate, deltaThreshold, similarityCutoff, maxIterations, minBatchSize, randomJoins, initialSampler, writeConcurrency, writeProperty, writeRelationshipType);
    }

    public static KnnWriteConfig of(int concurrency, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<Long> randomSeed, Iterable<? extends KnnNodePropertySpec> nodeProperties, int topK, double sampleRate, double perturbationRate, double deltaThreshold, double similarityCutoff, int maxIterations, int minBatchSize, int randomJoins, KnnSampler.SamplerType initialSampler, int writeConcurrency, String writeProperty, String writeRelationshipType) {
        return ImmutableKnnWriteConfig.validate(new ImmutableKnnWriteConfig(concurrency, relationshipTypes, nodeLabels, randomSeed, nodeProperties, topK, sampleRate, perturbationRate, deltaThreshold, similarityCutoff, maxIterations, minBatchSize, randomJoins, initialSampler, writeConcurrency, writeProperty, writeRelationshipType));
    }

    public static KnnWriteConfig of(int concurrency, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Long randomSeed, Iterable<? extends KnnNodePropertySpec> nodeProperties, int topK, double sampleRate, double perturbationRate, double deltaThreshold, double similarityCutoff, int maxIterations, int minBatchSize, int randomJoins, KnnSampler.SamplerType initialSampler, int writeConcurrency, String writeProperty, String writeRelationshipType) {
        return ImmutableKnnWriteConfig.validate(new ImmutableKnnWriteConfig(concurrency, relationshipTypes, nodeLabels, randomSeed, nodeProperties, topK, sampleRate, perturbationRate, deltaThreshold, similarityCutoff, maxIterations, minBatchSize, randomJoins, initialSampler, writeConcurrency, writeProperty, writeRelationshipType));
    }

    private static ImmutableKnnWriteConfig validate(ImmutableKnnWriteConfig instance) {
        instance.validateWriteConcurrency();
        instance.validate();
        instance.validateConcurrency();
        return instance;
    }

    public static KnnWriteConfig copyOf(KnnWriteConfig instance) {
        if (instance instanceof ImmutableKnnWriteConfig) {
            return (ImmutableKnnWriteConfig)instance;
        }
        return ImmutableKnnWriteConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="KnnWriteConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_WRITE_PROPERTY = 1L;
        private static final long INIT_BIT_WRITE_RELATIONSHIP_TYPE = 2L;
        private static final long OPT_BIT_SUDO = 1L;
        private static final long OPT_BIT_LOG_PROGRESS = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 8L;
        private static final long OPT_BIT_NODE_LABELS = 16L;
        private static final long OPT_BIT_TOP_K = 32L;
        private static final long OPT_BIT_SAMPLE_RATE = 64L;
        private static final long OPT_BIT_PERTURBATION_RATE = 128L;
        private static final long OPT_BIT_DELTA_THRESHOLD = 256L;
        private static final long OPT_BIT_SIMILARITY_CUTOFF = 512L;
        private static final long OPT_BIT_MAX_ITERATIONS = 1024L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 2048L;
        private static final long OPT_BIT_RANDOM_JOINS = 4096L;
        private static final long OPT_BIT_WRITE_CONCURRENCY = 8192L;
        private long initBits = 3L;
        private long optBits;
        private String usernameOverride;
        private boolean sudo;
        private boolean logProgress;
        private Collection<String> configKeys;
        private int concurrency;
        private JobId jobId;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        private Long randomSeed;
        private List<KnnNodePropertySpec> nodeProperties = null;
        private int topK;
        private double sampleRate;
        private double perturbationRate;
        private double deltaThreshold;
        private double similarityCutoff;
        private int maxIterations;
        private int minBatchSize;
        private int randomJoins;
        private KnnSampler.SamplerType initialSampler;
        private int writeConcurrency;
        private String writeProperty;
        private String writeRelationshipType;

        private Builder() {
        }

        public final Builder from(WriteConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WritePropertyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(JobIdConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RandomSeedConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WriteRelationshipConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(KnnBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(IterationsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(KnnWriteConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional randomSeedOptional;
            Object instance;
            long bits = 0L;
            if (object instanceof WriteConfig) {
                instance = (WriteConfig)object;
                this.writeConcurrency(instance.writeConcurrency());
            }
            if (object instanceof WritePropertyConfig) {
                instance = (WritePropertyConfig)object;
                this.writeProperty(instance.writeProperty());
            }
            if (object instanceof JobIdConfig) {
                instance = (JobIdConfig)object;
                this.jobId(instance.jobId());
            }
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                if ((bits & 2L) == 0L) {
                    this.minBatchSize(instance.minBatchSize());
                    bits |= 2L;
                }
                this.concurrency(instance.concurrency());
            }
            if (object instanceof RandomSeedConfig && (randomSeedOptional = (instance = (RandomSeedConfig)object).randomSeed()).isPresent()) {
                this.randomSeed(randomSeedOptional);
            }
            if (object instanceof WriteRelationshipConfig) {
                instance = (WriteRelationshipConfig)object;
                this.writeRelationshipType(instance.writeRelationshipType());
            }
            if (object instanceof KnnBaseConfig) {
                instance = (KnnBaseConfig)object;
                this.topK(instance.topK());
                if ((bits & 2L) == 0L) {
                    this.minBatchSize(instance.minBatchSize());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.maxIterations(instance.maxIterations());
                    bits |= 1L;
                }
                this.randomJoins(instance.randomJoins());
                this.similarityCutoff(instance.similarityCutoff());
                this.perturbationRate(instance.perturbationRate());
                this.initialSampler(instance.initialSampler());
                this.sampleRate(instance.sampleRate());
                this.deltaThreshold(instance.deltaThreshold());
                this.addAllNodeProperties(instance.nodeProperties());
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                this.logProgress(instance.logProgress());
                this.sudo(instance.sudo());
                Optional usernameOverrideOptional = instance.usernameOverride();
                if (usernameOverrideOptional.isPresent()) {
                    this.usernameOverride(usernameOverrideOptional);
                }
                this.configKeys(instance.configKeys());
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                this.addAllRelationshipTypes(instance.relationshipTypes());
                this.addAllNodeLabels(instance.nodeLabels());
            }
            if (object instanceof IterationsConfig) {
                instance = (IterationsConfig)object;
                if ((bits & 1L) == 0L) {
                    this.maxIterations(instance.maxIterations());
                    bits |= 1L;
                }
            }
        }

        public final Builder usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            return this;
        }

        public final Builder usernameOverride(Optional<String> usernameOverride) {
            this.usernameOverride = usernameOverride.orElse(null);
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 1L;
            return this;
        }

        public final Builder logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder jobId(JobId jobId) {
            this.jobId = Objects.requireNonNull(jobId, "jobId");
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 8L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 8L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 8L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder randomSeed(Long randomSeed) {
            this.randomSeed = randomSeed;
            return this;
        }

        public final Builder randomSeed(Optional<Long> randomSeed) {
            this.randomSeed = randomSeed.orElse(null);
            return this;
        }

        public final Builder addNodeProperty(KnnNodePropertySpec element) {
            if (this.nodeProperties == null) {
                this.nodeProperties = new ArrayList<KnnNodePropertySpec>();
            }
            this.nodeProperties.add(Objects.requireNonNull(element, "nodeProperties element"));
            return this;
        }

        public final Builder addNodeProperties(KnnNodePropertySpec ... elements) {
            if (this.nodeProperties == null) {
                this.nodeProperties = new ArrayList<KnnNodePropertySpec>();
            }
            for (KnnNodePropertySpec element : elements) {
                this.nodeProperties.add(Objects.requireNonNull(element, "nodeProperties element"));
            }
            return this;
        }

        public final Builder nodeProperties(Iterable<? extends KnnNodePropertySpec> elements) {
            this.nodeProperties = new ArrayList<KnnNodePropertySpec>();
            return this.addAllNodeProperties(elements);
        }

        public final Builder addAllNodeProperties(Iterable<? extends KnnNodePropertySpec> elements) {
            Objects.requireNonNull(elements, "nodeProperties element");
            if (this.nodeProperties == null) {
                this.nodeProperties = new ArrayList<KnnNodePropertySpec>();
            }
            for (KnnNodePropertySpec knnNodePropertySpec : elements) {
                this.nodeProperties.add(Objects.requireNonNull(knnNodePropertySpec, "nodeProperties element"));
            }
            return this;
        }

        public final Builder topK(int topK) {
            this.topK = topK;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder sampleRate(double sampleRate) {
            this.sampleRate = sampleRate;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder perturbationRate(double perturbationRate) {
            this.perturbationRate = perturbationRate;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder deltaThreshold(double deltaThreshold) {
            this.deltaThreshold = deltaThreshold;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder similarityCutoff(double similarityCutoff) {
            this.similarityCutoff = similarityCutoff;
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder maxIterations(int maxIterations) {
            this.maxIterations = maxIterations;
            this.optBits |= 0x400L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 0x800L;
            return this;
        }

        public final Builder randomJoins(int randomJoins) {
            this.randomJoins = randomJoins;
            this.optBits |= 0x1000L;
            return this;
        }

        public final Builder initialSampler(KnnSampler.SamplerType initialSampler) {
            this.initialSampler = Objects.requireNonNull(initialSampler, "initialSampler");
            return this;
        }

        public final Builder writeConcurrency(int writeConcurrency) {
            this.writeConcurrency = writeConcurrency;
            this.optBits |= 0x2000L;
            return this;
        }

        public final Builder writeProperty(String writeProperty) {
            this.writeProperty = Objects.requireNonNull(writeProperty, "writeProperty");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder writeRelationshipType(String writeRelationshipType) {
            this.writeRelationshipType = Objects.requireNonNull(writeRelationshipType, "writeRelationshipType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.logProgress = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.jobId = null;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.randomSeed = null;
            if (this.nodeProperties != null) {
                this.nodeProperties.clear();
            }
            this.topK = 0;
            this.sampleRate = 0.0;
            this.perturbationRate = 0.0;
            this.deltaThreshold = 0.0;
            this.similarityCutoff = 0.0;
            this.maxIterations = 0;
            this.minBatchSize = 0;
            this.randomJoins = 0;
            this.initialSampler = null;
            this.writeConcurrency = 0;
            this.writeProperty = null;
            this.writeRelationshipType = null;
            return this;
        }

        public KnnWriteConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableKnnWriteConfig.validate(new ImmutableKnnWriteConfig(this));
        }

        private boolean sudoIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean logProgressIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean topKIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean sampleRateIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean perturbationRateIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean deltaThresholdIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean similarityCutoffIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean maxIterationsIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 0x800L) != 0L;
        }

        private boolean randomJoinsIsSet() {
            return (this.optBits & 0x1000L) != 0L;
        }

        private boolean writeConcurrencyIsSet() {
            return (this.optBits & 0x2000L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("writeProperty");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("writeRelationshipType");
            }
            return "Cannot build KnnWriteConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="KnnWriteConfig", generator="Immutables")
    private final class InitShim {
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte logProgressBuildStage = 0;
        private boolean logProgress;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte jobIdBuildStage = 0;
        private JobId jobId;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte topKBuildStage = 0;
        private int topK;
        private byte sampleRateBuildStage = 0;
        private double sampleRate;
        private byte perturbationRateBuildStage = 0;
        private double perturbationRate;
        private byte deltaThresholdBuildStage = 0;
        private double deltaThreshold;
        private byte similarityCutoffBuildStage = 0;
        private double similarityCutoff;
        private byte maxIterationsBuildStage = 0;
        private int maxIterations;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte randomJoinsBuildStage = 0;
        private int randomJoins;
        private byte initialSamplerBuildStage = 0;
        private KnnSampler.SamplerType initialSampler;
        private byte writeConcurrencyBuildStage = 0;
        private int writeConcurrency;

        private InitShim() {
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableKnnWriteConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        boolean logProgress() {
            if (this.logProgressBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.logProgressBuildStage == 0) {
                this.logProgressBuildStage = (byte)-1;
                this.logProgress = ImmutableKnnWriteConfig.this.logProgressInitialize();
                this.logProgressBuildStage = 1;
            }
            return this.logProgress;
        }

        void logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.logProgressBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableKnnWriteConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableKnnWriteConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableKnnWriteConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        JobId jobId() {
            if (this.jobIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.jobIdBuildStage == 0) {
                this.jobIdBuildStage = (byte)-1;
                this.jobId = Objects.requireNonNull(ImmutableKnnWriteConfig.this.jobIdInitialize(), "jobId");
                this.jobIdBuildStage = 1;
            }
            return this.jobId;
        }

        void jobId(JobId jobId) {
            this.jobId = jobId;
            this.jobIdBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableKnnWriteConfig.createUnmodifiableList(false, ImmutableKnnWriteConfig.createSafeList(ImmutableKnnWriteConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableKnnWriteConfig.createUnmodifiableList(false, ImmutableKnnWriteConfig.createSafeList(ImmutableKnnWriteConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        int topK() {
            if (this.topKBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.topKBuildStage == 0) {
                this.topKBuildStage = (byte)-1;
                this.topK = ImmutableKnnWriteConfig.this.topKInitialize();
                this.topKBuildStage = 1;
            }
            return this.topK;
        }

        void topK(int topK) {
            this.topK = topK;
            this.topKBuildStage = 1;
        }

        double sampleRate() {
            if (this.sampleRateBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sampleRateBuildStage == 0) {
                this.sampleRateBuildStage = (byte)-1;
                this.sampleRate = ImmutableKnnWriteConfig.this.sampleRateInitialize();
                this.sampleRateBuildStage = 1;
            }
            return this.sampleRate;
        }

        void sampleRate(double sampleRate) {
            this.sampleRate = sampleRate;
            this.sampleRateBuildStage = 1;
        }

        double perturbationRate() {
            if (this.perturbationRateBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.perturbationRateBuildStage == 0) {
                this.perturbationRateBuildStage = (byte)-1;
                this.perturbationRate = ImmutableKnnWriteConfig.this.perturbationRateInitialize();
                this.perturbationRateBuildStage = 1;
            }
            return this.perturbationRate;
        }

        void perturbationRate(double perturbationRate) {
            this.perturbationRate = perturbationRate;
            this.perturbationRateBuildStage = 1;
        }

        double deltaThreshold() {
            if (this.deltaThresholdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.deltaThresholdBuildStage == 0) {
                this.deltaThresholdBuildStage = (byte)-1;
                this.deltaThreshold = ImmutableKnnWriteConfig.this.deltaThresholdInitialize();
                this.deltaThresholdBuildStage = 1;
            }
            return this.deltaThreshold;
        }

        void deltaThreshold(double deltaThreshold) {
            this.deltaThreshold = deltaThreshold;
            this.deltaThresholdBuildStage = 1;
        }

        double similarityCutoff() {
            if (this.similarityCutoffBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.similarityCutoffBuildStage == 0) {
                this.similarityCutoffBuildStage = (byte)-1;
                this.similarityCutoff = ImmutableKnnWriteConfig.this.similarityCutoffInitialize();
                this.similarityCutoffBuildStage = 1;
            }
            return this.similarityCutoff;
        }

        void similarityCutoff(double similarityCutoff) {
            this.similarityCutoff = similarityCutoff;
            this.similarityCutoffBuildStage = 1;
        }

        int maxIterations() {
            if (this.maxIterationsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maxIterationsBuildStage == 0) {
                this.maxIterationsBuildStage = (byte)-1;
                this.maxIterations = ImmutableKnnWriteConfig.this.maxIterationsInitialize();
                this.maxIterationsBuildStage = 1;
            }
            return this.maxIterations;
        }

        void maxIterations(int maxIterations) {
            this.maxIterations = maxIterations;
            this.maxIterationsBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutableKnnWriteConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        int randomJoins() {
            if (this.randomJoinsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.randomJoinsBuildStage == 0) {
                this.randomJoinsBuildStage = (byte)-1;
                this.randomJoins = ImmutableKnnWriteConfig.this.randomJoinsInitialize();
                this.randomJoinsBuildStage = 1;
            }
            return this.randomJoins;
        }

        void randomJoins(int randomJoins) {
            this.randomJoins = randomJoins;
            this.randomJoinsBuildStage = 1;
        }

        KnnSampler.SamplerType initialSampler() {
            if (this.initialSamplerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.initialSamplerBuildStage == 0) {
                this.initialSamplerBuildStage = (byte)-1;
                this.initialSampler = Objects.requireNonNull(ImmutableKnnWriteConfig.this.initialSamplerInitialize(), "initialSampler");
                this.initialSamplerBuildStage = 1;
            }
            return this.initialSampler;
        }

        void initialSampler(KnnSampler.SamplerType initialSampler) {
            this.initialSampler = initialSampler;
            this.initialSamplerBuildStage = 1;
        }

        int writeConcurrency() {
            if (this.writeConcurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.writeConcurrencyBuildStage == 0) {
                this.writeConcurrencyBuildStage = (byte)-1;
                this.writeConcurrency = ImmutableKnnWriteConfig.this.writeConcurrencyInitialize();
                this.writeConcurrencyBuildStage = 1;
            }
            return this.writeConcurrency;
        }

        void writeConcurrency(int writeConcurrency) {
            this.writeConcurrency = writeConcurrency;
            this.writeConcurrencyBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.logProgressBuildStage == -1) {
                attributes.add("logProgress");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.jobIdBuildStage == -1) {
                attributes.add("jobId");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.topKBuildStage == -1) {
                attributes.add("topK");
            }
            if (this.sampleRateBuildStage == -1) {
                attributes.add("sampleRate");
            }
            if (this.perturbationRateBuildStage == -1) {
                attributes.add("perturbationRate");
            }
            if (this.deltaThresholdBuildStage == -1) {
                attributes.add("deltaThreshold");
            }
            if (this.similarityCutoffBuildStage == -1) {
                attributes.add("similarityCutoff");
            }
            if (this.maxIterationsBuildStage == -1) {
                attributes.add("maxIterations");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.randomJoinsBuildStage == -1) {
                attributes.add("randomJoins");
            }
            if (this.initialSamplerBuildStage == -1) {
                attributes.add("initialSampler");
            }
            if (this.writeConcurrencyBuildStage == -1) {
                attributes.add("writeConcurrency");
            }
            return "Cannot build KnnWriteConfig, attribute initializers form cycle " + attributes;
        }
    }
}

