/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.knn;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.similarity.knn.Knn;
import org.neo4j.gds.similarity.knn.NeighborList;

@Generated(from="Knn.Result", generator="Immutables")
public final class ImmutableResult
extends Knn.Result {
    private final HugeObjectArray<NeighborList> neighborList;
    private final int ranIterations;
    private final boolean didConverge;
    private final long nodePairsConsidered;

    private ImmutableResult(HugeObjectArray<NeighborList> neighborList, int ranIterations, boolean didConverge, long nodePairsConsidered) {
        this.neighborList = Objects.requireNonNull(neighborList, "neighborList");
        this.ranIterations = ranIterations;
        this.didConverge = didConverge;
        this.nodePairsConsidered = nodePairsConsidered;
    }

    private ImmutableResult(ImmutableResult original, HugeObjectArray<NeighborList> neighborList, int ranIterations, boolean didConverge, long nodePairsConsidered) {
        this.neighborList = neighborList;
        this.ranIterations = ranIterations;
        this.didConverge = didConverge;
        this.nodePairsConsidered = nodePairsConsidered;
    }

    @Override
    public HugeObjectArray<NeighborList> neighborList() {
        return this.neighborList;
    }

    @Override
    public int ranIterations() {
        return this.ranIterations;
    }

    @Override
    public boolean didConverge() {
        return this.didConverge;
    }

    @Override
    public long nodePairsConsidered() {
        return this.nodePairsConsidered;
    }

    public final ImmutableResult withNeighborList(HugeObjectArray<NeighborList> value) {
        if (this.neighborList == value) {
            return this;
        }
        HugeObjectArray<NeighborList> newValue = Objects.requireNonNull(value, "neighborList");
        return new ImmutableResult(this, newValue, this.ranIterations, this.didConverge, this.nodePairsConsidered);
    }

    public final ImmutableResult withRanIterations(int value) {
        if (this.ranIterations == value) {
            return this;
        }
        return new ImmutableResult(this, this.neighborList, value, this.didConverge, this.nodePairsConsidered);
    }

    public final ImmutableResult withDidConverge(boolean value) {
        if (this.didConverge == value) {
            return this;
        }
        return new ImmutableResult(this, this.neighborList, this.ranIterations, value, this.nodePairsConsidered);
    }

    public final ImmutableResult withNodePairsConsidered(long value) {
        if (this.nodePairsConsidered == value) {
            return this;
        }
        return new ImmutableResult(this, this.neighborList, this.ranIterations, this.didConverge, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableResult && this.equalTo((ImmutableResult)another);
    }

    private boolean equalTo(ImmutableResult another) {
        return this.neighborList.equals(another.neighborList) && this.ranIterations == another.ranIterations && this.didConverge == another.didConverge && this.nodePairsConsidered == another.nodePairsConsidered;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.neighborList.hashCode();
        h += (h << 5) + this.ranIterations;
        h += (h << 5) + Boolean.hashCode(this.didConverge);
        h += (h << 5) + Long.hashCode(this.nodePairsConsidered);
        return h;
    }

    public String toString() {
        return "Result{neighborList=" + this.neighborList + ", ranIterations=" + this.ranIterations + ", didConverge=" + this.didConverge + ", nodePairsConsidered=" + this.nodePairsConsidered + "}";
    }

    public static Knn.Result of(HugeObjectArray<NeighborList> neighborList, int ranIterations, boolean didConverge, long nodePairsConsidered) {
        return new ImmutableResult(neighborList, ranIterations, didConverge, nodePairsConsidered);
    }

    public static Knn.Result copyOf(Knn.Result instance) {
        if (instance instanceof ImmutableResult) {
            return (ImmutableResult)instance;
        }
        return ImmutableResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Knn.Result", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NEIGHBOR_LIST = 1L;
        private static final long INIT_BIT_RAN_ITERATIONS = 2L;
        private static final long INIT_BIT_DID_CONVERGE = 4L;
        private static final long INIT_BIT_NODE_PAIRS_CONSIDERED = 8L;
        private long initBits = 15L;
        private HugeObjectArray<NeighborList> neighborList;
        private int ranIterations;
        private boolean didConverge;
        private long nodePairsConsidered;

        private Builder() {
        }

        public final Builder from(Knn.Result instance) {
            Objects.requireNonNull(instance, "instance");
            this.neighborList(instance.neighborList());
            this.ranIterations(instance.ranIterations());
            this.didConverge(instance.didConverge());
            this.nodePairsConsidered(instance.nodePairsConsidered());
            return this;
        }

        public final Builder neighborList(HugeObjectArray<NeighborList> neighborList) {
            this.neighborList = Objects.requireNonNull(neighborList, "neighborList");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder ranIterations(int ranIterations) {
            this.ranIterations = ranIterations;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder didConverge(boolean didConverge) {
            this.didConverge = didConverge;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder nodePairsConsidered(long nodePairsConsidered) {
            this.nodePairsConsidered = nodePairsConsidered;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public Builder clear() {
            this.initBits = 15L;
            this.neighborList = null;
            this.ranIterations = 0;
            this.didConverge = false;
            this.nodePairsConsidered = 0L;
            return this;
        }

        public Knn.Result build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableResult(null, this.neighborList, this.ranIterations, this.didConverge, this.nodePairsConsidered);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("neighborList");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ranIterations");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("didConverge");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("nodePairsConsidered");
            }
            return "Cannot build Result, some of required attributes are not set " + attributes;
        }
    }
}

