/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.knn;

import java.util.List;
import org.immutables.value.Value;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.IterationsConfig;
import org.neo4j.gds.config.SingleThreadedRandomSeedConfig;
import org.neo4j.gds.similarity.knn.KnnNodePropertySpec;
import org.neo4j.gds.similarity.knn.KnnSampler;

@ValueClass
@Configuration
public interface KnnBaseConfig
extends AlgoBaseConfig,
IterationsConfig,
SingleThreadedRandomSeedConfig {
    @Configuration.ConvertWith(method="org.neo4j.gds.similarity.knn.KnnNodePropertySpecParser#parse")
    @Configuration.ToMapValue(value="org.neo4j.gds.similarity.knn.KnnNodePropertySpecParser#render")
    public List<KnnNodePropertySpec> nodeProperties();

    @Value.Default
    @Configuration.IntegerRange(min=1)
    default public int topK() {
        return 10;
    }

    @Value.Default
    @Configuration.DoubleRange(min=0.0, max=1.0, minInclusive=false)
    default public double sampleRate() {
        return 0.5;
    }

    @Value.Default
    @Configuration.DoubleRange(min=0.0, max=1.0)
    default public double perturbationRate() {
        return 0.0;
    }

    @Value.Default
    @Configuration.DoubleRange(min=0.0, max=1.0)
    default public double deltaThreshold() {
        return 0.001;
    }

    @Value.Default
    @Configuration.DoubleRange(min=0.0, max=1.0)
    default public double similarityCutoff() {
        return 0.0;
    }

    @Configuration.IntegerRange(min=1)
    @Value.Default
    default public int maxIterations() {
        return 100;
    }

    @Value.Default
    @Configuration.Ignore
    default public int minBatchSize() {
        return 1000;
    }

    @Value.Default
    @Configuration.IntegerRange(min=0)
    default public int randomJoins() {
        return 10;
    }

    @Configuration.Ignore
    default public int sampledK(long nodeCount) {
        return Math.max(0, (int)Math.min((long)Math.ceil(this.sampleRate() * (double)this.topK()), nodeCount - 1L));
    }

    @Configuration.Ignore
    default public int boundedK(long nodeCount) {
        return Math.max(0, (int)Math.min((long)this.topK(), nodeCount - 1L));
    }

    @Value.Default
    @Configuration.ConvertWith(method="org.neo4j.gds.similarity.knn.KnnSampler.SamplerType#parse")
    @Configuration.ToMapValue(value="org.neo4j.gds.similarity.knn.KnnSampler.SamplerType#toString")
    default public KnnSampler.SamplerType initialSampler() {
        return KnnSampler.SamplerType.UNIFORM;
    }
}

