/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.knn;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.LongPredicate;
import java.util.stream.Collectors;

public interface KnnSampler {
    public long[] sample(long var1, long var3, int var5, LongPredicate var6);

    public static enum SamplerType {
        UNIFORM,
        RANDOMWALK;

        private static final List<String> VALUES;

        public static SamplerType parse(Object input) {
            if (input instanceof String) {
                String inputString = ((String)input).toUpperCase(Locale.ENGLISH);
                if (VALUES.contains(inputString)) {
                    return SamplerType.valueOf(inputString);
                }
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Sampler `%s` is not supported. Must be one of: %s.", inputString, VALUES));
            }
            if (input instanceof SamplerType) {
                return (SamplerType)((Object)input);
            }
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Expected Sampler or String. Got %s.", input.getClass().getSimpleName()));
        }

        public static String toString(SamplerType samplerType) {
            return samplerType.toString();
        }

        static {
            VALUES = Arrays.stream(SamplerType.values()).map(Enum::name).collect(Collectors.toList());
        }
    }
}

