/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.knn.metrics;

import java.util.Arrays;
import java.util.List;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.similarity.knn.KnnNodePropertySpec;
import org.neo4j.gds.similarity.knn.metrics.SimilarityComputer;

final class CombinedSimilarityComputer
implements SimilarityComputer {
    private final SimilarityComputer[] similarityComputers;
    private final int numOfProperties;
    private final boolean isSymmetric;

    CombinedSimilarityComputer(Graph graph, List<KnnNodePropertySpec> propertyNames) {
        this.numOfProperties = propertyNames.size();
        this.similarityComputers = new SimilarityComputer[this.numOfProperties];
        for (int i = 0; i < this.numOfProperties; ++i) {
            this.similarityComputers[i] = SimilarityComputer.ofProperty(graph, propertyNames.get(i));
        }
        this.isSymmetric = Arrays.stream(this.similarityComputers).allMatch(SimilarityComputer::isSymmetric);
    }

    @Override
    public double similarity(long firstNodeId, long secondNodeId) {
        double sum = 0.0;
        for (SimilarityComputer similarityComputer : this.similarityComputers) {
            sum += similarityComputer.safeSimilarity(firstNodeId, secondNodeId);
        }
        return sum / (double)this.numOfProperties;
    }

    @Override
    public boolean isSymmetric() {
        return this.isSymmetric;
    }
}

