/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.knn.metrics;

import org.neo4j.gds.core.utils.Intersections;

public final class Cosine {
    private Cosine() {
    }

    public static double floatMetric(float[] left, float[] right) {
        int len = Math.min(left.length, right.length);
        float cosine = Intersections.cosine((float[])left, (float[])right, (int)len);
        return (cosine + 1.0f) / 2.0f;
    }

    public static double doubleMetric(double[] left, double[] right) {
        int len = Math.min(left.length, right.length);
        double cosine = Intersections.cosine((double[])left, (double[])right, (int)len);
        return (cosine + 1.0) / 2.0;
    }
}

