/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.knn.metrics;

import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.similarity.knn.metrics.DoubleArraySimilarityMetric;
import org.neo4j.gds.similarity.knn.metrics.SimilarityComputer;

final class DoubleArrayPropertySimilarityComputer
implements SimilarityComputer {
    private final NodePropertyValues nodePropertyValues;
    private final DoubleArraySimilarityMetric metric;

    DoubleArrayPropertySimilarityComputer(NodePropertyValues nodePropertyValues, DoubleArraySimilarityMetric metric) {
        this.metric = metric;
        if (nodePropertyValues.valueType() != ValueType.DOUBLE_ARRAY) {
            throw new IllegalArgumentException("The property is not of type DOUBLE_ARRAY");
        }
        this.nodePropertyValues = nodePropertyValues;
    }

    @Override
    public double similarity(long firstNodeId, long secondNodeId) {
        double[] left = this.nodePropertyValues.doubleArrayValue(firstNodeId);
        double[] right = this.nodePropertyValues.doubleArrayValue(secondNodeId);
        return this.metric.compute(left, right);
    }

    @Override
    public boolean isSymmetric() {
        return this.metric.isSymmetric();
    }
}

