/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.knn.metrics;

import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.similarity.knn.metrics.SimilarityComputer;

final class DoublePropertySimilarityComputer
implements SimilarityComputer {
    private final NodePropertyValues nodePropertyValues;

    DoublePropertySimilarityComputer(NodePropertyValues nodePropertyValues) {
        if (nodePropertyValues.valueType() != ValueType.DOUBLE) {
            throw new IllegalArgumentException("The property is not of type DOUBLE");
        }
        this.nodePropertyValues = nodePropertyValues;
    }

    @Override
    public double similarity(long firstNodeId, long secondNodeId) {
        double left = this.nodePropertyValues.doubleValue(firstNodeId);
        double right = this.nodePropertyValues.doubleValue(secondNodeId);
        return 1.0 / (1.0 + Math.abs(left - right));
    }

    @Override
    public boolean isSymmetric() {
        return true;
    }
}

