/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.knn.metrics;

import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.similarity.knn.metrics.FloatArraySimilarityMetric;
import org.neo4j.gds.similarity.knn.metrics.SimilarityComputer;

final class FloatArrayPropertySimilarityComputer
implements SimilarityComputer {
    private final NodePropertyValues nodePropertyValues;
    private final FloatArraySimilarityMetric metric;

    FloatArrayPropertySimilarityComputer(NodePropertyValues nodePropertyValues, FloatArraySimilarityMetric metric) {
        this.metric = metric;
        if (nodePropertyValues.valueType() != ValueType.FLOAT_ARRAY) {
            throw new IllegalArgumentException("The property is not of type FLOAT_ARRAY");
        }
        this.nodePropertyValues = nodePropertyValues;
    }

    @Override
    public double similarity(long firstNodeId, long secondNodeId) {
        float[] left = this.nodePropertyValues.floatArrayValue(firstNodeId);
        float[] right = this.nodePropertyValues.floatArrayValue(secondNodeId);
        return this.metric.compute(left, right);
    }

    @Override
    public boolean isSymmetric() {
        return this.metric.isSymmetric();
    }
}

