/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.knn.metrics;

import java.util.Arrays;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.properties.nodes.LongArrayNodePropertyValues;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.similarity.knn.metrics.LongArraySimilarityMetric;
import org.neo4j.gds.similarity.knn.metrics.SimilarityComputer;

final class LongArrayPropertySimilarityComputer
implements SimilarityComputer {
    private final NodePropertyValues nodePropertyValues;
    private final LongArraySimilarityMetric metric;

    LongArrayPropertySimilarityComputer(NodePropertyValues nodePropertyValues, LongArraySimilarityMetric metric) {
        if (nodePropertyValues.valueType() != ValueType.LONG_ARRAY) {
            throw new IllegalArgumentException("The property is not of type LONG_ARRAY");
        }
        this.nodePropertyValues = nodePropertyValues;
        this.metric = metric;
    }

    @Override
    public double similarity(long firstNodeId, long secondNodeId) {
        long[] left = this.nodePropertyValues.longArrayValue(firstNodeId);
        long[] right = this.nodePropertyValues.longArrayValue(secondNodeId);
        return this.metric.compute(left, right);
    }

    @Override
    public boolean isSymmetric() {
        return this.metric.isSymmetric();
    }

    static final class SortedLongArrayPropertyValues
    implements LongArrayNodePropertyValues {
        private final HugeObjectArray<long[]> properties;

        SortedLongArrayPropertyValues(NodePropertyValues nodePropertyValues) {
            this.properties = HugeObjectArray.newArray(long[].class, (long)nodePropertyValues.nodeCount());
            this.properties.setAll(i -> {
                long[] input = nodePropertyValues.longArrayValue(i);
                if (input == null) {
                    return null;
                }
                long[] value = (long[])input.clone();
                Arrays.parallelSort(value);
                return value;
            });
        }

        public long nodeCount() {
            return this.properties.size();
        }

        public long[] longArrayValue(long nodeId) {
            return (long[])this.properties.get(nodeId);
        }
    }
}

