/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.knn.metrics;

import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.similarity.knn.metrics.SimilarityComputer;

final class LongPropertySimilarityComputer
implements SimilarityComputer {
    private final NodePropertyValues nodePropertyValues;

    LongPropertySimilarityComputer(NodePropertyValues nodePropertyValues) {
        if (nodePropertyValues.valueType() != ValueType.LONG) {
            throw new IllegalArgumentException("The property is not of type LONG");
        }
        this.nodePropertyValues = nodePropertyValues;
    }

    @Override
    public double similarity(long firstNodeId, long secondNodeId) {
        long right;
        long left = this.nodePropertyValues.longValue(firstNodeId);
        long abs = Math.abs(left - (right = this.nodePropertyValues.longValue(secondNodeId)));
        if (abs == Long.MIN_VALUE) {
            abs = Long.MAX_VALUE;
        }
        return 1.0 / (1.0 + (double)abs);
    }

    @Override
    public boolean isSymmetric() {
        return true;
    }
}

