/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.knn.metrics;

import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.values.storable.Value;

public final class NullCheckingNodePropertyValues
implements NodePropertyValues {
    private final NodePropertyValues properties;
    private final String name;
    private final IdMap idMap;

    public static NullCheckingNodePropertyValues create(NodePropertyValues properties, String name, IdMap idMap) {
        ValueType valueType = properties.valueType();
        assert (valueType != ValueType.DOUBLE && valueType != ValueType.LONG) : "Don't use NullCheckingNodeProperties for primitive properties";
        return new NullCheckingNodePropertyValues(properties, name, idMap);
    }

    private NullCheckingNodePropertyValues(NodePropertyValues properties, String name, IdMap idMap) {
        this.properties = properties;
        this.name = name;
        this.idMap = idMap;
    }

    public double[] doubleArrayValue(long nodeId) {
        double[] value = this.properties.doubleArrayValue(nodeId);
        this.check(nodeId, value);
        return value;
    }

    public float[] floatArrayValue(long nodeId) {
        float[] value = this.properties.floatArrayValue(nodeId);
        this.check(nodeId, value);
        return value;
    }

    public long[] longArrayValue(long nodeId) {
        long[] value = this.properties.longArrayValue(nodeId);
        this.check(nodeId, value);
        return value;
    }

    public Object getObject(long nodeId) {
        Object value = this.properties.getObject(nodeId);
        this.check(nodeId, value);
        return value;
    }

    public ValueType valueType() {
        return this.properties.valueType();
    }

    public Value value(long nodeId) {
        Value value = this.properties.value(nodeId);
        this.check(nodeId, value);
        return value;
    }

    public long nodeCount() {
        return this.properties.nodeCount();
    }

    private void check(long nodeId, @Nullable Object value) {
        if (value == null) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Missing `%s` node property `%s` for node with id `%s`.", (Object[])new Object[]{this.properties.valueType().cypherName(), this.name, this.idMap.toOriginalNodeId(nodeId)}));
        }
    }
}

