/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.knn.metrics;

public final class Pearson {
    private Pearson() {
    }

    public static double floatMetric(float[] a, float[] b) {
        int n = Math.min(a.length, b.length);
        double sumA = 0.0;
        double sumB = 0.0;
        for (int i = 0; i < n; ++i) {
            sumA += (double)a[i];
            sumB += (double)b[i];
        }
        double meanA = sumA / (double)n;
        double meanB = sumB / (double)n;
        double sumOfProductOfADeltaBDelta = 0.0;
        double sumOfADeltaSquared = 0.0;
        double sumOfBDeltaSquared = 0.0;
        for (int i = 0; i < n; ++i) {
            double aDelta = (double)a[i] - meanA;
            double bDelta = (double)b[i] - meanB;
            sumOfProductOfADeltaBDelta += aDelta * bDelta;
            sumOfADeltaSquared += aDelta * aDelta;
            sumOfBDeltaSquared += bDelta * bDelta;
        }
        double r = sumOfProductOfADeltaBDelta / Math.sqrt(sumOfADeltaSquared * sumOfBDeltaSquared);
        return (r + 1.0) / 2.0;
    }

    public static double doubleMetric(double[] a, double[] b) {
        int n = Math.min(a.length, b.length);
        double sumA = 0.0;
        double sumB = 0.0;
        for (int i = 0; i < n; ++i) {
            sumA += a[i];
            sumB += b[i];
        }
        double meanA = sumA / (double)n;
        double meanB = sumB / (double)n;
        double sumOfProductOfADeltaBDelta = 0.0;
        double sumOfADeltaSquared = 0.0;
        double sumOfBDeltaSquared = 0.0;
        for (int i = 0; i < n; ++i) {
            double aDelta = a[i] - meanA;
            double bDelta = b[i] - meanB;
            sumOfProductOfADeltaBDelta += aDelta * bDelta;
            sumOfADeltaSquared += aDelta * aDelta;
            sumOfBDeltaSquared += bDelta * bDelta;
        }
        double r = sumOfProductOfADeltaBDelta / Math.sqrt(sumOfADeltaSquared * sumOfBDeltaSquared);
        return (r + 1.0) / 2.0;
    }
}

