/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.knn.metrics;

import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.utils.StringFormatting;

public enum SimilarityMetric {
    JACCARD,
    OVERLAP,
    COSINE,
    EUCLIDEAN,
    PEARSON,
    LONG_PROPERTY_METRIC,
    DOUBLE_PROPERTY_METRIC,
    DEFAULT;


    public static SimilarityMetric parse(String value) {
        return SimilarityMetric.valueOf(StringFormatting.toUpperCaseWithLocale((String)value));
    }

    public static SimilarityMetric defaultMetricForType(ValueType valueType) {
        switch (valueType) {
            case LONG: {
                return LONG_PROPERTY_METRIC;
            }
            case DOUBLE: {
                return DOUBLE_PROPERTY_METRIC;
            }
            case DOUBLE_ARRAY: 
            case FLOAT_ARRAY: {
                return COSINE;
            }
            case LONG_ARRAY: {
                return JACCARD;
            }
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"No default similarity metric exists for value type [%s].", (Object[])new Object[]{valueType}));
    }
}

