/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.nodesim;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.JobIdConfig;
import org.neo4j.gds.config.MutatePropertyConfig;
import org.neo4j.gds.config.MutateRelationshipConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.similarity.nodesim.MetricSimilarityComputer;
import org.neo4j.gds.similarity.nodesim.NodeSimilarityBaseConfig;
import org.neo4j.gds.similarity.nodesim.NodeSimilarityMutateConfig;

@Generated(from="NodeSimilarityMutateConfig", generator="Immutables")
public final class ImmutableNodeSimilarityMutateConfig
implements NodeSimilarityMutateConfig {
    private final String usernameOverride;
    private final boolean sudo;
    private final boolean logProgress;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    private final JobId jobId;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    private final String relationshipWeightProperty;
    private final transient boolean hasRelationshipWeightProperty;
    private final double similarityCutoff;
    private final MetricSimilarityComputer.MetricSimilarityComputerBuilder similarityMetric;
    private final int degreeCutoff;
    private final int topK;
    private final int topN;
    private final int bottomK;
    private final int bottomN;
    private final transient int normalizedK;
    private final transient int normalizedN;
    private final transient boolean isParallel;
    private final transient boolean hasTopK;
    private final transient boolean hasTopN;
    private final transient boolean computeToGraph;
    private final String mutateProperty;
    private final String mutateRelationshipType;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableNodeSimilarityMutateConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<String> relationshipWeightProperty, double similarityCutoff, MetricSimilarityComputer.MetricSimilarityComputerBuilder similarityMetric, int degreeCutoff, int topK, int topN, int bottomK, int bottomN, String mutateProperty, String mutateRelationshipType) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableNodeSimilarityMutateConfig.createUnmodifiableList(false, ImmutableNodeSimilarityMutateConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableNodeSimilarityMutateConfig.createUnmodifiableList(false, ImmutableNodeSimilarityMutateConfig.createSafeList(nodeLabels, true, false)));
        this.relationshipWeightProperty = relationshipWeightProperty.orElse(null);
        this.initShim.similarityCutoff(similarityCutoff);
        this.initShim.similarityMetric(Objects.requireNonNull(similarityMetric, "similarityMetric"));
        this.initShim.degreeCutoff(degreeCutoff);
        this.initShim.topK(topK);
        this.initShim.topN(topN);
        this.initShim.bottomK(bottomK);
        this.initShim.bottomN(bottomN);
        this.mutateProperty = Objects.requireNonNull(mutateProperty, "mutateProperty");
        this.mutateRelationshipType = Objects.requireNonNull(mutateRelationshipType, "mutateRelationshipType");
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.similarityCutoff = this.initShim.similarityCutoff();
        this.similarityMetric = this.initShim.similarityMetric();
        this.degreeCutoff = this.initShim.degreeCutoff();
        this.topK = this.initShim.topK();
        this.topN = this.initShim.topN();
        this.bottomK = this.initShim.bottomK();
        this.bottomN = this.initShim.bottomN();
        this.normalizedK = this.initShim.normalizedK();
        this.normalizedN = this.initShim.normalizedN();
        this.isParallel = this.initShim.isParallel();
        this.hasTopK = this.initShim.hasTopK();
        this.hasTopN = this.initShim.hasTopN();
        this.computeToGraph = this.initShim.computeToGraph();
        this.initShim = null;
    }

    private ImmutableNodeSimilarityMutateConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, String relationshipWeightProperty, double similarityCutoff, MetricSimilarityComputer.MetricSimilarityComputerBuilder similarityMetric, int degreeCutoff, int topK, int topN, int bottomK, int bottomN, String mutateProperty, String mutateRelationshipType) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableNodeSimilarityMutateConfig.createUnmodifiableList(false, ImmutableNodeSimilarityMutateConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableNodeSimilarityMutateConfig.createUnmodifiableList(false, ImmutableNodeSimilarityMutateConfig.createSafeList(nodeLabels, true, false)));
        this.relationshipWeightProperty = relationshipWeightProperty;
        this.initShim.similarityCutoff(similarityCutoff);
        this.initShim.similarityMetric(Objects.requireNonNull(similarityMetric, "similarityMetric"));
        this.initShim.degreeCutoff(degreeCutoff);
        this.initShim.topK(topK);
        this.initShim.topN(topN);
        this.initShim.bottomK(bottomK);
        this.initShim.bottomN(bottomN);
        this.mutateProperty = Objects.requireNonNull(mutateProperty, "mutateProperty");
        this.mutateRelationshipType = Objects.requireNonNull(mutateRelationshipType, "mutateRelationshipType");
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.similarityCutoff = this.initShim.similarityCutoff();
        this.similarityMetric = this.initShim.similarityMetric();
        this.degreeCutoff = this.initShim.degreeCutoff();
        this.topK = this.initShim.topK();
        this.topN = this.initShim.topN();
        this.bottomK = this.initShim.bottomK();
        this.bottomN = this.initShim.bottomN();
        this.normalizedK = this.initShim.normalizedK();
        this.normalizedN = this.initShim.normalizedN();
        this.isParallel = this.initShim.isParallel();
        this.hasTopK = this.initShim.hasTopK();
        this.hasTopN = this.initShim.hasTopN();
        this.computeToGraph = this.initShim.computeToGraph();
        this.initShim = null;
    }

    private ImmutableNodeSimilarityMutateConfig(Builder builder) {
        this.usernameOverride = builder.usernameOverride;
        this.relationshipWeightProperty = builder.relationshipWeightProperty;
        this.mutateProperty = builder.mutateProperty;
        this.mutateRelationshipType = builder.mutateRelationshipType;
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.logProgressIsSet()) {
            this.initShim.logProgress(builder.logProgress);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.jobId != null) {
            this.initShim.jobId(builder.jobId);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableNodeSimilarityMutateConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableNodeSimilarityMutateConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.similarityCutoffIsSet()) {
            this.initShim.similarityCutoff(builder.similarityCutoff);
        }
        if (builder.similarityMetric != null) {
            this.initShim.similarityMetric(builder.similarityMetric);
        }
        if (builder.degreeCutoffIsSet()) {
            this.initShim.degreeCutoff(builder.degreeCutoff);
        }
        if (builder.topKIsSet()) {
            this.initShim.topK(builder.topK);
        }
        if (builder.topNIsSet()) {
            this.initShim.topN(builder.topN);
        }
        if (builder.bottomKIsSet()) {
            this.initShim.bottomK(builder.bottomK);
        }
        if (builder.bottomNIsSet()) {
            this.initShim.bottomN(builder.bottomN);
        }
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.similarityCutoff = this.initShim.similarityCutoff();
        this.similarityMetric = this.initShim.similarityMetric();
        this.degreeCutoff = this.initShim.degreeCutoff();
        this.topK = this.initShim.topK();
        this.topN = this.initShim.topN();
        this.bottomK = this.initShim.bottomK();
        this.bottomN = this.initShim.bottomN();
        this.normalizedK = this.initShim.normalizedK();
        this.normalizedN = this.initShim.normalizedN();
        this.isParallel = this.initShim.isParallel();
        this.hasTopK = this.initShim.hasTopK();
        this.hasTopN = this.initShim.hasTopN();
        this.computeToGraph = this.initShim.computeToGraph();
        this.initShim = null;
    }

    private ImmutableNodeSimilarityMutateConfig(String usernameOverride, boolean sudo, boolean logProgress, Collection<String> configKeys, int concurrency, int minBatchSize, JobId jobId, List<String> relationshipTypes, List<String> nodeLabels, String relationshipWeightProperty, double similarityCutoff, MetricSimilarityComputer.MetricSimilarityComputerBuilder similarityMetric, int degreeCutoff, int topK, int topN, int bottomK, int bottomN, String mutateProperty, String mutateRelationshipType) {
        this.usernameOverride = usernameOverride;
        this.initShim.sudo(sudo);
        this.initShim.logProgress(logProgress);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.jobId(jobId);
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.relationshipWeightProperty = relationshipWeightProperty;
        this.initShim.similarityCutoff(similarityCutoff);
        this.initShim.similarityMetric(similarityMetric);
        this.initShim.degreeCutoff(degreeCutoff);
        this.initShim.topK(topK);
        this.initShim.topN(topN);
        this.initShim.bottomK(bottomK);
        this.initShim.bottomN(bottomN);
        this.mutateProperty = mutateProperty;
        this.mutateRelationshipType = mutateRelationshipType;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.similarityCutoff = this.initShim.similarityCutoff();
        this.similarityMetric = this.initShim.similarityMetric();
        this.degreeCutoff = this.initShim.degreeCutoff();
        this.topK = this.initShim.topK();
        this.topN = this.initShim.topN();
        this.bottomK = this.initShim.bottomK();
        this.bottomN = this.initShim.bottomN();
        this.normalizedK = this.initShim.normalizedK();
        this.normalizedN = this.initShim.normalizedN();
        this.isParallel = this.initShim.isParallel();
        this.hasTopK = this.initShim.hasTopK();
        this.hasTopN = this.initShim.hasTopN();
        this.computeToGraph = this.initShim.computeToGraph();
        this.initShim = null;
    }

    private boolean sudoInitialize() {
        return NodeSimilarityMutateConfig.super.sudo();
    }

    private boolean logProgressInitialize() {
        return NodeSimilarityMutateConfig.super.logProgress();
    }

    private Collection<String> configKeysInitialize() {
        return NodeSimilarityMutateConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return NodeSimilarityMutateConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return NodeSimilarityMutateConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return NodeSimilarityMutateConfig.super.minBatchSize();
    }

    private JobId jobIdInitialize() {
        return NodeSimilarityMutateConfig.super.jobId();
    }

    private List<String> relationshipTypesInitialize() {
        return NodeSimilarityMutateConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return NodeSimilarityMutateConfig.super.nodeLabels();
    }

    private boolean hasRelationshipWeightPropertyInitialize() {
        return NodeSimilarityMutateConfig.super.hasRelationshipWeightProperty();
    }

    private double similarityCutoffInitialize() {
        return NodeSimilarityMutateConfig.super.similarityCutoff();
    }

    private MetricSimilarityComputer.MetricSimilarityComputerBuilder similarityMetricInitialize() {
        return NodeSimilarityMutateConfig.super.similarityMetric();
    }

    private int degreeCutoffInitialize() {
        return NodeSimilarityMutateConfig.super.degreeCutoff();
    }

    private int topKInitialize() {
        return NodeSimilarityMutateConfig.super.topK();
    }

    private int topNInitialize() {
        return NodeSimilarityMutateConfig.super.topN();
    }

    private int bottomKInitialize() {
        return NodeSimilarityMutateConfig.super.bottomK();
    }

    private int bottomNInitialize() {
        return NodeSimilarityMutateConfig.super.bottomN();
    }

    private int normalizedKInitialize() {
        return NodeSimilarityMutateConfig.super.normalizedK();
    }

    private int normalizedNInitialize() {
        return NodeSimilarityMutateConfig.super.normalizedN();
    }

    private boolean isParallelInitialize() {
        return NodeSimilarityMutateConfig.super.isParallel();
    }

    private boolean hasTopKInitialize() {
        return NodeSimilarityMutateConfig.super.hasTopK();
    }

    private boolean hasTopNInitialize() {
        return NodeSimilarityMutateConfig.super.hasTopN();
    }

    private boolean computeToGraphInitialize() {
        return NodeSimilarityMutateConfig.super.computeToGraph();
    }

    public Optional<String> usernameOverride() {
        return Optional.ofNullable(this.usernameOverride);
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public boolean logProgress() {
        InitShim shim = this.initShim;
        return shim != null ? shim.logProgress() : this.logProgress;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    public JobId jobId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.jobId() : this.jobId;
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    public Optional<String> relationshipWeightProperty() {
        return Optional.ofNullable(this.relationshipWeightProperty);
    }

    public boolean hasRelationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasRelationshipWeightProperty() : this.hasRelationshipWeightProperty;
    }

    @Override
    public double similarityCutoff() {
        InitShim shim = this.initShim;
        return shim != null ? shim.similarityCutoff() : this.similarityCutoff;
    }

    @Override
    public MetricSimilarityComputer.MetricSimilarityComputerBuilder similarityMetric() {
        InitShim shim = this.initShim;
        return shim != null ? shim.similarityMetric() : this.similarityMetric;
    }

    @Override
    public int degreeCutoff() {
        InitShim shim = this.initShim;
        return shim != null ? shim.degreeCutoff() : this.degreeCutoff;
    }

    @Override
    public int topK() {
        InitShim shim = this.initShim;
        return shim != null ? shim.topK() : this.topK;
    }

    @Override
    public int topN() {
        InitShim shim = this.initShim;
        return shim != null ? shim.topN() : this.topN;
    }

    @Override
    public int bottomK() {
        InitShim shim = this.initShim;
        return shim != null ? shim.bottomK() : this.bottomK;
    }

    @Override
    public int bottomN() {
        InitShim shim = this.initShim;
        return shim != null ? shim.bottomN() : this.bottomN;
    }

    @Override
    public int normalizedK() {
        InitShim shim = this.initShim;
        return shim != null ? shim.normalizedK() : this.normalizedK;
    }

    @Override
    public int normalizedN() {
        InitShim shim = this.initShim;
        return shim != null ? shim.normalizedN() : this.normalizedN;
    }

    @Override
    public boolean isParallel() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isParallel() : this.isParallel;
    }

    @Override
    public boolean hasTopK() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasTopK() : this.hasTopK;
    }

    @Override
    public boolean hasTopN() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasTopN() : this.hasTopN;
    }

    @Override
    public boolean computeToGraph() {
        InitShim shim = this.initShim;
        return shim != null ? shim.computeToGraph() : this.computeToGraph;
    }

    public String mutateProperty() {
        return this.mutateProperty;
    }

    public String mutateRelationshipType() {
        return this.mutateRelationshipType;
    }

    public final ImmutableNodeSimilarityMutateConfig withUsernameOverride(String value) {
        String newValue = value;
        if (Objects.equals(this.usernameOverride, newValue)) {
            return this;
        }
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(newValue, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withUsernameOverride(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(value, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, value, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withLogProgress(boolean value) {
        if (this.logProgress == value) {
            return this;
        }
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, this.sudo, value, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, this.sudo, this.logProgress, newValue, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, value, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, value, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withJobId(JobId value) {
        if (this.jobId == value) {
            return this;
        }
        JobId newValue = Objects.requireNonNull(value, "jobId");
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableNodeSimilarityMutateConfig.createUnmodifiableList(false, ImmutableNodeSimilarityMutateConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, newValue, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableNodeSimilarityMutateConfig.createUnmodifiableList(false, ImmutableNodeSimilarityMutateConfig.createSafeList(elements, true, false));
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, newValue, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableNodeSimilarityMutateConfig.createUnmodifiableList(false, ImmutableNodeSimilarityMutateConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, newValue, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableNodeSimilarityMutateConfig.createUnmodifiableList(false, ImmutableNodeSimilarityMutateConfig.createSafeList(elements, true, false));
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, newValue, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withRelationshipWeightProperty(String value) {
        String newValue = value;
        if (Objects.equals(this.relationshipWeightProperty, newValue)) {
            return this;
        }
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, newValue, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withRelationshipWeightProperty(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.relationshipWeightProperty, value)) {
            return this;
        }
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, value, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withSimilarityCutoff(double value) {
        if (Double.doubleToLongBits(this.similarityCutoff) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, value, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withSimilarityMetric(MetricSimilarityComputer.MetricSimilarityComputerBuilder value) {
        if (this.similarityMetric == value) {
            return this;
        }
        MetricSimilarityComputer.MetricSimilarityComputerBuilder newValue = Objects.requireNonNull(value, "similarityMetric");
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, newValue, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withDegreeCutoff(int value) {
        if (this.degreeCutoff == value) {
            return this;
        }
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, value, this.topK, this.topN, this.bottomK, this.bottomN, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withTopK(int value) {
        if (this.topK == value) {
            return this;
        }
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, value, this.topN, this.bottomK, this.bottomN, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withTopN(int value) {
        if (this.topN == value) {
            return this;
        }
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, value, this.bottomK, this.bottomN, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withBottomK(int value) {
        if (this.bottomK == value) {
            return this;
        }
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, value, this.bottomN, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withBottomN(int value) {
        if (this.bottomN == value) {
            return this;
        }
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, value, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withMutateProperty(String value) {
        String newValue = Objects.requireNonNull(value, "mutateProperty");
        if (this.mutateProperty.equals(newValue)) {
            return this;
        }
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, newValue, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withMutateRelationshipType(String value) {
        String newValue = Objects.requireNonNull(value, "mutateRelationshipType");
        if (this.mutateRelationshipType.equals(newValue)) {
            return this;
        }
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.mutateProperty, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNodeSimilarityMutateConfig && this.equalTo((ImmutableNodeSimilarityMutateConfig)another);
    }

    private boolean equalTo(ImmutableNodeSimilarityMutateConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.logProgress == another.logProgress && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && this.jobId.equals((Object)another.jobId) && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && Objects.equals(this.relationshipWeightProperty, another.relationshipWeightProperty) && this.hasRelationshipWeightProperty == another.hasRelationshipWeightProperty && Double.doubleToLongBits(this.similarityCutoff) == Double.doubleToLongBits(another.similarityCutoff) && this.similarityMetric.equals(another.similarityMetric) && this.degreeCutoff == another.degreeCutoff && this.topK == another.topK && this.topN == another.topN && this.bottomK == another.bottomK && this.bottomN == another.bottomN && this.normalizedK == another.normalizedK && this.normalizedN == another.normalizedN && this.isParallel == another.isParallel && this.hasTopK == another.hasTopK && this.hasTopN == another.hasTopN && this.computeToGraph == another.computeToGraph && this.mutateProperty.equals(another.mutateProperty) && this.mutateRelationshipType.equals(another.mutateRelationshipType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + Boolean.hashCode(this.logProgress);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + this.jobId.hashCode();
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + Objects.hashCode(this.relationshipWeightProperty);
        h += (h << 5) + Boolean.hashCode(this.hasRelationshipWeightProperty);
        h += (h << 5) + Double.hashCode(this.similarityCutoff);
        h += (h << 5) + this.similarityMetric.hashCode();
        h += (h << 5) + this.degreeCutoff;
        h += (h << 5) + this.topK;
        h += (h << 5) + this.topN;
        h += (h << 5) + this.bottomK;
        h += (h << 5) + this.bottomN;
        h += (h << 5) + this.normalizedK;
        h += (h << 5) + this.normalizedN;
        h += (h << 5) + Boolean.hashCode(this.isParallel);
        h += (h << 5) + Boolean.hashCode(this.hasTopK);
        h += (h << 5) + Boolean.hashCode(this.hasTopN);
        h += (h << 5) + Boolean.hashCode(this.computeToGraph);
        h += (h << 5) + this.mutateProperty.hashCode();
        h += (h << 5) + this.mutateRelationshipType.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("NodeSimilarityMutateConfig{");
        if (this.usernameOverride != null) {
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        if (builder.length() > 27) {
            builder.append(", ");
        }
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("logProgress=").append(this.logProgress);
        builder.append(", ");
        builder.append("concurrency=").append(this.concurrency);
        builder.append(", ");
        builder.append("minBatchSize=").append(this.minBatchSize);
        builder.append(", ");
        builder.append("jobId=").append(this.jobId);
        builder.append(", ");
        builder.append("relationshipTypes=").append(this.relationshipTypes);
        builder.append(", ");
        builder.append("nodeLabels=").append(this.nodeLabels);
        if (this.relationshipWeightProperty != null) {
            builder.append(", ");
            builder.append("relationshipWeightProperty=").append(this.relationshipWeightProperty);
        }
        builder.append(", ");
        builder.append("hasRelationshipWeightProperty=").append(this.hasRelationshipWeightProperty);
        builder.append(", ");
        builder.append("similarityCutoff=").append(this.similarityCutoff);
        builder.append(", ");
        builder.append("similarityMetric=").append(this.similarityMetric);
        builder.append(", ");
        builder.append("degreeCutoff=").append(this.degreeCutoff);
        builder.append(", ");
        builder.append("topK=").append(this.topK);
        builder.append(", ");
        builder.append("topN=").append(this.topN);
        builder.append(", ");
        builder.append("bottomK=").append(this.bottomK);
        builder.append(", ");
        builder.append("bottomN=").append(this.bottomN);
        builder.append(", ");
        builder.append("normalizedK=").append(this.normalizedK);
        builder.append(", ");
        builder.append("normalizedN=").append(this.normalizedN);
        builder.append(", ");
        builder.append("isParallel=").append(this.isParallel);
        builder.append(", ");
        builder.append("hasTopK=").append(this.hasTopK);
        builder.append(", ");
        builder.append("hasTopN=").append(this.hasTopN);
        builder.append(", ");
        builder.append("computeToGraph=").append(this.computeToGraph);
        builder.append(", ");
        builder.append("mutateProperty=").append(this.mutateProperty);
        builder.append(", ");
        builder.append("mutateRelationshipType=").append(this.mutateRelationshipType);
        return builder.append("}").toString();
    }

    public static NodeSimilarityMutateConfig of(int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, Optional<String> relationshipWeightProperty, double similarityCutoff, MetricSimilarityComputer.MetricSimilarityComputerBuilder similarityMetric, int degreeCutoff, int topK, int topN, int bottomK, int bottomN, String mutateProperty, String mutateRelationshipType) {
        return ImmutableNodeSimilarityMutateConfig.of(concurrency, minBatchSize, relationshipTypes, nodeLabels, relationshipWeightProperty, similarityCutoff, similarityMetric, degreeCutoff, topK, topN, bottomK, bottomN, mutateProperty, mutateRelationshipType);
    }

    public static NodeSimilarityMutateConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<String> relationshipWeightProperty, double similarityCutoff, MetricSimilarityComputer.MetricSimilarityComputerBuilder similarityMetric, int degreeCutoff, int topK, int topN, int bottomK, int bottomN, String mutateProperty, String mutateRelationshipType) {
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, relationshipWeightProperty, similarityCutoff, similarityMetric, degreeCutoff, topK, topN, bottomK, bottomN, mutateProperty, mutateRelationshipType));
    }

    public static NodeSimilarityMutateConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, String relationshipWeightProperty, double similarityCutoff, MetricSimilarityComputer.MetricSimilarityComputerBuilder similarityMetric, int degreeCutoff, int topK, int topN, int bottomK, int bottomN, String mutateProperty, String mutateRelationshipType) {
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, relationshipWeightProperty, similarityCutoff, similarityMetric, degreeCutoff, topK, topN, bottomK, bottomN, mutateProperty, mutateRelationshipType));
    }

    private static ImmutableNodeSimilarityMutateConfig validate(ImmutableNodeSimilarityMutateConfig instance) {
        instance.validate();
        instance.validateRelationshipWeightProperty();
        instance.validateConcurrency();
        return instance;
    }

    public static NodeSimilarityMutateConfig copyOf(NodeSimilarityMutateConfig instance) {
        if (instance instanceof ImmutableNodeSimilarityMutateConfig) {
            return (ImmutableNodeSimilarityMutateConfig)instance;
        }
        return ImmutableNodeSimilarityMutateConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="NodeSimilarityMutateConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_MUTATE_PROPERTY = 1L;
        private static final long INIT_BIT_MUTATE_RELATIONSHIP_TYPE = 2L;
        private static final long OPT_BIT_SUDO = 1L;
        private static final long OPT_BIT_LOG_PROGRESS = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 8L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 16L;
        private static final long OPT_BIT_NODE_LABELS = 32L;
        private static final long OPT_BIT_SIMILARITY_CUTOFF = 64L;
        private static final long OPT_BIT_DEGREE_CUTOFF = 128L;
        private static final long OPT_BIT_TOP_K = 256L;
        private static final long OPT_BIT_TOP_N = 512L;
        private static final long OPT_BIT_BOTTOM_K = 1024L;
        private static final long OPT_BIT_BOTTOM_N = 2048L;
        private long initBits = 3L;
        private long optBits;
        private String usernameOverride;
        private boolean sudo;
        private boolean logProgress;
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        private JobId jobId;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        private String relationshipWeightProperty;
        private double similarityCutoff;
        private MetricSimilarityComputer.MetricSimilarityComputerBuilder similarityMetric;
        private int degreeCutoff;
        private int topK;
        private int topN;
        private int bottomK;
        private int bottomN;
        private String mutateProperty;
        private String mutateRelationshipType;

        private Builder() {
        }

        public final Builder from(NodeSimilarityBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RelationshipWeightConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(JobIdConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MutatePropertyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MutateRelationshipConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(NodeSimilarityMutateConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional relationshipWeightPropertyOptional;
            NodeSimilarityBaseConfig instance;
            if (object instanceof NodeSimilarityBaseConfig) {
                instance = (NodeSimilarityBaseConfig)object;
                this.topK(instance.topK());
                this.similarityMetric(instance.similarityMetric());
                this.bottomK(instance.bottomK());
                this.degreeCutoff(instance.degreeCutoff());
                this.bottomN(instance.bottomN());
                this.similarityCutoff(instance.similarityCutoff());
                this.topN(instance.topN());
            }
            if (object instanceof RelationshipWeightConfig && (relationshipWeightPropertyOptional = (instance = (RelationshipWeightConfig)object).relationshipWeightProperty()).isPresent()) {
                this.relationshipWeightProperty(relationshipWeightPropertyOptional);
            }
            if (object instanceof JobIdConfig) {
                instance = (JobIdConfig)object;
                this.jobId(instance.jobId());
            }
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                this.minBatchSize(instance.minBatchSize());
                this.concurrency(instance.concurrency());
            }
            if (object instanceof MutatePropertyConfig) {
                instance = (MutatePropertyConfig)object;
                this.mutateProperty(instance.mutateProperty());
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                this.logProgress(instance.logProgress());
                this.sudo(instance.sudo());
                Optional usernameOverrideOptional = instance.usernameOverride();
                if (usernameOverrideOptional.isPresent()) {
                    this.usernameOverride(usernameOverrideOptional);
                }
                this.configKeys(instance.configKeys());
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                this.addAllRelationshipTypes(instance.relationshipTypes());
                this.addAllNodeLabels(instance.nodeLabels());
            }
            if (object instanceof MutateRelationshipConfig) {
                instance = (MutateRelationshipConfig)object;
                this.mutateRelationshipType(instance.mutateRelationshipType());
            }
        }

        public final Builder usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            return this;
        }

        public final Builder usernameOverride(Optional<String> usernameOverride) {
            this.usernameOverride = usernameOverride.orElse(null);
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 1L;
            return this;
        }

        public final Builder logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder jobId(JobId jobId) {
            this.jobId = Objects.requireNonNull(jobId, "jobId");
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder relationshipWeightProperty(String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            return this;
        }

        public final Builder relationshipWeightProperty(Optional<String> relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty.orElse(null);
            return this;
        }

        public final Builder similarityCutoff(double similarityCutoff) {
            this.similarityCutoff = similarityCutoff;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder similarityMetric(MetricSimilarityComputer.MetricSimilarityComputerBuilder similarityMetric) {
            this.similarityMetric = Objects.requireNonNull(similarityMetric, "similarityMetric");
            return this;
        }

        public final Builder degreeCutoff(int degreeCutoff) {
            this.degreeCutoff = degreeCutoff;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder topK(int topK) {
            this.topK = topK;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder topN(int topN) {
            this.topN = topN;
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder bottomK(int bottomK) {
            this.bottomK = bottomK;
            this.optBits |= 0x400L;
            return this;
        }

        public final Builder bottomN(int bottomN) {
            this.bottomN = bottomN;
            this.optBits |= 0x800L;
            return this;
        }

        public final Builder mutateProperty(String mutateProperty) {
            this.mutateProperty = Objects.requireNonNull(mutateProperty, "mutateProperty");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder mutateRelationshipType(String mutateRelationshipType) {
            this.mutateRelationshipType = Objects.requireNonNull(mutateRelationshipType, "mutateRelationshipType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.logProgress = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            this.jobId = null;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.relationshipWeightProperty = null;
            this.similarityCutoff = 0.0;
            this.similarityMetric = null;
            this.degreeCutoff = 0;
            this.topK = 0;
            this.topN = 0;
            this.bottomK = 0;
            this.bottomN = 0;
            this.mutateProperty = null;
            this.mutateRelationshipType = null;
            return this;
        }

        public NodeSimilarityMutateConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this));
        }

        private boolean sudoIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean logProgressIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean similarityCutoffIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean degreeCutoffIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean topKIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean topNIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean bottomKIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private boolean bottomNIsSet() {
            return (this.optBits & 0x800L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("mutateProperty");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("mutateRelationshipType");
            }
            return "Cannot build NodeSimilarityMutateConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="NodeSimilarityMutateConfig", generator="Immutables")
    private final class InitShim {
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte logProgressBuildStage = 0;
        private boolean logProgress;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte jobIdBuildStage = 0;
        private JobId jobId;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte hasRelationshipWeightPropertyBuildStage = 0;
        private boolean hasRelationshipWeightProperty;
        private byte similarityCutoffBuildStage = 0;
        private double similarityCutoff;
        private byte similarityMetricBuildStage = 0;
        private MetricSimilarityComputer.MetricSimilarityComputerBuilder similarityMetric;
        private byte degreeCutoffBuildStage = 0;
        private int degreeCutoff;
        private byte topKBuildStage = 0;
        private int topK;
        private byte topNBuildStage = 0;
        private int topN;
        private byte bottomKBuildStage = 0;
        private int bottomK;
        private byte bottomNBuildStage = 0;
        private int bottomN;
        private byte normalizedKBuildStage = 0;
        private int normalizedK;
        private byte normalizedNBuildStage = 0;
        private int normalizedN;
        private byte isParallelBuildStage = 0;
        private boolean isParallel;
        private byte hasTopKBuildStage = 0;
        private boolean hasTopK;
        private byte hasTopNBuildStage = 0;
        private boolean hasTopN;
        private byte computeToGraphBuildStage = 0;
        private boolean computeToGraph;

        private InitShim() {
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableNodeSimilarityMutateConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        boolean logProgress() {
            if (this.logProgressBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.logProgressBuildStage == 0) {
                this.logProgressBuildStage = (byte)-1;
                this.logProgress = ImmutableNodeSimilarityMutateConfig.this.logProgressInitialize();
                this.logProgressBuildStage = 1;
            }
            return this.logProgress;
        }

        void logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.logProgressBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableNodeSimilarityMutateConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableNodeSimilarityMutateConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableNodeSimilarityMutateConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutableNodeSimilarityMutateConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        JobId jobId() {
            if (this.jobIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.jobIdBuildStage == 0) {
                this.jobIdBuildStage = (byte)-1;
                this.jobId = Objects.requireNonNull(ImmutableNodeSimilarityMutateConfig.this.jobIdInitialize(), "jobId");
                this.jobIdBuildStage = 1;
            }
            return this.jobId;
        }

        void jobId(JobId jobId) {
            this.jobId = jobId;
            this.jobIdBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableNodeSimilarityMutateConfig.createUnmodifiableList(false, ImmutableNodeSimilarityMutateConfig.createSafeList(ImmutableNodeSimilarityMutateConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableNodeSimilarityMutateConfig.createUnmodifiableList(false, ImmutableNodeSimilarityMutateConfig.createSafeList(ImmutableNodeSimilarityMutateConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        boolean hasRelationshipWeightProperty() {
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasRelationshipWeightPropertyBuildStage == 0) {
                this.hasRelationshipWeightPropertyBuildStage = (byte)-1;
                this.hasRelationshipWeightProperty = ImmutableNodeSimilarityMutateConfig.this.hasRelationshipWeightPropertyInitialize();
                this.hasRelationshipWeightPropertyBuildStage = 1;
            }
            return this.hasRelationshipWeightProperty;
        }

        double similarityCutoff() {
            if (this.similarityCutoffBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.similarityCutoffBuildStage == 0) {
                this.similarityCutoffBuildStage = (byte)-1;
                this.similarityCutoff = ImmutableNodeSimilarityMutateConfig.this.similarityCutoffInitialize();
                this.similarityCutoffBuildStage = 1;
            }
            return this.similarityCutoff;
        }

        void similarityCutoff(double similarityCutoff) {
            this.similarityCutoff = similarityCutoff;
            this.similarityCutoffBuildStage = 1;
        }

        MetricSimilarityComputer.MetricSimilarityComputerBuilder similarityMetric() {
            if (this.similarityMetricBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.similarityMetricBuildStage == 0) {
                this.similarityMetricBuildStage = (byte)-1;
                this.similarityMetric = Objects.requireNonNull(ImmutableNodeSimilarityMutateConfig.this.similarityMetricInitialize(), "similarityMetric");
                this.similarityMetricBuildStage = 1;
            }
            return this.similarityMetric;
        }

        void similarityMetric(MetricSimilarityComputer.MetricSimilarityComputerBuilder similarityMetric) {
            this.similarityMetric = similarityMetric;
            this.similarityMetricBuildStage = 1;
        }

        int degreeCutoff() {
            if (this.degreeCutoffBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.degreeCutoffBuildStage == 0) {
                this.degreeCutoffBuildStage = (byte)-1;
                this.degreeCutoff = ImmutableNodeSimilarityMutateConfig.this.degreeCutoffInitialize();
                this.degreeCutoffBuildStage = 1;
            }
            return this.degreeCutoff;
        }

        void degreeCutoff(int degreeCutoff) {
            this.degreeCutoff = degreeCutoff;
            this.degreeCutoffBuildStage = 1;
        }

        int topK() {
            if (this.topKBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.topKBuildStage == 0) {
                this.topKBuildStage = (byte)-1;
                this.topK = ImmutableNodeSimilarityMutateConfig.this.topKInitialize();
                this.topKBuildStage = 1;
            }
            return this.topK;
        }

        void topK(int topK) {
            this.topK = topK;
            this.topKBuildStage = 1;
        }

        int topN() {
            if (this.topNBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.topNBuildStage == 0) {
                this.topNBuildStage = (byte)-1;
                this.topN = ImmutableNodeSimilarityMutateConfig.this.topNInitialize();
                this.topNBuildStage = 1;
            }
            return this.topN;
        }

        void topN(int topN) {
            this.topN = topN;
            this.topNBuildStage = 1;
        }

        int bottomK() {
            if (this.bottomKBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.bottomKBuildStage == 0) {
                this.bottomKBuildStage = (byte)-1;
                this.bottomK = ImmutableNodeSimilarityMutateConfig.this.bottomKInitialize();
                this.bottomKBuildStage = 1;
            }
            return this.bottomK;
        }

        void bottomK(int bottomK) {
            this.bottomK = bottomK;
            this.bottomKBuildStage = 1;
        }

        int bottomN() {
            if (this.bottomNBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.bottomNBuildStage == 0) {
                this.bottomNBuildStage = (byte)-1;
                this.bottomN = ImmutableNodeSimilarityMutateConfig.this.bottomNInitialize();
                this.bottomNBuildStage = 1;
            }
            return this.bottomN;
        }

        void bottomN(int bottomN) {
            this.bottomN = bottomN;
            this.bottomNBuildStage = 1;
        }

        int normalizedK() {
            if (this.normalizedKBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.normalizedKBuildStage == 0) {
                this.normalizedKBuildStage = (byte)-1;
                this.normalizedK = ImmutableNodeSimilarityMutateConfig.this.normalizedKInitialize();
                this.normalizedKBuildStage = 1;
            }
            return this.normalizedK;
        }

        int normalizedN() {
            if (this.normalizedNBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.normalizedNBuildStage == 0) {
                this.normalizedNBuildStage = (byte)-1;
                this.normalizedN = ImmutableNodeSimilarityMutateConfig.this.normalizedNInitialize();
                this.normalizedNBuildStage = 1;
            }
            return this.normalizedN;
        }

        boolean isParallel() {
            if (this.isParallelBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isParallelBuildStage == 0) {
                this.isParallelBuildStage = (byte)-1;
                this.isParallel = ImmutableNodeSimilarityMutateConfig.this.isParallelInitialize();
                this.isParallelBuildStage = 1;
            }
            return this.isParallel;
        }

        boolean hasTopK() {
            if (this.hasTopKBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasTopKBuildStage == 0) {
                this.hasTopKBuildStage = (byte)-1;
                this.hasTopK = ImmutableNodeSimilarityMutateConfig.this.hasTopKInitialize();
                this.hasTopKBuildStage = 1;
            }
            return this.hasTopK;
        }

        boolean hasTopN() {
            if (this.hasTopNBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasTopNBuildStage == 0) {
                this.hasTopNBuildStage = (byte)-1;
                this.hasTopN = ImmutableNodeSimilarityMutateConfig.this.hasTopNInitialize();
                this.hasTopNBuildStage = 1;
            }
            return this.hasTopN;
        }

        boolean computeToGraph() {
            if (this.computeToGraphBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.computeToGraphBuildStage == 0) {
                this.computeToGraphBuildStage = (byte)-1;
                this.computeToGraph = ImmutableNodeSimilarityMutateConfig.this.computeToGraphInitialize();
                this.computeToGraphBuildStage = 1;
            }
            return this.computeToGraph;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.logProgressBuildStage == -1) {
                attributes.add("logProgress");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.jobIdBuildStage == -1) {
                attributes.add("jobId");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                attributes.add("hasRelationshipWeightProperty");
            }
            if (this.similarityCutoffBuildStage == -1) {
                attributes.add("similarityCutoff");
            }
            if (this.similarityMetricBuildStage == -1) {
                attributes.add("similarityMetric");
            }
            if (this.degreeCutoffBuildStage == -1) {
                attributes.add("degreeCutoff");
            }
            if (this.topKBuildStage == -1) {
                attributes.add("topK");
            }
            if (this.topNBuildStage == -1) {
                attributes.add("topN");
            }
            if (this.bottomKBuildStage == -1) {
                attributes.add("bottomK");
            }
            if (this.bottomNBuildStage == -1) {
                attributes.add("bottomN");
            }
            if (this.normalizedKBuildStage == -1) {
                attributes.add("normalizedK");
            }
            if (this.normalizedNBuildStage == -1) {
                attributes.add("normalizedN");
            }
            if (this.isParallelBuildStage == -1) {
                attributes.add("isParallel");
            }
            if (this.hasTopKBuildStage == -1) {
                attributes.add("hasTopK");
            }
            if (this.hasTopNBuildStage == -1) {
                attributes.add("hasTopN");
            }
            if (this.computeToGraphBuildStage == -1) {
                attributes.add("computeToGraph");
            }
            return "Cannot build NodeSimilarityMutateConfig, attribute initializers form cycle " + attributes;
        }
    }
}

