/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.nodesim;

import java.util.Locale;
import org.neo4j.gds.similarity.nodesim.JaccardSimilarityComputer;
import org.neo4j.gds.similarity.nodesim.NodeSimilarityMetric;
import org.neo4j.gds.similarity.nodesim.OverlapSimilarityComputer;
import org.neo4j.gds.utils.StringFormatting;

public interface MetricSimilarityComputer {
    public double computeSimilarity(long[] var1, long[] var2);

    public double computeWeightedSimilarity(long[] var1, long[] var2, double[] var3, double[] var4);

    public static MetricSimilarityComputerBuilder parse(Object userInput) {
        if (userInput instanceof MetricSimilarityComputerBuilder) {
            return (MetricSimilarityComputerBuilder)userInput;
        }
        if (userInput instanceof String) {
            return MetricSimilarityComputer.create(MetricSimilarityComputer.valueOf((String)userInput));
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Unsupported input type: Expected String but received %s.", (Object[])new Object[]{userInput.getClass().getSimpleName()}));
    }

    public static String render(MetricSimilarityComputerBuilder input) {
        return input.render();
    }

    private static NodeSimilarityMetric valueOf(String userInput) {
        String userInputInCaps = userInput.toUpperCase(Locale.ROOT);
        if (userInputInCaps.equals("JACCARD")) {
            return NodeSimilarityMetric.JACCARD;
        }
        if (userInputInCaps.equals("OVERLAP")) {
            return NodeSimilarityMetric.OVERLAP;
        }
        throw new IllegalArgumentException(userInput + " is not a valid metric. Available metrics include Jaccard and Overlap");
    }

    private static MetricSimilarityComputerBuilder create(NodeSimilarityMetric metric) {
        if (metric == NodeSimilarityMetric.JACCARD) {
            return new JaccardSimilarityComputer.Builder();
        }
        return new OverlapSimilarityComputer.Builder();
    }

    public static interface MetricSimilarityComputerBuilder {
        public MetricSimilarityComputer build(double var1);

        public String render();
    }
}

