/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.nodesim;

import com.carrotsearch.hppc.BitSet;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.mem.MemoryRange;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.mem.MemoryUsage;
import org.neo4j.gds.similarity.SimilarityGraphBuilder;
import org.neo4j.gds.similarity.nodesim.MetricSimilarityComputer;
import org.neo4j.gds.similarity.nodesim.NodeSimilarity;
import org.neo4j.gds.similarity.nodesim.NodeSimilarityBaseConfig;
import org.neo4j.gds.similarity.nodesim.TopKMap;
import org.neo4j.gds.similarity.nodesim.TopNList;

public class NodeSimilarityFactory<CONFIG extends NodeSimilarityBaseConfig>
extends GraphAlgorithmFactory<NodeSimilarity, CONFIG> {
    public String taskName() {
        return "NodeSimilarity";
    }

    public NodeSimilarity build(Graph graph, CONFIG configuration, ProgressTracker progressTracker) {
        MetricSimilarityComputer similarityComputer = configuration.similarityMetric().build(configuration.similarityCutoff());
        return new NodeSimilarity(graph, (NodeSimilarityBaseConfig)configuration, similarityComputer, configuration.concurrency(), Pools.DEFAULT, progressTracker);
    }

    public MemoryEstimation memoryEstimation(CONFIG config) {
        int topN = Math.abs(config.normalizedN());
        int topK = Math.abs(config.normalizedK());
        MemoryEstimations.Builder builder = MemoryEstimations.builder((String)NodeSimilarity.class.getSimpleName()).perNode("node filter", nodeCount -> MemoryUsage.sizeOfLongArray((long)BitSet.bits2words((long)nodeCount))).add("vectors", MemoryEstimations.setup((String)"", (dimensions, concurrency) -> {
            int averageDegree = dimensions.nodeCount() == 0L ? 0 : Math.toIntExact(dimensions.relCountUpperBound() / dimensions.nodeCount());
            long averageVectorSize = MemoryUsage.sizeOfLongArray((long)averageDegree);
            return MemoryEstimations.builder(HugeObjectArray.class).perNode("array", nodeCount -> nodeCount * averageVectorSize).build();
        })).add("weights", MemoryEstimations.setup((String)"", (dimensions, concurrency) -> {
            int averageDegree = dimensions.nodeCount() == 0L ? 0 : Math.toIntExact(dimensions.relCountUpperBound() / dimensions.nodeCount());
            long averageVectorSize = MemoryUsage.sizeOfDoubleArray((long)averageDegree);
            return MemoryEstimations.builder(HugeObjectArray.class).rangePerNode("array", nodeCount -> MemoryRange.of((long)0L, (long)(nodeCount * averageVectorSize))).build();
        }));
        if (config.computeToGraph() && !config.hasTopK()) {
            builder.add("similarity graph", SimilarityGraphBuilder.memoryEstimation(topK, topN));
        }
        if (config.hasTopK()) {
            builder.add("topK map", MemoryEstimations.setup((String)"", (dimensions, concurrency) -> TopKMap.memoryEstimation(dimensions.nodeCount(), topK)));
        }
        if (config.hasTopN()) {
            builder.add("topN list", MemoryEstimations.setup((String)"", (dimensions, concurrency) -> TopNList.memoryEstimation(dimensions.nodeCount(), topN)));
        }
        return builder.build();
    }

    public Task progressTask(Graph graph, CONFIG config) {
        return Tasks.task((String)this.taskName(), (Task)Tasks.leaf((String)"prepare", (long)graph.relationshipCount()), (Task[])new Task[]{Tasks.leaf((String)"compare node pairs")});
    }
}

