/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.nodesim;

import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.DoubleArrayList;
import com.carrotsearch.hppc.LongArrayList;
import java.util.Arrays;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.RelationshipConsumer;
import org.neo4j.gds.api.RelationshipWithPropertyConsumer;
import org.neo4j.gds.core.utils.TwoArraysSort;
import org.neo4j.gds.utils.StringFormatting;

abstract class VectorComputer {
    final Graph graph;
    LongArrayList targetIds;
    private long lastTarget = -1L;
    private static final ArraySizingStrategy ARRAY_SIZING_STRATEGY = (currentBufferLength, elementsCount, degree) -> elementsCount + degree;

    VectorComputer(Graph graph) {
        this.graph = graph;
    }

    abstract void forEachRelationship(long var1);

    public abstract double[] getWeights();

    void reset(int degree) {
        this.lastTarget = -1L;
        this.targetIds = new LongArrayList(degree, ARRAY_SIZING_STRATEGY);
    }

    boolean consumeRelationship(long source, long target) {
        boolean consume = false;
        if (source != target && this.lastTarget != target) {
            consume = true;
        }
        this.lastTarget = target;
        return consume;
    }

    static VectorComputer of(Graph graph, boolean weighted) {
        return weighted ? new WeightedVectorComputer(graph) : new UnweightedVectorComputer(graph);
    }

    abstract void sortTargetIds();

    static final class WeightedVectorComputer
    extends VectorComputer
    implements RelationshipWithPropertyConsumer {
        DoubleArrayList weights;

        WeightedVectorComputer(Graph graph) {
            super(graph);
        }

        public boolean accept(long source, long target, double property) {
            if (this.consumeRelationship(source, target)) {
                this.targetIds.add(target);
                this.weights.add(property);
            }
            return true;
        }

        @Override
        public double[] getWeights() {
            return this.weights.buffer;
        }

        @Override
        void forEachRelationship(long node) {
            this.graph.forEachRelationship(node, 1.0, (RelationshipWithPropertyConsumer)this);
        }

        @Override
        void reset(int degree) {
            super.reset(degree);
            this.weights = new DoubleArrayList(degree, ARRAY_SIZING_STRATEGY);
        }

        @Override
        void sortTargetIds() {
            int length = this.weights.buffer.length;
            TwoArraysSort.sortDoubleArrayByLongValues((long[])this.targetIds.buffer, (double[])this.weights.buffer, (int)length);
        }
    }

    static final class UnweightedVectorComputer
    extends VectorComputer
    implements RelationshipConsumer {
        UnweightedVectorComputer(Graph graph) {
            super(graph);
        }

        public boolean accept(long source, long target) {
            if (this.consumeRelationship(source, target)) {
                this.targetIds.add(target);
            }
            return true;
        }

        @Override
        public double[] getWeights() {
            throw new UnsupportedOperationException(StringFormatting.formatWithLocale((String)"Method `getWeights` is not supported for %s", (Object[])new Object[]{this.getClass().getSimpleName()}));
        }

        @Override
        void sortTargetIds() {
            Arrays.sort(this.targetIds.buffer);
        }

        @Override
        void forEachRelationship(long node) {
            this.graph.forEachRelationship(node, (RelationshipConsumer)this);
        }
    }
}

