/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.spanningtree;

import com.carrotsearch.hppc.BitSet;
import java.util.function.DoubleUnaryOperator;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.queue.HugeLongPriorityQueue;
import org.neo4j.gds.spanningtree.SpanningTree;

public class Prim
extends Algorithm<SpanningTree> {
    public static final DoubleUnaryOperator MAX_OPERATOR = w -> -w;
    public static final DoubleUnaryOperator MIN_OPERATOR = w -> w;
    private final Graph graph;
    private final long nodeCount;
    private final DoubleUnaryOperator minMax;
    private final long startNodeId;
    private SpanningTree spanningTree;

    public Prim(Graph graph, DoubleUnaryOperator minMax, long startNodeId, ProgressTracker progressTracker) {
        super(progressTracker);
        this.graph = graph;
        this.nodeCount = graph.nodeCount();
        this.minMax = minMax;
        this.startNodeId = startNodeId;
    }

    public SpanningTree compute() {
        this.progressTracker.beginSubTask("SpanningTree");
        HugeLongArray parent = HugeLongArray.newArray((long)this.graph.nodeCount());
        HugeDoubleArray costToParent = HugeDoubleArray.newArray((long)this.graph.nodeCount());
        HugeLongPriorityQueue queue = HugeLongPriorityQueue.min((long)this.nodeCount);
        BitSet visited = new BitSet(this.nodeCount);
        parent.fill(-1L);
        double totalWeight = 0.0;
        queue.add(this.startNodeId, 0.0);
        long effectiveNodeCount = 0L;
        while (!queue.isEmpty() && this.terminationFlag.running()) {
            long node = queue.top();
            double cost = queue.cost(node);
            totalWeight += cost;
            queue.pop();
            costToParent.set(node, this.minMax.applyAsDouble(cost));
            if (visited.get(node)) continue;
            ++effectiveNodeCount;
            visited.set(node);
            this.graph.forEachRelationship(node, 0.0, (s, t, w) -> {
                if (visited.get(t)) {
                    return true;
                }
                double weight = this.minMax.applyAsDouble(w);
                if (!queue.containsElement(t)) {
                    queue.add(t, weight);
                    parent.set(t, s);
                } else if (Double.compare(weight, queue.cost(t)) < 0) {
                    queue.set(t, weight);
                    parent.set(t, s);
                }
                return true;
            });
            this.progressTracker.logProgress((long)this.graph.degree(node));
        }
        this.spanningTree = new SpanningTree(this.startNodeId, this.nodeCount, effectiveNodeCount, parent, costToParent, this.minMax.applyAsDouble(totalWeight));
        this.progressTracker.endSubTask("SpanningTree");
        return this.spanningTree;
    }

    public SpanningTree getSpanningTree() {
        return this.spanningTree;
    }

    public void release() {
        this.spanningTree = null;
    }
}

