/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.spanningtree;

import java.util.Arrays;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphAdapter;
import org.neo4j.gds.api.RelationshipConsumer;
import org.neo4j.gds.api.RelationshipWithPropertyConsumer;
import org.neo4j.gds.spanningtree.SpanningTree;

public class SpanningGraph
extends GraphAdapter {
    private final SpanningTree spanningTree;

    public SpanningGraph(Graph graph, SpanningTree spanningTree) {
        super(graph);
        this.spanningTree = spanningTree;
    }

    public int degree(long nodeId) {
        if (this.spanningTree.parent.get(nodeId) < 0L) {
            return Math.toIntExact(Arrays.stream(this.spanningTree.parent.toArray()).filter(i -> i < 0L).count());
        }
        return 1;
    }

    public void forEachRelationship(long nodeId, RelationshipConsumer consumer) {
        this.forEachRelationship(nodeId, 0.0, (sourceNodeId, targetNodeId, property) -> consumer.accept(sourceNodeId, targetNodeId));
    }

    public void forEachRelationship(long nodeId, double fallbackValue, RelationshipWithPropertyConsumer consumer) {
        long parent = this.spanningTree.parent.get(nodeId);
        if (parent >= 0L) {
            consumer.accept(parent, nodeId, this.spanningTree.costToParent(nodeId));
        }
    }

    public boolean exists(long sourceNodeId, long targetNodeId) {
        return this.spanningTree.parent.get(sourceNodeId) != -1L || this.spanningTree.parent.get(targetNodeId) != -1L;
    }

    public Graph concurrentCopy() {
        return this;
    }
}

