/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.spanningtree;

import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.neo4j.gds.api.RelationshipWithPropertyConsumer;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;

public class SpanningTree {
    final long head;
    final long nodeCount;
    final long effectiveNodeCount;
    final HugeDoubleArray costToParent;
    final HugeLongArray parent;
    final double totalWeight;

    public SpanningTree(long head, long nodeCount, long effectiveNodeCount, HugeLongArray parent, HugeDoubleArray costToParent, double totalWeight) {
        this.head = head;
        this.nodeCount = nodeCount;
        this.effectiveNodeCount = effectiveNodeCount;
        this.parent = parent;
        this.costToParent = costToParent;
        this.totalWeight = totalWeight;
    }

    public long effectiveNodeCount() {
        return this.effectiveNodeCount;
    }

    public double totalWeight() {
        return this.totalWeight;
    }

    public HugeLongArray parentArray() {
        return this.parent;
    }

    public long parent(long nodeId) {
        return this.parent.get(nodeId);
    }

    public double costToParent(long nodeId) {
        return this.costToParent.get(nodeId);
    }

    public void forEach(RelationshipWithPropertyConsumer consumer) {
        int i = 0;
        while ((long)i < this.nodeCount) {
            long parent = this.parent.get((long)i);
            double cost = this.costToParent(i);
            if (parent != -1L && !consumer.accept(parent, (long)i, cost)) {
                return;
            }
            ++i;
        }
    }

    public long head(long node) {
        long p = node;
        while (-1L != this.parent.get(p)) {
            p = this.parent.get(p);
        }
        return p;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpanningTree that = (SpanningTree)o;
        return new EqualsBuilder().append(this.head, that.head).append(this.nodeCount, that.nodeCount).append(this.effectiveNodeCount, that.effectiveNodeCount).append((Object)this.parent, (Object)that.parent).isEquals();
    }

    public int hashCode() {
        int result = Objects.hash(this.head, this.nodeCount, this.effectiveNodeCount);
        result = 31 * result + this.parent.hashCode();
        return result;
    }
}

