/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.spanningtree;

import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.core.utils.queue.HugeLongPriorityQueue;
import org.neo4j.gds.mem.MemoryUsage;
import org.neo4j.gds.spanningtree.Prim;
import org.neo4j.gds.spanningtree.SpanningTreeBaseConfig;

public class SpanningTreeAlgorithmFactory<CONFIG extends SpanningTreeBaseConfig>
extends GraphAlgorithmFactory<Prim, CONFIG> {
    public Prim build(Graph graphOrGraphStore, CONFIG configuration, ProgressTracker progressTracker) {
        if (!graphOrGraphStore.schema().isUndirected()) {
            throw new IllegalArgumentException("The Spanning Tree algorithm works only with undirected graphs. Please orient the edges properly");
        }
        return new Prim(graphOrGraphStore, configuration.objective(), graphOrGraphStore.toMappedNodeId(configuration.sourceNode()), progressTracker);
    }

    public String taskName() {
        return "SpanningTree";
    }

    public MemoryEstimation memoryEstimation(CONFIG config) {
        return MemoryEstimations.builder(Prim.class).perNode("Parent array", HugeLongArray::memoryEstimation).perNode("Parent cost array", HugeDoubleArray::memoryEstimation).add("Priority queue", HugeLongPriorityQueue.memoryEstimation()).perNode("visited", MemoryUsage::sizeOfBitset).build();
    }

    public Task progressTask(Graph graph, CONFIG config) {
        return Tasks.leaf((String)this.taskName(), (long)graph.relationshipCount());
    }
}

