/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.spanningtree;

import java.util.List;
import java.util.Locale;
import java.util.function.DoubleUnaryOperator;
import org.neo4j.gds.spanningtree.Prim;
import org.neo4j.gds.utils.StringFormatting;

public class SpanningTreeCompanion {
    public static DoubleUnaryOperator parse(Object input) {
        if (input instanceof String) {
            String inputString = StringFormatting.toUpperCaseWithLocale((String)((String)input));
            if (inputString.equals("MAXIMUM")) {
                return Prim.MAX_OPERATOR;
            }
            if (inputString.equals("MINIMUM")) {
                return Prim.MIN_OPERATOR;
            }
            throw new IllegalArgumentException(String.format(Locale.getDefault(), "Input value `%s` for parameter `objective` is not supported. Must be one of: %s.", input, List.of("maximum", "minimum")));
        }
        if (input instanceof DoubleUnaryOperator) {
            DoubleUnaryOperator inputOperator = (DoubleUnaryOperator)input;
            if (inputOperator.equals(Prim.MAX_OPERATOR) || inputOperator.equals(Prim.MIN_OPERATOR)) {
                return inputOperator;
            }
            throw new IllegalArgumentException(String.format(Locale.getDefault(), "Input value for parameter `objective` is not supported. Must be one of: %s.", List.of("maximum", "minimum")));
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Expected a String. Got %s.", (Object[])new Object[]{input.getClass().getSimpleName()}));
    }

    public static String toString(DoubleUnaryOperator doubleUnaryOperator) {
        if (doubleUnaryOperator.equals(Prim.MAX_OPERATOR)) {
            return "maximum";
        }
        return "minimum";
    }
}

