/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.steiner;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.steiner.SteinerTreeResult;

@Generated(from="SteinerTreeResult", generator="Immutables")
public final class ImmutableSteinerTreeResult
implements SteinerTreeResult {
    private final HugeLongArray parentArray;
    private final HugeDoubleArray relationshipToParentCost;
    private final double totalCost;
    private final long effectiveNodeCount;
    private final long effectiveTargetNodesCount;

    private ImmutableSteinerTreeResult(HugeLongArray parentArray, HugeDoubleArray relationshipToParentCost, double totalCost, long effectiveNodeCount, long effectiveTargetNodesCount) {
        this.parentArray = Objects.requireNonNull(parentArray, "parentArray");
        this.relationshipToParentCost = Objects.requireNonNull(relationshipToParentCost, "relationshipToParentCost");
        this.totalCost = totalCost;
        this.effectiveNodeCount = effectiveNodeCount;
        this.effectiveTargetNodesCount = effectiveTargetNodesCount;
    }

    private ImmutableSteinerTreeResult(ImmutableSteinerTreeResult original, HugeLongArray parentArray, HugeDoubleArray relationshipToParentCost, double totalCost, long effectiveNodeCount, long effectiveTargetNodesCount) {
        this.parentArray = parentArray;
        this.relationshipToParentCost = relationshipToParentCost;
        this.totalCost = totalCost;
        this.effectiveNodeCount = effectiveNodeCount;
        this.effectiveTargetNodesCount = effectiveTargetNodesCount;
    }

    @Override
    public HugeLongArray parentArray() {
        return this.parentArray;
    }

    @Override
    public HugeDoubleArray relationshipToParentCost() {
        return this.relationshipToParentCost;
    }

    @Override
    public double totalCost() {
        return this.totalCost;
    }

    @Override
    public long effectiveNodeCount() {
        return this.effectiveNodeCount;
    }

    @Override
    public long effectiveTargetNodesCount() {
        return this.effectiveTargetNodesCount;
    }

    public final ImmutableSteinerTreeResult withParentArray(HugeLongArray value) {
        if (this.parentArray == value) {
            return this;
        }
        HugeLongArray newValue = Objects.requireNonNull(value, "parentArray");
        return new ImmutableSteinerTreeResult(this, newValue, this.relationshipToParentCost, this.totalCost, this.effectiveNodeCount, this.effectiveTargetNodesCount);
    }

    public final ImmutableSteinerTreeResult withRelationshipToParentCost(HugeDoubleArray value) {
        if (this.relationshipToParentCost == value) {
            return this;
        }
        HugeDoubleArray newValue = Objects.requireNonNull(value, "relationshipToParentCost");
        return new ImmutableSteinerTreeResult(this, this.parentArray, newValue, this.totalCost, this.effectiveNodeCount, this.effectiveTargetNodesCount);
    }

    public final ImmutableSteinerTreeResult withTotalCost(double value) {
        if (Double.doubleToLongBits(this.totalCost) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableSteinerTreeResult(this, this.parentArray, this.relationshipToParentCost, value, this.effectiveNodeCount, this.effectiveTargetNodesCount);
    }

    public final ImmutableSteinerTreeResult withEffectiveNodeCount(long value) {
        if (this.effectiveNodeCount == value) {
            return this;
        }
        return new ImmutableSteinerTreeResult(this, this.parentArray, this.relationshipToParentCost, this.totalCost, value, this.effectiveTargetNodesCount);
    }

    public final ImmutableSteinerTreeResult withEffectiveTargetNodesCount(long value) {
        if (this.effectiveTargetNodesCount == value) {
            return this;
        }
        return new ImmutableSteinerTreeResult(this, this.parentArray, this.relationshipToParentCost, this.totalCost, this.effectiveNodeCount, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSteinerTreeResult && this.equalTo((ImmutableSteinerTreeResult)another);
    }

    private boolean equalTo(ImmutableSteinerTreeResult another) {
        return this.parentArray.equals(another.parentArray) && this.relationshipToParentCost.equals(another.relationshipToParentCost) && Double.doubleToLongBits(this.totalCost) == Double.doubleToLongBits(another.totalCost) && this.effectiveNodeCount == another.effectiveNodeCount && this.effectiveTargetNodesCount == another.effectiveTargetNodesCount;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.parentArray.hashCode();
        h += (h << 5) + this.relationshipToParentCost.hashCode();
        h += (h << 5) + Double.hashCode(this.totalCost);
        h += (h << 5) + Long.hashCode(this.effectiveNodeCount);
        h += (h << 5) + Long.hashCode(this.effectiveTargetNodesCount);
        return h;
    }

    public String toString() {
        return "SteinerTreeResult{parentArray=" + this.parentArray + ", relationshipToParentCost=" + this.relationshipToParentCost + ", totalCost=" + this.totalCost + ", effectiveNodeCount=" + this.effectiveNodeCount + ", effectiveTargetNodesCount=" + this.effectiveTargetNodesCount + "}";
    }

    public static SteinerTreeResult of(HugeLongArray parentArray, HugeDoubleArray relationshipToParentCost, double totalCost, long effectiveNodeCount, long effectiveTargetNodesCount) {
        return new ImmutableSteinerTreeResult(parentArray, relationshipToParentCost, totalCost, effectiveNodeCount, effectiveTargetNodesCount);
    }

    public static SteinerTreeResult copyOf(SteinerTreeResult instance) {
        if (instance instanceof ImmutableSteinerTreeResult) {
            return (ImmutableSteinerTreeResult)instance;
        }
        return ImmutableSteinerTreeResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SteinerTreeResult", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_PARENT_ARRAY = 1L;
        private static final long INIT_BIT_RELATIONSHIP_TO_PARENT_COST = 2L;
        private static final long INIT_BIT_TOTAL_COST = 4L;
        private static final long INIT_BIT_EFFECTIVE_NODE_COUNT = 8L;
        private static final long INIT_BIT_EFFECTIVE_TARGET_NODES_COUNT = 16L;
        private long initBits = 31L;
        private HugeLongArray parentArray;
        private HugeDoubleArray relationshipToParentCost;
        private double totalCost;
        private long effectiveNodeCount;
        private long effectiveTargetNodesCount;

        private Builder() {
        }

        public final Builder from(SteinerTreeResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.parentArray(instance.parentArray());
            this.relationshipToParentCost(instance.relationshipToParentCost());
            this.totalCost(instance.totalCost());
            this.effectiveNodeCount(instance.effectiveNodeCount());
            this.effectiveTargetNodesCount(instance.effectiveTargetNodesCount());
            return this;
        }

        public final Builder parentArray(HugeLongArray parentArray) {
            this.parentArray = Objects.requireNonNull(parentArray, "parentArray");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder relationshipToParentCost(HugeDoubleArray relationshipToParentCost) {
            this.relationshipToParentCost = Objects.requireNonNull(relationshipToParentCost, "relationshipToParentCost");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder totalCost(double totalCost) {
            this.totalCost = totalCost;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder effectiveNodeCount(long effectiveNodeCount) {
            this.effectiveNodeCount = effectiveNodeCount;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder effectiveTargetNodesCount(long effectiveTargetNodesCount) {
            this.effectiveTargetNodesCount = effectiveTargetNodesCount;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public Builder clear() {
            this.initBits = 31L;
            this.parentArray = null;
            this.relationshipToParentCost = null;
            this.totalCost = 0.0;
            this.effectiveNodeCount = 0L;
            this.effectiveTargetNodesCount = 0L;
            return this;
        }

        public SteinerTreeResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSteinerTreeResult(null, this.parentArray, this.relationshipToParentCost, this.totalCost, this.effectiveNodeCount, this.effectiveTargetNodesCount);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("parentArray");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("relationshipToParentCost");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("totalCost");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("effectiveNodeCount");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("effectiveTargetNodesCount");
            }
            return "Cannot build SteinerTreeResult, some of required attributes are not set " + attributes;
        }
    }
}

