/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.steiner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.JobIdConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.config.SourceNodeConfig;
import org.neo4j.gds.config.TargetNodesConfig;
import org.neo4j.gds.config.WriteConfig;
import org.neo4j.gds.config.WritePropertyConfig;
import org.neo4j.gds.config.WriteRelationshipConfig;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.steiner.SteinerTreeBaseConfig;
import org.neo4j.gds.steiner.SteinerTreeWriteConfig;

@Generated(from="SteinerTreeWriteConfig", generator="Immutables")
public final class ImmutableSteinerTreeWriteConfig
implements SteinerTreeWriteConfig {
    private final String usernameOverride;
    private final boolean sudo;
    private final boolean logProgress;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    private final JobId jobId;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    private final long sourceNode;
    private final List<Long> targetNodes;
    private final transient boolean hasTargetNodes;
    private final String relationshipWeightProperty;
    private final transient boolean hasRelationshipWeightProperty;
    private final boolean applyRerouting;
    private final double delta;
    private final int writeConcurrency;
    private final String writeRelationshipType;
    private final String writeProperty;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSteinerTreeWriteConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, long sourceNode, Iterable<Long> targetNodes, Optional<String> relationshipWeightProperty, boolean applyRerouting, double delta, int writeConcurrency, String writeRelationshipType, String writeProperty) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableSteinerTreeWriteConfig.createUnmodifiableList(false, ImmutableSteinerTreeWriteConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableSteinerTreeWriteConfig.createUnmodifiableList(false, ImmutableSteinerTreeWriteConfig.createSafeList(nodeLabels, true, false)));
        this.sourceNode = sourceNode;
        this.initShim.targetNodes(ImmutableSteinerTreeWriteConfig.createUnmodifiableList(false, ImmutableSteinerTreeWriteConfig.createSafeList(targetNodes, true, false)));
        this.relationshipWeightProperty = relationshipWeightProperty.orElse(null);
        this.initShim.applyRerouting(applyRerouting);
        this.initShim.delta(delta);
        this.initShim.writeConcurrency(writeConcurrency);
        this.writeRelationshipType = Objects.requireNonNull(writeRelationshipType, "writeRelationshipType");
        this.writeProperty = Objects.requireNonNull(writeProperty, "writeProperty");
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.targetNodes = this.initShim.targetNodes();
        this.hasTargetNodes = this.initShim.hasTargetNodes();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.applyRerouting = this.initShim.applyRerouting();
        this.delta = this.initShim.delta();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private ImmutableSteinerTreeWriteConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, long sourceNode, Iterable<Long> targetNodes, String relationshipWeightProperty, boolean applyRerouting, double delta, int writeConcurrency, String writeRelationshipType, String writeProperty) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableSteinerTreeWriteConfig.createUnmodifiableList(false, ImmutableSteinerTreeWriteConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableSteinerTreeWriteConfig.createUnmodifiableList(false, ImmutableSteinerTreeWriteConfig.createSafeList(nodeLabels, true, false)));
        this.sourceNode = sourceNode;
        this.initShim.targetNodes(ImmutableSteinerTreeWriteConfig.createUnmodifiableList(false, ImmutableSteinerTreeWriteConfig.createSafeList(targetNodes, true, false)));
        this.relationshipWeightProperty = relationshipWeightProperty;
        this.initShim.applyRerouting(applyRerouting);
        this.initShim.delta(delta);
        this.initShim.writeConcurrency(writeConcurrency);
        this.writeRelationshipType = Objects.requireNonNull(writeRelationshipType, "writeRelationshipType");
        this.writeProperty = Objects.requireNonNull(writeProperty, "writeProperty");
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.targetNodes = this.initShim.targetNodes();
        this.hasTargetNodes = this.initShim.hasTargetNodes();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.applyRerouting = this.initShim.applyRerouting();
        this.delta = this.initShim.delta();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private ImmutableSteinerTreeWriteConfig(Builder builder) {
        this.usernameOverride = builder.usernameOverride;
        this.sourceNode = builder.sourceNode;
        this.relationshipWeightProperty = builder.relationshipWeightProperty;
        this.writeRelationshipType = builder.writeRelationshipType;
        this.writeProperty = builder.writeProperty;
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.logProgressIsSet()) {
            this.initShim.logProgress(builder.logProgress);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.jobId != null) {
            this.initShim.jobId(builder.jobId);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableSteinerTreeWriteConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableSteinerTreeWriteConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.targetNodesIsSet()) {
            this.initShim.targetNodes(builder.targetNodes == null ? Collections.emptyList() : ImmutableSteinerTreeWriteConfig.createUnmodifiableList(true, builder.targetNodes));
        }
        if (builder.applyReroutingIsSet()) {
            this.initShim.applyRerouting(builder.applyRerouting);
        }
        if (builder.deltaIsSet()) {
            this.initShim.delta(builder.delta);
        }
        if (builder.writeConcurrencyIsSet()) {
            this.initShim.writeConcurrency(builder.writeConcurrency);
        }
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.targetNodes = this.initShim.targetNodes();
        this.hasTargetNodes = this.initShim.hasTargetNodes();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.applyRerouting = this.initShim.applyRerouting();
        this.delta = this.initShim.delta();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private ImmutableSteinerTreeWriteConfig(String usernameOverride, boolean sudo, boolean logProgress, Collection<String> configKeys, int concurrency, int minBatchSize, JobId jobId, List<String> relationshipTypes, List<String> nodeLabels, long sourceNode, List<Long> targetNodes, String relationshipWeightProperty, boolean applyRerouting, double delta, int writeConcurrency, String writeRelationshipType, String writeProperty) {
        this.usernameOverride = usernameOverride;
        this.initShim.sudo(sudo);
        this.initShim.logProgress(logProgress);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.jobId(jobId);
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.sourceNode = sourceNode;
        this.initShim.targetNodes(targetNodes);
        this.relationshipWeightProperty = relationshipWeightProperty;
        this.initShim.applyRerouting(applyRerouting);
        this.initShim.delta(delta);
        this.initShim.writeConcurrency(writeConcurrency);
        this.writeRelationshipType = writeRelationshipType;
        this.writeProperty = writeProperty;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.targetNodes = this.initShim.targetNodes();
        this.hasTargetNodes = this.initShim.hasTargetNodes();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.applyRerouting = this.initShim.applyRerouting();
        this.delta = this.initShim.delta();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private boolean sudoInitialize() {
        return SteinerTreeWriteConfig.super.sudo();
    }

    private boolean logProgressInitialize() {
        return SteinerTreeWriteConfig.super.logProgress();
    }

    private Collection<String> configKeysInitialize() {
        return SteinerTreeWriteConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return SteinerTreeWriteConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return SteinerTreeWriteConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return SteinerTreeWriteConfig.super.minBatchSize();
    }

    private JobId jobIdInitialize() {
        return SteinerTreeWriteConfig.super.jobId();
    }

    private List<String> relationshipTypesInitialize() {
        return SteinerTreeWriteConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return SteinerTreeWriteConfig.super.nodeLabels();
    }

    private List<Long> targetNodesInitialize() {
        return SteinerTreeWriteConfig.super.targetNodes();
    }

    private boolean hasTargetNodesInitialize() {
        return SteinerTreeWriteConfig.super.hasTargetNodes();
    }

    private boolean hasRelationshipWeightPropertyInitialize() {
        return SteinerTreeWriteConfig.super.hasRelationshipWeightProperty();
    }

    private boolean applyReroutingInitialize() {
        return SteinerTreeWriteConfig.super.applyRerouting();
    }

    private double deltaInitialize() {
        return SteinerTreeWriteConfig.super.delta();
    }

    private int writeConcurrencyInitialize() {
        return SteinerTreeWriteConfig.super.writeConcurrency();
    }

    public Optional<String> usernameOverride() {
        return Optional.ofNullable(this.usernameOverride);
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public boolean logProgress() {
        InitShim shim = this.initShim;
        return shim != null ? shim.logProgress() : this.logProgress;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    public JobId jobId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.jobId() : this.jobId;
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    public long sourceNode() {
        return this.sourceNode;
    }

    public List<Long> targetNodes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.targetNodes() : this.targetNodes;
    }

    public boolean hasTargetNodes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasTargetNodes() : this.hasTargetNodes;
    }

    public Optional<String> relationshipWeightProperty() {
        return Optional.ofNullable(this.relationshipWeightProperty);
    }

    public boolean hasRelationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasRelationshipWeightProperty() : this.hasRelationshipWeightProperty;
    }

    @Override
    public boolean applyRerouting() {
        InitShim shim = this.initShim;
        return shim != null ? shim.applyRerouting() : this.applyRerouting;
    }

    @Override
    public double delta() {
        InitShim shim = this.initShim;
        return shim != null ? shim.delta() : this.delta;
    }

    public int writeConcurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.writeConcurrency() : this.writeConcurrency;
    }

    public String writeRelationshipType() {
        return this.writeRelationshipType;
    }

    public String writeProperty() {
        return this.writeProperty;
    }

    public final ImmutableSteinerTreeWriteConfig withUsernameOverride(String value) {
        String newValue = value;
        if (Objects.equals(this.usernameOverride, newValue)) {
            return this;
        }
        return ImmutableSteinerTreeWriteConfig.validate(new ImmutableSteinerTreeWriteConfig(newValue, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNodes, this.relationshipWeightProperty, this.applyRerouting, this.delta, this.writeConcurrency, this.writeRelationshipType, this.writeProperty));
    }

    public final ImmutableSteinerTreeWriteConfig withUsernameOverride(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableSteinerTreeWriteConfig.validate(new ImmutableSteinerTreeWriteConfig(value, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNodes, this.relationshipWeightProperty, this.applyRerouting, this.delta, this.writeConcurrency, this.writeRelationshipType, this.writeProperty));
    }

    public final ImmutableSteinerTreeWriteConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableSteinerTreeWriteConfig.validate(new ImmutableSteinerTreeWriteConfig(this.usernameOverride, value, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNodes, this.relationshipWeightProperty, this.applyRerouting, this.delta, this.writeConcurrency, this.writeRelationshipType, this.writeProperty));
    }

    public final ImmutableSteinerTreeWriteConfig withLogProgress(boolean value) {
        if (this.logProgress == value) {
            return this;
        }
        return ImmutableSteinerTreeWriteConfig.validate(new ImmutableSteinerTreeWriteConfig(this.usernameOverride, this.sudo, value, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNodes, this.relationshipWeightProperty, this.applyRerouting, this.delta, this.writeConcurrency, this.writeRelationshipType, this.writeProperty));
    }

    public final ImmutableSteinerTreeWriteConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableSteinerTreeWriteConfig.validate(new ImmutableSteinerTreeWriteConfig(this.usernameOverride, this.sudo, this.logProgress, newValue, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNodes, this.relationshipWeightProperty, this.applyRerouting, this.delta, this.writeConcurrency, this.writeRelationshipType, this.writeProperty));
    }

    public final ImmutableSteinerTreeWriteConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableSteinerTreeWriteConfig.validate(new ImmutableSteinerTreeWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, value, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNodes, this.relationshipWeightProperty, this.applyRerouting, this.delta, this.writeConcurrency, this.writeRelationshipType, this.writeProperty));
    }

    public final ImmutableSteinerTreeWriteConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutableSteinerTreeWriteConfig.validate(new ImmutableSteinerTreeWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, value, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNodes, this.relationshipWeightProperty, this.applyRerouting, this.delta, this.writeConcurrency, this.writeRelationshipType, this.writeProperty));
    }

    public final ImmutableSteinerTreeWriteConfig withJobId(JobId value) {
        if (this.jobId == value) {
            return this;
        }
        JobId newValue = Objects.requireNonNull(value, "jobId");
        return ImmutableSteinerTreeWriteConfig.validate(new ImmutableSteinerTreeWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNodes, this.relationshipWeightProperty, this.applyRerouting, this.delta, this.writeConcurrency, this.writeRelationshipType, this.writeProperty));
    }

    public final ImmutableSteinerTreeWriteConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableSteinerTreeWriteConfig.createUnmodifiableList(false, ImmutableSteinerTreeWriteConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableSteinerTreeWriteConfig.validate(new ImmutableSteinerTreeWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, newValue, this.nodeLabels, this.sourceNode, this.targetNodes, this.relationshipWeightProperty, this.applyRerouting, this.delta, this.writeConcurrency, this.writeRelationshipType, this.writeProperty));
    }

    public final ImmutableSteinerTreeWriteConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableSteinerTreeWriteConfig.createUnmodifiableList(false, ImmutableSteinerTreeWriteConfig.createSafeList(elements, true, false));
        return ImmutableSteinerTreeWriteConfig.validate(new ImmutableSteinerTreeWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, newValue, this.nodeLabels, this.sourceNode, this.targetNodes, this.relationshipWeightProperty, this.applyRerouting, this.delta, this.writeConcurrency, this.writeRelationshipType, this.writeProperty));
    }

    public final ImmutableSteinerTreeWriteConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableSteinerTreeWriteConfig.createUnmodifiableList(false, ImmutableSteinerTreeWriteConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableSteinerTreeWriteConfig.validate(new ImmutableSteinerTreeWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, newValue, this.sourceNode, this.targetNodes, this.relationshipWeightProperty, this.applyRerouting, this.delta, this.writeConcurrency, this.writeRelationshipType, this.writeProperty));
    }

    public final ImmutableSteinerTreeWriteConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableSteinerTreeWriteConfig.createUnmodifiableList(false, ImmutableSteinerTreeWriteConfig.createSafeList(elements, true, false));
        return ImmutableSteinerTreeWriteConfig.validate(new ImmutableSteinerTreeWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, newValue, this.sourceNode, this.targetNodes, this.relationshipWeightProperty, this.applyRerouting, this.delta, this.writeConcurrency, this.writeRelationshipType, this.writeProperty));
    }

    public final ImmutableSteinerTreeWriteConfig withSourceNode(long value) {
        if (this.sourceNode == value) {
            return this;
        }
        return ImmutableSteinerTreeWriteConfig.validate(new ImmutableSteinerTreeWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, value, this.targetNodes, this.relationshipWeightProperty, this.applyRerouting, this.delta, this.writeConcurrency, this.writeRelationshipType, this.writeProperty));
    }

    public final ImmutableSteinerTreeWriteConfig withTargetNodes(long ... elements) {
        ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
        for (long element : elements) {
            wrappedList.add(element);
        }
        List<Long> newValue = ImmutableSteinerTreeWriteConfig.createUnmodifiableList(false, wrappedList);
        return ImmutableSteinerTreeWriteConfig.validate(new ImmutableSteinerTreeWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, newValue, this.relationshipWeightProperty, this.applyRerouting, this.delta, this.writeConcurrency, this.writeRelationshipType, this.writeProperty));
    }

    public final ImmutableSteinerTreeWriteConfig withTargetNodes(Iterable<Long> elements) {
        if (this.targetNodes == elements) {
            return this;
        }
        List<Long> newValue = ImmutableSteinerTreeWriteConfig.createUnmodifiableList(false, ImmutableSteinerTreeWriteConfig.createSafeList(elements, true, false));
        return ImmutableSteinerTreeWriteConfig.validate(new ImmutableSteinerTreeWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, newValue, this.relationshipWeightProperty, this.applyRerouting, this.delta, this.writeConcurrency, this.writeRelationshipType, this.writeProperty));
    }

    public final ImmutableSteinerTreeWriteConfig withRelationshipWeightProperty(String value) {
        String newValue = value;
        if (Objects.equals(this.relationshipWeightProperty, newValue)) {
            return this;
        }
        return ImmutableSteinerTreeWriteConfig.validate(new ImmutableSteinerTreeWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNodes, newValue, this.applyRerouting, this.delta, this.writeConcurrency, this.writeRelationshipType, this.writeProperty));
    }

    public final ImmutableSteinerTreeWriteConfig withRelationshipWeightProperty(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.relationshipWeightProperty, value)) {
            return this;
        }
        return ImmutableSteinerTreeWriteConfig.validate(new ImmutableSteinerTreeWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNodes, value, this.applyRerouting, this.delta, this.writeConcurrency, this.writeRelationshipType, this.writeProperty));
    }

    public final ImmutableSteinerTreeWriteConfig withApplyRerouting(boolean value) {
        if (this.applyRerouting == value) {
            return this;
        }
        return ImmutableSteinerTreeWriteConfig.validate(new ImmutableSteinerTreeWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNodes, this.relationshipWeightProperty, value, this.delta, this.writeConcurrency, this.writeRelationshipType, this.writeProperty));
    }

    public final ImmutableSteinerTreeWriteConfig withDelta(double value) {
        if (Double.doubleToLongBits(this.delta) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableSteinerTreeWriteConfig.validate(new ImmutableSteinerTreeWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNodes, this.relationshipWeightProperty, this.applyRerouting, value, this.writeConcurrency, this.writeRelationshipType, this.writeProperty));
    }

    public final ImmutableSteinerTreeWriteConfig withWriteConcurrency(int value) {
        if (this.writeConcurrency == value) {
            return this;
        }
        return ImmutableSteinerTreeWriteConfig.validate(new ImmutableSteinerTreeWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNodes, this.relationshipWeightProperty, this.applyRerouting, this.delta, value, this.writeRelationshipType, this.writeProperty));
    }

    public final ImmutableSteinerTreeWriteConfig withWriteRelationshipType(String value) {
        String newValue = Objects.requireNonNull(value, "writeRelationshipType");
        if (this.writeRelationshipType.equals(newValue)) {
            return this;
        }
        return ImmutableSteinerTreeWriteConfig.validate(new ImmutableSteinerTreeWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNodes, this.relationshipWeightProperty, this.applyRerouting, this.delta, this.writeConcurrency, newValue, this.writeProperty));
    }

    public final ImmutableSteinerTreeWriteConfig withWriteProperty(String value) {
        String newValue = Objects.requireNonNull(value, "writeProperty");
        if (this.writeProperty.equals(newValue)) {
            return this;
        }
        return ImmutableSteinerTreeWriteConfig.validate(new ImmutableSteinerTreeWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNodes, this.relationshipWeightProperty, this.applyRerouting, this.delta, this.writeConcurrency, this.writeRelationshipType, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSteinerTreeWriteConfig && this.equalTo((ImmutableSteinerTreeWriteConfig)another);
    }

    private boolean equalTo(ImmutableSteinerTreeWriteConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.logProgress == another.logProgress && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && this.jobId.equals((Object)another.jobId) && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && this.sourceNode == another.sourceNode && this.targetNodes.equals(another.targetNodes) && this.hasTargetNodes == another.hasTargetNodes && Objects.equals(this.relationshipWeightProperty, another.relationshipWeightProperty) && this.hasRelationshipWeightProperty == another.hasRelationshipWeightProperty && this.applyRerouting == another.applyRerouting && Double.doubleToLongBits(this.delta) == Double.doubleToLongBits(another.delta) && this.writeConcurrency == another.writeConcurrency && this.writeRelationshipType.equals(another.writeRelationshipType) && this.writeProperty.equals(another.writeProperty);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + Boolean.hashCode(this.logProgress);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + this.jobId.hashCode();
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + Long.hashCode(this.sourceNode);
        h += (h << 5) + this.targetNodes.hashCode();
        h += (h << 5) + Boolean.hashCode(this.hasTargetNodes);
        h += (h << 5) + Objects.hashCode(this.relationshipWeightProperty);
        h += (h << 5) + Boolean.hashCode(this.hasRelationshipWeightProperty);
        h += (h << 5) + Boolean.hashCode(this.applyRerouting);
        h += (h << 5) + Double.hashCode(this.delta);
        h += (h << 5) + this.writeConcurrency;
        h += (h << 5) + this.writeRelationshipType.hashCode();
        h += (h << 5) + this.writeProperty.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SteinerTreeWriteConfig{");
        if (this.usernameOverride != null) {
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        if (builder.length() > 23) {
            builder.append(", ");
        }
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("logProgress=").append(this.logProgress);
        builder.append(", ");
        builder.append("concurrency=").append(this.concurrency);
        builder.append(", ");
        builder.append("minBatchSize=").append(this.minBatchSize);
        builder.append(", ");
        builder.append("jobId=").append(this.jobId);
        builder.append(", ");
        builder.append("relationshipTypes=").append(this.relationshipTypes);
        builder.append(", ");
        builder.append("nodeLabels=").append(this.nodeLabels);
        builder.append(", ");
        builder.append("sourceNode=").append(this.sourceNode);
        builder.append(", ");
        builder.append("targetNodes=").append(this.targetNodes);
        builder.append(", ");
        builder.append("hasTargetNodes=").append(this.hasTargetNodes);
        if (this.relationshipWeightProperty != null) {
            builder.append(", ");
            builder.append("relationshipWeightProperty=").append(this.relationshipWeightProperty);
        }
        builder.append(", ");
        builder.append("hasRelationshipWeightProperty=").append(this.hasRelationshipWeightProperty);
        builder.append(", ");
        builder.append("applyRerouting=").append(this.applyRerouting);
        builder.append(", ");
        builder.append("delta=").append(this.delta);
        builder.append(", ");
        builder.append("writeConcurrency=").append(this.writeConcurrency);
        builder.append(", ");
        builder.append("writeRelationshipType=").append(this.writeRelationshipType);
        builder.append(", ");
        builder.append("writeProperty=").append(this.writeProperty);
        return builder.append("}").toString();
    }

    public static SteinerTreeWriteConfig of(int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, long sourceNode, List<Long> targetNodes, Optional<String> relationshipWeightProperty, boolean applyRerouting, double delta, int writeConcurrency, String writeRelationshipType, String writeProperty) {
        return ImmutableSteinerTreeWriteConfig.of(concurrency, minBatchSize, relationshipTypes, nodeLabels, sourceNode, targetNodes, relationshipWeightProperty, applyRerouting, delta, writeConcurrency, writeRelationshipType, writeProperty);
    }

    public static SteinerTreeWriteConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, long sourceNode, Iterable<Long> targetNodes, Optional<String> relationshipWeightProperty, boolean applyRerouting, double delta, int writeConcurrency, String writeRelationshipType, String writeProperty) {
        return ImmutableSteinerTreeWriteConfig.validate(new ImmutableSteinerTreeWriteConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, sourceNode, targetNodes, relationshipWeightProperty, applyRerouting, delta, writeConcurrency, writeRelationshipType, writeProperty));
    }

    public static SteinerTreeWriteConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, long sourceNode, Iterable<Long> targetNodes, String relationshipWeightProperty, boolean applyRerouting, double delta, int writeConcurrency, String writeRelationshipType, String writeProperty) {
        return ImmutableSteinerTreeWriteConfig.validate(new ImmutableSteinerTreeWriteConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, sourceNode, targetNodes, relationshipWeightProperty, applyRerouting, delta, writeConcurrency, writeRelationshipType, writeProperty));
    }

    private static ImmutableSteinerTreeWriteConfig validate(ImmutableSteinerTreeWriteConfig instance) {
        instance.validateWriteConcurrency();
        instance.validateRelationshipWeightProperty();
        instance.validateConcurrency();
        return instance;
    }

    public static SteinerTreeWriteConfig copyOf(SteinerTreeWriteConfig instance) {
        if (instance instanceof ImmutableSteinerTreeWriteConfig) {
            return (ImmutableSteinerTreeWriteConfig)instance;
        }
        return ImmutableSteinerTreeWriteConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="SteinerTreeWriteConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_SOURCE_NODE = 1L;
        private static final long INIT_BIT_WRITE_RELATIONSHIP_TYPE = 2L;
        private static final long INIT_BIT_WRITE_PROPERTY = 4L;
        private static final long OPT_BIT_SUDO = 1L;
        private static final long OPT_BIT_LOG_PROGRESS = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 8L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 16L;
        private static final long OPT_BIT_NODE_LABELS = 32L;
        private static final long OPT_BIT_TARGET_NODES = 64L;
        private static final long OPT_BIT_APPLY_REROUTING = 128L;
        private static final long OPT_BIT_DELTA = 256L;
        private static final long OPT_BIT_WRITE_CONCURRENCY = 512L;
        private long initBits = 7L;
        private long optBits;
        private String usernameOverride;
        private boolean sudo;
        private boolean logProgress;
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        private JobId jobId;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        private long sourceNode;
        private List<Long> targetNodes = null;
        private String relationshipWeightProperty;
        private boolean applyRerouting;
        private double delta;
        private int writeConcurrency;
        private String writeRelationshipType;
        private String writeProperty;

        private Builder() {
        }

        public final Builder from(RelationshipWeightConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WriteConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TargetNodesConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WritePropertyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SourceNodeConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(JobIdConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WriteRelationshipConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SteinerTreeBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SteinerTreeWriteConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            RelationshipWeightConfig instance;
            Optional relationshipWeightPropertyOptional;
            if (object instanceof RelationshipWeightConfig && (relationshipWeightPropertyOptional = (instance = (RelationshipWeightConfig)object).relationshipWeightProperty()).isPresent()) {
                this.relationshipWeightProperty(relationshipWeightPropertyOptional);
            }
            if (object instanceof WriteConfig) {
                instance = (WriteConfig)object;
                this.writeConcurrency(instance.writeConcurrency());
            }
            if (object instanceof TargetNodesConfig) {
                instance = (TargetNodesConfig)object;
                this.addAllTargetNodes(instance.targetNodes());
            }
            if (object instanceof WritePropertyConfig) {
                instance = (WritePropertyConfig)object;
                this.writeProperty(instance.writeProperty());
            }
            if (object instanceof SourceNodeConfig) {
                instance = (SourceNodeConfig)object;
                this.sourceNode(instance.sourceNode());
            }
            if (object instanceof JobIdConfig) {
                instance = (JobIdConfig)object;
                this.jobId(instance.jobId());
            }
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                this.minBatchSize(instance.minBatchSize());
                this.concurrency(instance.concurrency());
            }
            if (object instanceof WriteRelationshipConfig) {
                instance = (WriteRelationshipConfig)object;
                this.writeRelationshipType(instance.writeRelationshipType());
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                this.logProgress(instance.logProgress());
                this.sudo(instance.sudo());
                Optional usernameOverrideOptional = instance.usernameOverride();
                if (usernameOverrideOptional.isPresent()) {
                    this.usernameOverride(usernameOverrideOptional);
                }
                this.configKeys(instance.configKeys());
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                this.addAllRelationshipTypes(instance.relationshipTypes());
                this.addAllNodeLabels(instance.nodeLabels());
            }
            if (object instanceof SteinerTreeBaseConfig) {
                instance = (SteinerTreeBaseConfig)object;
                this.delta(instance.delta());
                this.applyRerouting(instance.applyRerouting());
            }
        }

        public final Builder usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            return this;
        }

        public final Builder usernameOverride(Optional<String> usernameOverride) {
            this.usernameOverride = usernameOverride.orElse(null);
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 1L;
            return this;
        }

        public final Builder logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder jobId(JobId jobId) {
            this.jobId = Objects.requireNonNull(jobId, "jobId");
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder sourceNode(long sourceNode) {
            this.sourceNode = sourceNode;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addTargetNode(long element) {
            if (this.targetNodes == null) {
                this.targetNodes = new ArrayList<Long>();
            }
            this.targetNodes.add(element);
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder addTargetNodes(long ... elements) {
            if (this.targetNodes == null) {
                this.targetNodes = new ArrayList<Long>();
            }
            for (long element : elements) {
                this.targetNodes.add(element);
            }
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder targetNodes(Iterable<Long> elements) {
            this.targetNodes = new ArrayList<Long>();
            return this.addAllTargetNodes(elements);
        }

        public final Builder addAllTargetNodes(Iterable<Long> elements) {
            Objects.requireNonNull(elements, "targetNodes element");
            if (this.targetNodes == null) {
                this.targetNodes = new ArrayList<Long>();
            }
            for (long element : elements) {
                this.targetNodes.add(Objects.requireNonNull(Long.valueOf(element), "targetNodes element"));
            }
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder relationshipWeightProperty(String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            return this;
        }

        public final Builder relationshipWeightProperty(Optional<String> relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty.orElse(null);
            return this;
        }

        public final Builder applyRerouting(boolean applyRerouting) {
            this.applyRerouting = applyRerouting;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder delta(double delta) {
            this.delta = delta;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder writeConcurrency(int writeConcurrency) {
            this.writeConcurrency = writeConcurrency;
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder writeRelationshipType(String writeRelationshipType) {
            this.writeRelationshipType = Objects.requireNonNull(writeRelationshipType, "writeRelationshipType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder writeProperty(String writeProperty) {
            this.writeProperty = Objects.requireNonNull(writeProperty, "writeProperty");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder clear() {
            this.initBits = 7L;
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.logProgress = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            this.jobId = null;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.sourceNode = 0L;
            if (this.targetNodes != null) {
                this.targetNodes.clear();
            }
            this.relationshipWeightProperty = null;
            this.applyRerouting = false;
            this.delta = 0.0;
            this.writeConcurrency = 0;
            this.writeRelationshipType = null;
            this.writeProperty = null;
            return this;
        }

        public SteinerTreeWriteConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableSteinerTreeWriteConfig.validate(new ImmutableSteinerTreeWriteConfig(this));
        }

        private boolean sudoIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean logProgressIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean targetNodesIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean applyReroutingIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean deltaIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean writeConcurrencyIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sourceNode");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("writeRelationshipType");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("writeProperty");
            }
            return "Cannot build SteinerTreeWriteConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="SteinerTreeWriteConfig", generator="Immutables")
    private final class InitShim {
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte logProgressBuildStage = 0;
        private boolean logProgress;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte jobIdBuildStage = 0;
        private JobId jobId;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte targetNodesBuildStage = 0;
        private List<Long> targetNodes;
        private byte hasTargetNodesBuildStage = 0;
        private boolean hasTargetNodes;
        private byte hasRelationshipWeightPropertyBuildStage = 0;
        private boolean hasRelationshipWeightProperty;
        private byte applyReroutingBuildStage = 0;
        private boolean applyRerouting;
        private byte deltaBuildStage = 0;
        private double delta;
        private byte writeConcurrencyBuildStage = 0;
        private int writeConcurrency;

        private InitShim() {
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableSteinerTreeWriteConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        boolean logProgress() {
            if (this.logProgressBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.logProgressBuildStage == 0) {
                this.logProgressBuildStage = (byte)-1;
                this.logProgress = ImmutableSteinerTreeWriteConfig.this.logProgressInitialize();
                this.logProgressBuildStage = 1;
            }
            return this.logProgress;
        }

        void logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.logProgressBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableSteinerTreeWriteConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableSteinerTreeWriteConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableSteinerTreeWriteConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutableSteinerTreeWriteConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        JobId jobId() {
            if (this.jobIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.jobIdBuildStage == 0) {
                this.jobIdBuildStage = (byte)-1;
                this.jobId = Objects.requireNonNull(ImmutableSteinerTreeWriteConfig.this.jobIdInitialize(), "jobId");
                this.jobIdBuildStage = 1;
            }
            return this.jobId;
        }

        void jobId(JobId jobId) {
            this.jobId = jobId;
            this.jobIdBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableSteinerTreeWriteConfig.createUnmodifiableList(false, ImmutableSteinerTreeWriteConfig.createSafeList(ImmutableSteinerTreeWriteConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableSteinerTreeWriteConfig.createUnmodifiableList(false, ImmutableSteinerTreeWriteConfig.createSafeList(ImmutableSteinerTreeWriteConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        List<Long> targetNodes() {
            if (this.targetNodesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.targetNodesBuildStage == 0) {
                this.targetNodesBuildStage = (byte)-1;
                this.targetNodes = ImmutableSteinerTreeWriteConfig.createUnmodifiableList(false, ImmutableSteinerTreeWriteConfig.createSafeList(ImmutableSteinerTreeWriteConfig.this.targetNodesInitialize(), true, false));
                this.targetNodesBuildStage = 1;
            }
            return this.targetNodes;
        }

        void targetNodes(List<Long> targetNodes) {
            this.targetNodes = targetNodes;
            this.targetNodesBuildStage = 1;
        }

        boolean hasTargetNodes() {
            if (this.hasTargetNodesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasTargetNodesBuildStage == 0) {
                this.hasTargetNodesBuildStage = (byte)-1;
                this.hasTargetNodes = ImmutableSteinerTreeWriteConfig.this.hasTargetNodesInitialize();
                this.hasTargetNodesBuildStage = 1;
            }
            return this.hasTargetNodes;
        }

        boolean hasRelationshipWeightProperty() {
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasRelationshipWeightPropertyBuildStage == 0) {
                this.hasRelationshipWeightPropertyBuildStage = (byte)-1;
                this.hasRelationshipWeightProperty = ImmutableSteinerTreeWriteConfig.this.hasRelationshipWeightPropertyInitialize();
                this.hasRelationshipWeightPropertyBuildStage = 1;
            }
            return this.hasRelationshipWeightProperty;
        }

        boolean applyRerouting() {
            if (this.applyReroutingBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.applyReroutingBuildStage == 0) {
                this.applyReroutingBuildStage = (byte)-1;
                this.applyRerouting = ImmutableSteinerTreeWriteConfig.this.applyReroutingInitialize();
                this.applyReroutingBuildStage = 1;
            }
            return this.applyRerouting;
        }

        void applyRerouting(boolean applyRerouting) {
            this.applyRerouting = applyRerouting;
            this.applyReroutingBuildStage = 1;
        }

        double delta() {
            if (this.deltaBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.deltaBuildStage == 0) {
                this.deltaBuildStage = (byte)-1;
                this.delta = ImmutableSteinerTreeWriteConfig.this.deltaInitialize();
                this.deltaBuildStage = 1;
            }
            return this.delta;
        }

        void delta(double delta) {
            this.delta = delta;
            this.deltaBuildStage = 1;
        }

        int writeConcurrency() {
            if (this.writeConcurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.writeConcurrencyBuildStage == 0) {
                this.writeConcurrencyBuildStage = (byte)-1;
                this.writeConcurrency = ImmutableSteinerTreeWriteConfig.this.writeConcurrencyInitialize();
                this.writeConcurrencyBuildStage = 1;
            }
            return this.writeConcurrency;
        }

        void writeConcurrency(int writeConcurrency) {
            this.writeConcurrency = writeConcurrency;
            this.writeConcurrencyBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.logProgressBuildStage == -1) {
                attributes.add("logProgress");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.jobIdBuildStage == -1) {
                attributes.add("jobId");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.targetNodesBuildStage == -1) {
                attributes.add("targetNodes");
            }
            if (this.hasTargetNodesBuildStage == -1) {
                attributes.add("hasTargetNodes");
            }
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                attributes.add("hasRelationshipWeightProperty");
            }
            if (this.applyReroutingBuildStage == -1) {
                attributes.add("applyRerouting");
            }
            if (this.deltaBuildStage == -1) {
                attributes.add("delta");
            }
            if (this.writeConcurrencyBuildStage == -1) {
                attributes.add("writeConcurrency");
            }
            return "Cannot build SteinerTreeWriteConfig, attribute initializers form cycle " + attributes;
        }
    }
}

