/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.steiner;

import org.neo4j.gds.steiner.Direction;

class LinkCutNode {
    private LinkCutNode up;
    private LinkCutNode left;
    private LinkCutNode right;
    private final long source;
    private boolean reverseBit;

    LinkCutNode(long source, LinkCutNode p) {
        this.up = p;
        this.left = null;
        this.right = null;
        this.source = source;
        this.reverseBit = false;
    }

    void reverseBit() {
        this.reverseBit = !this.reverseBit;
    }

    void setChild(LinkCutNode node, Direction direction) {
        if (direction == Direction.LEFT) {
            this.left = node;
        } else {
            this.right = node;
        }
    }

    boolean getReversedBit() {
        return this.reverseBit;
    }

    long source() {
        return this.source;
    }

    LinkCutNode parent() {
        return this.up;
    }

    LinkCutNode left() {
        return this.left;
    }

    LinkCutNode right() {
        return this.right;
    }

    LinkCutNode root() {
        LinkCutNode current = this;
        while (current.up != null) {
            current = current.up;
        }
        return current;
    }

    void setParent(LinkCutNode sn) {
        this.up = sn;
    }

    private boolean checkChild(LinkCutNode node) {
        if (node != null) {
            return node.equals(this);
        }
        return false;
    }

    boolean isChildOf(LinkCutNode node) {
        if (node == null) {
            return false;
        }
        return this.checkChild(node.left) || this.checkChild(node.right);
    }

    static LinkCutNode createSingle(long id) {
        return new LinkCutNode(id, null);
    }
}

