/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.steiner;

import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.steiner.Direction;
import org.neo4j.gds.steiner.LinkCutNode;
import org.neo4j.gds.steiner.Rotation;

class LinkCutTree {
    private final HugeObjectArray<LinkCutNode> nodes;
    private final HugeObjectArray<LinkCutNode> edgeInTree;

    public LinkCutTree(long nodeCount) {
        this.nodes = HugeObjectArray.newArray(LinkCutNode.class, (long)nodeCount);
        for (long i = 0L; i < nodeCount; ++i) {
            this.nodes.set(i, (Object)LinkCutNode.createSingle(i));
        }
        this.edgeInTree = HugeObjectArray.newArray(LinkCutNode.class, (long)nodeCount);
    }

    private void fixSituation(LinkCutNode u) {
        this.singleNodeFix(u.parent());
        this.singleNodeFix(u);
    }

    private void fixAndSingle(LinkCutNode node) {
        this.fixSituation(node);
        this.singleRotation(node);
    }

    private void zig(LinkCutNode u) {
        this.fixAndSingle(u.parent());
        this.fixAndSingle(u);
    }

    private void zag(LinkCutNode u) {
        this.fixAndSingle(u);
    }

    private void singleRotation(LinkCutNode u) {
        LinkCutNode a = u.left();
        LinkCutNode b = u.right();
        LinkCutNode p = u.parent();
        LinkCutNode pp = p.parent();
        boolean dirLeft = false;
        if (p.left() != null && p.left().equals(u)) {
            dirLeft = true;
        }
        boolean pch = false;
        if (pp != null) {
            boolean bl = pch = p.isChildOf(pp);
        }
        if (dirLeft) {
            this.addChild(p, b, Direction.LEFT);
            this.addChild(u, p, Direction.RIGHT);
        } else {
            this.addChild(p, a, Direction.RIGHT);
            this.addChild(u, p, Direction.LEFT);
        }
        u.setParent(pp);
        if (pch) {
            this.addChild(pp, u, pp.right() == p ? Direction.RIGHT : Direction.LEFT);
        }
    }

    private void singleNodeFix(LinkCutNode u) {
        if (u.getReversedBit()) {
            LinkCutNode left = u.left();
            LinkCutNode right = u.right();
            if (left != null) {
                left.reverseBit();
            }
            if (right != null) {
                right.reverseBit();
            }
            this.addChild(u, right, Direction.LEFT);
            this.addChild(u, left, Direction.RIGHT);
            u.reverseBit();
        }
    }

    private void expose(LinkCutNode u) {
        LinkCutNode last = null;
        for (LinkCutNode cy = u; cy != null; cy = cy.parent()) {
            this.splay(cy);
            this.addChild(cy, last, Direction.RIGHT);
            last = cy;
        }
        this.splay(u);
    }

    private void splay(LinkCutNode u) {
        while (u.parent() != null && u.isChildOf(u.parent())) {
            Rotation info = this.getRotationInfo(u);
            if (info == Rotation.SINGLE) {
                this.fixAndSingle(u);
                continue;
            }
            if (info == Rotation.ZIGZIG) {
                this.zig(u);
                continue;
            }
            this.zag(u);
        }
        this.singleNodeFix(u);
    }

    private Rotation getRotationInfo(LinkCutNode sn) {
        LinkCutNode parent = sn.parent();
        if (parent.parent() == null) {
            return Rotation.SINGLE;
        }
        if (!parent.isChildOf(parent.parent())) {
            return Rotation.SINGLE;
        }
        LinkCutNode pparent = parent.parent();
        if (parent.left() == sn) {
            if (pparent.left() == parent) {
                return Rotation.ZIGZIG;
            }
            return Rotation.ZIGZAG;
        }
        if (pparent.right() == parent) {
            return Rotation.ZIGZIG;
        }
        return Rotation.ZIGZIG;
    }

    private void addChild(LinkCutNode a, LinkCutNode b, Direction direction) {
        a.setChild(b, direction);
        if (b != null) {
            b.setParent(a);
        }
    }

    public void link(long source, long target) {
        LinkCutNode nodeSource = (LinkCutNode)this.nodes.get(source);
        LinkCutNode nodeTarget = (LinkCutNode)this.nodes.get(target);
        LinkCutNode nodeEdge = new LinkCutNode(source, null);
        this.edgeInTree.set(target, (Object)nodeEdge);
        nodeEdge.setParent(nodeSource);
        this.evert(target);
        nodeTarget.setParent(nodeEdge);
    }

    private void evert(long nodeId) {
        LinkCutNode na = (LinkCutNode)this.nodes.get(nodeId);
        this.expose(na);
        na.reverseBit();
    }

    public boolean contains(long source, long target) {
        LinkCutNode edge = (LinkCutNode)this.edgeInTree.get(target);
        return edge == null ? false : edge.source() == source;
    }

    public boolean connected(long source, long target) {
        LinkCutNode nodeSource = (LinkCutNode)this.nodes.get(source);
        LinkCutNode nodeTarget = (LinkCutNode)this.nodes.get(target);
        if (nodeTarget == null || nodeSource == null) {
            return false;
        }
        this.expose(nodeSource);
        return nodeSource.equals(nodeTarget.root());
    }

    private void cut(long source, long target) {
        LinkCutNode node = source != target ? (LinkCutNode)this.edgeInTree.get(target) : (LinkCutNode)this.nodes.get(source);
        this.expose(node);
        this.singleNodeFix(node);
        if (node.left() != null) {
            LinkCutNode l = node.left();
            this.addChild(node, null, Direction.LEFT);
            l.setParent(null);
        }
    }

    public void delete(long source, long target) {
        this.evert(source);
        this.cut(source, target);
        this.cut(target, target);
        this.edgeInTree.set(target, null);
    }
}

