/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.steiner;

import com.carrotsearch.hppc.BitSet;
import com.carrotsearch.hppc.LongArrayList;
import com.carrotsearch.hppc.cursors.LongCursor;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.queue.HugeLongPriorityQueue;
import org.neo4j.gds.paths.delta.TentativeDistances;
import org.neo4j.gds.steiner.SteinerBasedDeltaStepping;

class SteinerBasedDeltaTask
implements Runnable {
    private final Graph graph;
    private final HugeLongArray frontier;
    private final TentativeDistances distances;
    private final double delta;
    private int binIndex;
    private final AtomicLong frontierIndex;
    private long frontierLength;
    private LongArrayList[] localBins;
    private SteinerBasedDeltaStepping.Phase phase = SteinerBasedDeltaStepping.Phase.RELAX;
    private final BitSet mergedToSource;
    private final BitSet uninvisitedTerminal;
    private final HugeLongPriorityQueue terminalQueue;
    private final ReentrantLock terminalQueueLock;
    private double smallestConsideredDistance;
    private final int binSizeThreshold;

    SteinerBasedDeltaTask(Graph graph, HugeLongArray frontier, TentativeDistances distances, double delta, AtomicLong frontierIndex, BitSet mergedToSource, HugeLongPriorityQueue terminalQueue, ReentrantLock terminalQueueLock, BitSet uninvisitedTerminal, int binSizeThreshold) {
        this.graph = graph;
        this.frontier = frontier;
        this.distances = distances;
        this.delta = delta;
        this.frontierIndex = frontierIndex;
        this.mergedToSource = mergedToSource;
        this.localBins = new LongArrayList[0];
        this.terminalQueue = terminalQueue;
        this.terminalQueueLock = terminalQueueLock;
        this.uninvisitedTerminal = uninvisitedTerminal;
        this.binSizeThreshold = binSizeThreshold;
    }

    @Override
    public void run() {
        if (this.phase == SteinerBasedDeltaStepping.Phase.RELAX) {
            this.smallestConsideredDistance = Double.MAX_VALUE;
            this.relaxGlobalBin();
            this.relaxLocalBin();
        } else if (this.phase == SteinerBasedDeltaStepping.Phase.SYNC) {
            this.updateFrontier();
        }
    }

    double getSmallestConsideredDistance() {
        return this.smallestConsideredDistance;
    }

    void setPhase(SteinerBasedDeltaStepping.Phase phase) {
        this.phase = phase;
    }

    void setBinIndex(int binIndex) {
        this.binIndex = binIndex;
    }

    void setFrontierLength(long frontierLength) {
        this.frontierLength = frontierLength;
    }

    int minNonEmptyBin() {
        for (int i = this.binIndex; i < this.localBins.length; ++i) {
            if (this.localBins[i] == null || this.localBins[i].isEmpty()) continue;
            return i;
        }
        return Integer.MAX_VALUE;
    }

    private void relaxGlobalBin() {
        long offset;
        while ((offset = this.frontierIndex.getAndAdd(64L)) < this.frontierLength) {
            long limit = Math.min(offset + 64L, this.frontierLength);
            for (long idx = offset; idx < limit; ++idx) {
                long nodeId = this.frontier.get(idx);
                if (!(this.distances.distance(nodeId) >= this.delta * (double)this.binIndex)) continue;
                this.relaxNode(nodeId);
            }
        }
    }

    private void relaxLocalBin() {
        while (this.binIndex < this.localBins.length && this.localBins[this.binIndex] != null && !this.localBins[this.binIndex].isEmpty() && this.localBins[this.binIndex].size() < this.binSizeThreshold) {
            LongArrayList binCopy = this.localBins[this.binIndex].clone();
            this.localBins[this.binIndex].elementsCount = 0;
            binCopy.forEach(this::relaxNode);
        }
    }

    private void relaxNode(long nodeId) {
        this.graph.forEachRelationship(nodeId, 1.0, (sourceNodeId, targetNodeId, weight) -> {
            if (!this.mergedToSource.get(targetNodeId)) {
                this.tryToUpdate(sourceNodeId, targetNodeId, weight);
            }
            return true;
        });
    }

    private void tryToUpdate(long sourceNodeId, long targetNodeId, double weight) {
        double oldDist = this.distances.distance(targetNodeId);
        double newDist = this.distances.distance(sourceNodeId) + weight;
        while (Double.compare(newDist, oldDist) < 0) {
            double witness = this.distances.compareAndExchange(targetNodeId, oldDist, newDist, sourceNodeId);
            if (Double.compare(witness, oldDist) == 0) {
                int destBin = (int)(newDist / this.delta);
                if (destBin >= this.localBins.length) {
                    this.localBins = Arrays.copyOf(this.localBins, destBin + 1);
                }
                if (this.localBins[destBin] == null) {
                    this.localBins[destBin] = new LongArrayList();
                }
                this.localBins[destBin].add(targetNodeId);
                break;
            }
            oldDist = this.distances.distance(targetNodeId);
        }
        this.smallestConsideredDistance = Math.min(newDist, this.smallestConsideredDistance);
        if (this.uninvisitedTerminal.get(targetNodeId)) {
            this.terminalQueueLock.lock();
            if (!this.terminalQueue.containsElement(targetNodeId) || this.terminalQueue.cost(targetNodeId) > newDist) {
                this.terminalQueue.set(targetNodeId, newDist);
            }
            this.terminalQueueLock.unlock();
        }
    }

    private void updateFrontier() {
        if (this.binIndex < this.localBins.length && this.localBins[this.binIndex] != null && !this.localBins[this.binIndex].isEmpty()) {
            int size = this.localBins[this.binIndex].size();
            long offset = this.frontierIndex.getAndAdd(size);
            for (LongCursor longCursor : this.localBins[this.binIndex]) {
                long index = offset + (long)longCursor.index;
                this.frontier.set(index, longCursor.value);
            }
            this.localBins[this.binIndex].elementsCount = 0;
        }
    }
}

