/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.steiner;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.progress.tasks.LeafTask;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.steiner.ShortestPathsSteinerAlgorithm;
import org.neo4j.gds.steiner.SteinerTreeBaseConfig;

public class SteinerTreeAlgorithmFactory<CONFIG extends SteinerTreeBaseConfig>
extends GraphAlgorithmFactory<ShortestPathsSteinerAlgorithm, CONFIG> {
    private List<Long> getTargetNodes(Graph graph, CONFIG configuration) {
        return configuration.targetNodes().stream().map(arg_0 -> ((Graph)graph).safeToMappedNodeId(arg_0)).collect(Collectors.toList());
    }

    public ShortestPathsSteinerAlgorithm build(Graph graphOrGraphStore, CONFIG configuration, ProgressTracker progressTracker) {
        return new ShortestPathsSteinerAlgorithm(graphOrGraphStore, graphOrGraphStore.toMappedNodeId(configuration.sourceNode()), this.getTargetNodes(graphOrGraphStore, configuration), configuration.delta(), configuration.concurrency(), configuration.applyRerouting(), Pools.DEFAULT, progressTracker);
    }

    public String taskName() {
        return "SteinerTree";
    }

    public Task progressTask(Graph graph, CONFIG config) {
        int targetNodesSize = config.targetNodes().size();
        ArrayList<LeafTask> subtasks = new ArrayList<LeafTask>();
        subtasks.add(Tasks.leaf((String)"Traverse", (long)targetNodesSize));
        if (config.applyRerouting()) {
            long nodeCount = graph.nodeCount();
            subtasks.add(Tasks.leaf((String)"Reroute", (long)nodeCount));
        }
        return Tasks.task((String)this.taskName(), subtasks);
    }
}

