/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.topologicalsort;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.RelationshipIterator;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.concurrency.RunWithConcurrency;
import org.neo4j.gds.core.utils.paged.HugeAtomicLongArray;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.topologicalsort.TopologicalSortConfig;
import org.neo4j.gds.topologicalsort.TopologicalSortQueue;
import org.neo4j.gds.topologicalsort.TopologicalSortResult;
import org.neo4j.gds.utils.CloseableThreadLocal;

public class TopologicalSort
extends Algorithm<TopologicalSortResult> {
    private final TopologicalSortResult result;
    private final HugeAtomicLongArray inDegrees;
    private final Graph graph;
    private final long nodeCount;
    private final ExecutorService executor;
    private final int numThreads;
    private final TopologicalSortQueue queue;

    protected TopologicalSort(Graph graph, TopologicalSortConfig config, ExecutorService executor, ProgressTracker progressTracker) {
        super(progressTracker);
        this.graph = graph;
        this.nodeCount = graph.nodeCount();
        this.executor = executor;
        int concurrency = config.concurrency();
        this.numThreads = this.nodeCount < (long)concurrency ? 1 : concurrency;
        this.result = new TopologicalSortResult(this.nodeCount);
        this.queue = new TopologicalSortQueue(this.nodeCount, this.numThreads);
        this.inDegrees = HugeAtomicLongArray.newArray((long)this.nodeCount);
    }

    public TopologicalSortResult compute() {
        this.progressTracker.beginSubTask("TopologicalSort");
        this.initializeInDegrees();
        this.addFirstSources();
        this.performParallelSourcesSteps();
        this.progressTracker.endSubTask("TopologicalSort");
        return this.result;
    }

    public void release() {
    }

    private void initializeInDegrees() {
        try (CloseableThreadLocal concurrentCopy = CloseableThreadLocal.withInitial(() -> this.graph.concurrentCopy());){
            ParallelUtil.parallelForEachNode((Graph)this.graph, (int)this.numThreads, nodeId -> ((Graph)concurrentCopy.get()).forEachRelationship(nodeId, (source, target) -> {
                this.inDegrees.getAndAdd(target, 1L);
                return true;
            }));
        }
    }

    private void addFirstSources() {
        ParallelUtil.parallelForEachNode((long)this.nodeCount, (int)this.numThreads, nodeId -> {
            if (this.inDegrees.get(nodeId) == 0L) {
                this.queue.add(nodeId);
                this.result.addNode(nodeId);
            }
        });
    }

    private void performParallelSourcesSteps() {
        ArrayList<WorkerThread> tasks = new ArrayList<WorkerThread>(this.numThreads);
        for (int i = 0; i < this.numThreads; ++i) {
            WorkerThread t = new WorkerThread(i);
            tasks.add(t);
        }
        RunWithConcurrency.builder().concurrency(this.numThreads).tasks(tasks).waitTime(1L, TimeUnit.MICROSECONDS).terminationFlag(this.terminationFlag).executor(this.executor).run();
    }

    private void performStep(RelationshipIterator iter, long sourceId) {
        iter.forEachRelationship(sourceId, (source, target) -> {
            long prevDegree = this.inDegrees.getAndAdd(target, -1L);
            if (prevDegree == 1L) {
                this.queue.add(target);
                this.result.addNode(target);
            }
            return true;
        });
    }

    class WorkerThread
    implements Runnable {
        private final int threadId;
        private final RelationshipIterator iter;

        WorkerThread(int threadId) {
            this.threadId = threadId;
            this.iter = TopologicalSort.this.graph.concurrentCopy();
        }

        @Override
        public void run() {
            long sourceId = TopologicalSort.this.queue.peekBy(this.threadId);
            while (sourceId > -1L) {
                TopologicalSort.this.performStep(this.iter, sourceId);
                TopologicalSort.this.queue.popBy(this.threadId);
                sourceId = TopologicalSort.this.queue.peekBy(this.threadId);
            }
        }
    }
}

